/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class GenericFilter
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Basic/Generic";
    public static final String CREATOR_PATH_MONITOR = "Built-In/Basic/Monitor";
    private final String name;
    private final List<String> agents;
    private final List<String> channels;
    private final String delimeter;
    private final boolean agentTabs;
    private final List<String> fields;
    private HashMap<String, String> display2origin;

    @Create(category="AgentChannelsFilter", name="Configurable generic filter", path="Built-In/Basic/Generic", description="Channels filter that leaves paths unchanged (except for possibly replacing delimeters with slashes and inserting doupbe slashes to separate pages), but allows selecting desired subsystems, channels, and monitor fields.")
    public GenericFilter(@Par(def="_null_", desc="Filter name. Optional.") String name, @Par(def="_null_", desc="List of subsystems accepted by this filter. If not specified, all subsystems are accepted.") List<String> agents, @Par(def="_null_", desc="List of channels accepted by this filter (may contain templates and selectors). If not specified, all subsystems are accepted.") List<String> channels, @Par(def="_null_", desc="Character in the original channel path that should be replaced by a slash (and therefore used as a path delimeter).") String delimeter, @Par(def="false", desc="If true, the first slash in the path is replaced by a double slash. This causes some monitoring views display each subsystem data in a separate tab.") boolean separatePagesForAgents, @Par(def="_null_", desc="List of fields to display in monitor views. If not specified, the default set of fields is displayed. The default depends on a specific view. Some views may ignore the list of fields suggested by the filter. Available standard fields: VALUE, UNITS, LOW_ALARM, LOW_WARN, ALERT_LOW, HIGH_ALARM, HIGH_WARN, ALERT_HIGH, DESCR.") List<String> fields) {
        this.name = name;
        this.agents = agents == null ? null : new ArrayList<String>(agents);
        ArrayList<String> arrayList = this.channels = channels == null ? null : new ArrayList<String>(channels);
        if (delimeter == null || delimeter.isEmpty()) {
            this.delimeter = null;
        } else {
            String s = delimeter.trim();
            this.delimeter = s.length() > 2 && s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : Pattern.quote(delimeter);
            this.display2origin = new HashMap();
        }
        this.agentTabs = separatePagesForAgents;
        this.fields = fields == null ? null : new ArrayList<String>(fields);
    }

    public GenericFilter(String name, String agents, String channels, String delimeter, boolean separatePagesForAgents, String fields) {
        this(name, GenericFilter.toList(agents), GenericFilter.toList(channels), delimeter, separatePagesForAgents, GenericFilter.toFieldsList(fields));
    }

    private static List<String> toList(String s) {
        if (s.trim().isEmpty()) {
            return null;
        }
        if (s.trim().equals("\"\"")) {
            return Collections.emptyList();
        }
        String[] ss = s.split(",");
        ArrayList<String> out = new ArrayList<String>(ss.length);
        for (String x : ss) {
            out.add(x.trim());
        }
        return out;
    }

    private static List<String> toFieldsList(String fields) {
        if (fields == null || fields.trim().isEmpty()) {
            return null;
        }
        if (fields.equals("\"\"")) {
            return Collections.singletonList("VALUE");
        }
        String[] ss = fields.split(",");
        ArrayList<String> out = new ArrayList<String>(ss.length);
        for (String s : ss) {
            out.add(s.trim());
        }
        return out;
    }

    @Override
    public String getDisplayPath(String originPath) {
        String displayPath;
        if (this.delimeter == null) {
            displayPath = this.agentTabs ? originPath.replaceFirst("/", "//") : originPath;
        } else {
            int i = originPath.indexOf("/");
            String agent = originPath.substring(0, i);
            String localPath = originPath.substring(i + 1);
            localPath = localPath.replaceAll(this.delimeter, "/");
            displayPath = this.agentTabs ? agent + "//" + localPath : agent + "/" + localPath;
            this.display2origin.putIfAbsent(displayPath, originPath);
        }
        return displayPath;
    }

    @Override
    public String getOriginPath(String displayPath) {
        if (this.delimeter == null) {
            if (this.agentTabs) {
                return displayPath.replaceFirst("//", "/");
            }
            return displayPath;
        }
        return this.display2origin.get(displayPath);
    }

    @Override
    public List<String> getOriginChannels() {
        return this.channels;
    }

    @Override
    public List<String> getAgents() {
        return this.agents;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? null : this.fields;
    }

    @Create(category="AgentChannelsFilter", name="Monitor channels", path="Built-In/Basic/Monitor", description="Channels filter that leaves paths unchanged (except for possibly replacing delimeters with slashes and inserting doupbe slashes to separate pages), but accepts only monitored channels.")
    public static AgentChannelsFilter filterMonitorOnly(@Par(def="Monitored channels", desc="Filter name.") String name, @Par(def="_null_", desc="List of subsystems accepted by this filter. If not specified, all subsystems are accepted.") List<String> agents, @Par(def="_null_", desc="Character in the original channel path that should be replaced by a slash (and therefore used as a path delimeter).") String delimeter, @Par(def="false", desc="If true, the first slash in the path is replaced by a double slash. This causes some monitoring views display each subsystem data in a separate tab.") boolean separatePagesForAgents, @Par(def="_null_", desc="List of fields to display in monitor views. If not specified, the default set of fields is displayed. The default depends on a specific view. Some views may ignore the list of fields suggested by the filter.") List<String> fields) {
        return new GenericFilter(name, agents, Collections.singletonList(AgentChannel.Key.FORMAT), delimeter, separatePagesForAgents, fields);
    }
}

