/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen.bean;

import com.mchange.v2.codegen.CodegenUtils;
import com.mchange.v2.codegen.IndentedWriter;
import com.mchange.v2.codegen.bean.BeangenUtils;
import com.mchange.v2.codegen.bean.ClassInfo;
import com.mchange.v2.codegen.bean.GeneratorExtension;
import com.mchange.v2.codegen.bean.Property;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ExplicitPropsConstructorGeneratorExtension
implements GeneratorExtension {
    static final MLogger logger = MLog.getLogger(ExplicitPropsConstructorGeneratorExtension.class);
    String[] propNames;
    boolean skips_silently = false;
    int ctor_modifiers = 1;

    public ExplicitPropsConstructorGeneratorExtension() {
    }

    public ExplicitPropsConstructorGeneratorExtension(String[] propNames) {
        this.propNames = propNames;
    }

    public String[] getPropNames() {
        return (String[])this.propNames.clone();
    }

    public void setPropNames(String[] propNames) {
        this.propNames = (String[])propNames.clone();
    }

    public boolean isSkipsSilently() {
        return this.skips_silently;
    }

    public void setsSkipsSilently(boolean skips_silently) {
        this.skips_silently = skips_silently;
    }

    public Collection extraGeneralImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraSpecificImports() {
        return Collections.EMPTY_SET;
    }

    public Collection extraInterfaceNames() {
        return Collections.EMPTY_SET;
    }

    public void generate(ClassInfo info, Class superclassType, Property[] props, Class[] propTypes, IndentedWriter iw) throws IOException {
        HashMap<String, Property> propNamesToProps = new HashMap<String, Property>();
        int len = props.length;
        for (int i = 0; i < len; ++i) {
            propNamesToProps.put(props[i].getName(), props[i]);
        }
        ArrayList<Property> subPropsList = new ArrayList<Property>(this.propNames.length);
        int len2 = this.propNames.length;
        for (int i = 0; i < len2; ++i) {
            Property p = (Property)propNamesToProps.get(this.propNames[i]);
            if (p == null) {
                logger.warning("Could not include property '" + this.propNames[i] + "' in explicit-props-constructor generated for bean class '" + info.getClassName() + "' because the property is not defined for the bean. Skipping.");
                continue;
            }
            subPropsList.add(p);
        }
        if (subPropsList.size() > 0) {
            Property[] subProps = subPropsList.toArray(new Property[subPropsList.size()]);
            iw.print(CodegenUtils.getModifierString(this.ctor_modifiers));
            iw.print(info.getClassName() + "( ");
            BeangenUtils.writeArgList(subProps, true, iw);
            iw.println(" )");
            iw.println("{");
            iw.upIndent();
            int len3 = subProps.length;
            for (int i = 0; i < len3; ++i) {
                iw.print("this." + subProps[i].getName() + " = ");
                String setExp = subProps[i].getDefensiveCopyExpression();
                if (setExp == null) {
                    setExp = subProps[i].getName();
                }
                iw.println(setExp + ';');
            }
            iw.downIndent();
            iw.println("}");
        }
    }
}

