/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorCommandSender;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorPlatformGUI;
import org.lsst.ccs.subsystem.motorplatform.gui.MotorReplyReceiver;

@Plugin(name="MotorPlatformGUI", description="Generic motor control for motorized platforms.")
public class MotorPlatformPlugin
extends ConsolePlugin
implements AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(MotorPlatformPlugin.class.getName());
    private volatile MotorPlatformGUI gui;
    private volatile MotorReplyReceiver replyHandler;
    private volatile JScrollPane pane;
    private volatile PanelManager pm;

    public void initialize() {
        this.pm = this.getConsole().getPanelManager();
        AbstractAction openMotorplatformGui = new AbstractAction("Motorplatform"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MotorPlatformPlugin.this.gui == null) {
                    MotorPlatformPlugin.this.gui = new MotorPlatformGUI();
                    MotorPlatformPlugin.this.replyHandler = new MotorReplyReceiver(MotorPlatformPlugin.this.getConsole().getMessagingAccess(), MotorPlatformPlugin.this.gui);
                    MotorPlatformPlugin.this.pane = new JScrollPane(MotorPlatformPlugin.this.gui);
                    MotorPlatformPlugin.this.pm.open((Component)MotorPlatformPlugin.this.pane, "Motorized Platform Control Panel");
                    MotorPlatformPlugin.this.initTask();
                } else {
                    MotorPlatformPlugin.this.closeMonitorGUI();
                }
            }
        };
        this.pm.addListener(e -> {
            if (e.hasKey((Object)Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue() && e.getSource().equals(this.pane)) {
                this.closeMonitorGUI();
                openMotorplatformGui.putValue("SwingSelectedKey", false);
            }
        });
        openMotorplatformGui.putValue("SwingSelectedKey", false);
        this.getServices().addMenu((Action)openMotorplatformGui, new String[]{"CCS Subsystems"});
    }

    private void closeMonitorGUI() {
        this.pm.close((Component)this.pane);
        this.pane = null;
        this.replyHandler.stopListening();
        this.closeTask();
        this.gui = null;
    }

    private void initTask() {
        MotorCommandSender sender = new MotorCommandSender(this.getConsole().getMessagingAccess(), this.replyHandler);
        this.gui.init(sender, this.replyHandler);
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    private void closeTask() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        if (this.gui != null) {
            this.closeTask();
        }
    }

    public void connected(AgentInfo ... agentArray) {
        for (AgentInfo agent : agentArray) {
            if (!agent.hasAgentProperty("motorplatform.type")) continue;
            this.gui.addSubsystem(agent.getName());
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty("motorplatform.type")) continue;
            this.gui.removeSubsystem(agent.getName());
        }
    }
}

