/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import org.apache.commons.net.telnet.TelnetClient;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class Session {
    public static final int OPTN_KEEP_ALIVE = 1;
    private static final int TELNET_PORT = 23;
    private static final int CONN_TIMEOUT = 2000;
    private static final int SOCKET_TIMEOUT = 20;
    private static final int POLL_PERIOD = 10;
    private static final int INITIAL_TIMEOUT = 2000;
    private static final int FINAL_TIMEOUT = 200;
    private static final int LOG_TIMEOUT_INCR = 100;
    private final int options;
    private final String sessnPrompt;
    private final String unamePrompt;
    private final String passwdPrompt;
    private final String exitCommand;
    private final Ascii.Terminator terminator;
    private final Ascii asc = new Ascii();
    private final TelnetClient tc = new TelnetClient();
    private ConnType connType;
    private String ident;
    private String username;
    private String password;
    private int baudRate;
    private boolean isTelnet;
    private int connTimeout = 2000;
    private int initTimeout = 2000;
    private int finalTimeout = 200;
    private int logTimeout;
    private int runTimeout;
    private InputStream in;
    private OutputStream out;
    private String prompt = "";
    private boolean usePrompt = false;
    private boolean debug = false;

    public Session(int options, String sessnPrompt, String unamePrompt, String passwdPrompt, String exitCommand, Ascii.Terminator terminator) {
        this.asc.setOptions(Ascii.Option.NO_NET);
        this.options = options;
        this.sessnPrompt = sessnPrompt;
        this.unamePrompt = unamePrompt;
        this.passwdPrompt = passwdPrompt;
        this.exitCommand = exitCommand;
        this.terminator = terminator;
    }

    public void open(ConnType connType, String ident, int baudRate, String username, String password, int logTimeout, int runTimeout) throws DriverException {
        this.open(connType, ident, baudRate, runTimeout);
        this.username = username;
        this.password = password;
        this.logTimeout = logTimeout;
        this.usePrompt = false;
        try {
            this.finalTimeout = runTimeout;
            if (this.isTelnet) {
                this.receive();
            } else {
                this.receive("");
                if (this.prompt.isEmpty()) {
                    this.receive("");
                }
                if (this.prompt.contains(this.sessnPrompt)) {
                    return;
                }
            }
            if (!this.prompt.contains(this.unamePrompt)) {
                throw new DriverException("Unrecognized login prompt: " + this.prompt);
            }
            this.receive(username);
            if (!this.prompt.contains(this.passwdPrompt)) {
                throw new DriverException("Unrecognized password prompt: " + this.prompt);
            }
            this.finalTimeout = Math.min(logTimeout, 100);
            int ntry = logTimeout / this.finalTimeout + 1;
            this.send(password);
            for (int j = 0; j < ntry && this.receive().length == 0; ++j) {
                if (j != ntry - 1) continue;
                throw new DriverException("Login failed");
            }
            this.finalTimeout = runTimeout;
            this.usePrompt = true;
        }
        catch (DriverException e) {
            this.close();
            throw e;
        }
    }

    public void open(ConnType connType, String ident, int baudRate, int runTimeout) throws DriverException {
        this.connType = connType;
        this.ident = ident;
        this.baudRate = baudRate;
        this.runTimeout = runTimeout;
        this.username = null;
        this.password = null;
        DriverConstants.ConnType cType = connType.getValue();
        if (cType != null) {
            this.isTelnet = false;
            this.asc.open(cType, ident, baudRate);
            this.asc.setTerminator(this.terminator);
            this.asc.setTimeout(this.initTimeout);
        } else {
            this.isTelnet = true;
            if (this.in != null) {
                throw new DriverException("Connection already open");
            }
            try {
                this.tc.setConnectTimeout(this.connTimeout);
                this.tc.connect(ident, 23);
                this.tc.setSoTimeout(20);
                this.in = this.tc.getInputStream();
                this.out = this.tc.getOutputStream();
            }
            catch (IOException e) {
                throw new DriverException((Throwable)e);
            }
        }
        this.finalTimeout = runTimeout;
        this.usePrompt = true;
    }

    public void close() throws DriverException {
        this.checkOpen();
        if (this.exitCommand != null) {
            try {
                this.send(this.exitCommand);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        try {
            if (this.isTelnet) {
                this.tc.disconnect();
            } else {
                this.asc.close();
            }
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
        finally {
            this.prompt = "";
            this.in = null;
            this.out = null;
            this.isTelnet = false;
        }
    }

    public boolean isOpen() {
        return this.isTelnet && this.in != null || !this.isTelnet && this.asc.isOpen();
    }

    public synchronized void send(String command) throws DriverException {
        this.checkOpen();
        if (this.debug) {
            System.out.println("Command (" + command.length() + ") = " + command);
        }
        if (this.isTelnet) {
            try {
                this.out.write((command + "\r").getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                throw new DriverException((Throwable)e);
            }
        } else {
            this.asc.flush();
            this.asc.write(command);
        }
    }

    public synchronized String[] receive() throws DriverException {
        this.checkOpen();
        ArrayList<String> resp = new ArrayList<String>();
        int timeout = this.initTimeout;
        byte[] buff = new byte[1024];
        String line = "";
        boolean gotData = false;
        boolean gotCr = false;
        boolean gotTimeout = false;
        do {
            int leng = 0;
            try {
                leng = this.read(buff, 0, buff.length, timeout);
                gotData = true;
                if (this.debug) {
                    System.out.println("Read length = " + leng);
                }
            }
            catch (DriverTimeoutException e) {
                if (!gotData) {
                    throw e;
                }
                gotTimeout = true;
            }
            int start = 0;
            for (int posn = 0; posn < leng; ++posn) {
                if (buff[posn] == 13) {
                    if (!gotCr) {
                        line = line + new String(buff, start, posn - start);
                        if (this.debug) {
                            System.out.println("Line (" + line.length() + ") = " + line);
                        }
                        resp.add(line);
                        line = "";
                    }
                    start = posn + 1;
                    gotCr = true;
                    continue;
                }
                if (buff[posn] == 10 && gotCr) {
                    start = posn + 1;
                }
                gotCr = false;
            }
            line = line + new String(buff, start, leng - start);
            if (this.usePrompt) {
                if (!line.startsWith(this.sessnPrompt)) continue;
                break;
            }
            timeout = this.finalTimeout;
        } while (!gotTimeout);
        this.prompt = line;
        if (this.debug) {
            System.out.println("Prompt (" + line.length() + ") = " + line);
        }
        return resp.toArray(new String[0]);
    }

    public synchronized String[] receive(String command) throws DriverException {
        try {
            this.send(command);
            return this.receive();
        }
        catch (DriverException e) {
            if ((this.options & 1) != 0 && e.getCause() instanceof SocketException) {
                try {
                    this.close();
                }
                catch (DriverException driverException) {
                    // empty catch block
                }
                try {
                    if (this.username == null) {
                        this.open(this.connType, this.ident, this.baudRate, this.runTimeout);
                    } else {
                        this.open(this.connType, this.ident, this.baudRate, this.username, this.password, this.logTimeout, this.runTimeout);
                    }
                }
                catch (DriverException eo) {
                    throw e;
                }
                this.send(command);
                return this.receive();
            }
            throw e;
        }
    }

    public synchronized void setConnTimeout(int timeout) {
        this.connTimeout = timeout;
    }

    public void setTimeout(int timeout) throws DriverException {
        this.initTimeout = timeout;
        this.asc.setTimeout(this.initTimeout);
    }

    public void setCharTimeout(int timeout) throws DriverException {
        this.finalTimeout = timeout;
        this.asc.setTimeout(this.finalTimeout);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    private void checkOpen() throws DriverException {
        if (!this.isOpen()) {
            throw new DriverException("Connection not open");
        }
    }

    public static void checkReplyLength(String[] reply, int count) throws DriverException {
        if (reply.length == count) {
            return;
        }
        if (reply.length == 0) {
            throw new DriverException("Missing response");
        }
        throw new DriverException("Incorrect response length: " + reply.length + "; first line = " + reply[0]);
    }

    public static void responseError(String resp) throws DriverException {
        throw new DriverException("Incorrect response: " + resp);
    }

    private int read(byte[] buff, int offset, int mleng, int timeout) throws DriverException {
        if (this.isTelnet) {
            long endTime = System.currentTimeMillis() + (long)timeout;
            int count = Math.min(mleng, buff.length - offset);
            int leng = 0;
            while (leng == 0 && System.currentTimeMillis() < endTime) {
                try {
                    leng = this.in.read(buff, offset, count);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException e) {
                    throw new DriverException((Throwable)e);
                }
                if (leng < 0) {
                    throw new DriverException((Throwable)new SocketException("Connection closed remotely"));
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (leng == 0) {
                throw new DriverTimeoutException("Read timed out");
            }
            return leng;
        }
        this.asc.setTimeout(timeout);
        return this.asc.readBytes(buff, offset, mleng);
    }

    public static enum ConnType {
        TELNET(null),
        FTDI(DriverConstants.ConnType.FTDI),
        SERIAL(DriverConstants.ConnType.SERIAL);

        private final DriverConstants.ConnType connType;

        private ConnType(DriverConstants.ConnType connType) {
            this.connType = connType;
        }

        DriverConstants.ConnType getValue() {
            return this.connType;
        }
    }
}

