/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.ui.commons.ControllerStatePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTruckPanel
extends JPanel {
    private static final long serialVersionUID = 6421842448844475453L;
    private final String truckName;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel cajLabel = new JLabel("Truck position");
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel();
    private final JLabel handoffSensorsErrorjLabel = new JLabel();
    private final JLabel onlineSensorsErrorjLabel = new JLabel();
    private final JLabel standbySensorsErrorjLabel = new JLabel();
    private static final String ERROR_IN_SENSORS = "SENSORS ERROR";
    private static final String NO_ERROR_IN_SENSORS = "NO ERROR";
    private final JProgressBar positionProgressBar = new JProgressBar(1, 0, 500);
    private final ControllerStatePanel controllerPanel;

    public AutochangerTruckPanel(String truckName) {
        this.truckName = truckName;
        String controllerName = truckName.contains("Xminus") ? "acTruckXminusController" : "acTruckXplusController";
        this.controllerPanel = new ControllerStatePanel(controllerName, true);
        this.initComponents();
    }

    public void initializeGui(int standbyPosition, int onlinePosition) {
        SwingUtilities.invokeLater(new GuiInitializationFromConfigInfo(standbyPosition, onlinePosition));
    }

    public void updateTruck(StatusDataPublishedByAutochangerTruck status) {
        SwingUtilities.invokeLater(new UpdateTruck(status));
    }

    public void updateController(StatusDataPublishedByEPOSController s) {
        this.controllerPanel.update(s);
    }

    private void initComponents() {
        this.setDefaultValues();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW, 2), this.truckName));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.cajLabel.setFont(Tools.BIG_FONT);
        this.cajLabel.setText("<HTML><CENTER>" + this.truckName + "<BR>position</CENTER></HTML>");
        this.add((Component)this.cajLabel, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.standbyjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.standbyDigitalSwitch, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.inTraveljLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.inTravelDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.handoffjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.handoffDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.onlinejLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.onlineDigitalSwitch, gbc);
        gbc.anchor = 10;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.fill = 3;
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.positionProgressBar.setBorderPainted(true);
        this.positionProgressBar.setValue(0);
        this.positionProgressBar.setStringPainted(true);
        this.add((Component)this.positionProgressBar, gbc);
        gbc.gridheight = 1;
        JPanel errorjPanel = new JPanel();
        errorjPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.inErrorDigitalSwitch.setSize(30);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        errorjPanel.add((Component)this.inErrorDigitalSwitch, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.inErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.standbySensorsErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.handoffSensorsErrorjLabel, gbc1);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.gridheight = 1;
        this.add((Component)errorjPanel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.controllerPanel, gbc);
    }

    private void setDefaultValues() {
        this.standbyDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.onlineDigitalSwitch.setColor(Color.gray);
        this.inErrorDigitalSwitch.setColor(Color.GRAY);
        this.inErrorjLabel.setText(NO_ERROR_IN_SENSORS);
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.controllerPanel.resetPanel();
    }

    public static void main(String[] argv) {
        AutochangerTruckPanel d = new AutochangerTruckPanel("acTruckXminus");
        JFrame frame = new JFrame("Autochanger Truck Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class GuiInitializationFromConfigInfo
    implements Runnable {
        private final int standbyPosition;
        private final int onlinePosition;

        public GuiInitializationFromConfigInfo(int standbyPosition, int onlinePosition) {
            this.standbyPosition = standbyPosition;
            this.onlinePosition = onlinePosition;
        }

        @Override
        public void run() {
            AutochangerTruckPanel.this.positionProgressBar.setMinimum(this.standbyPosition);
            AutochangerTruckPanel.this.positionProgressBar.setMaximum(this.onlinePosition);
        }
    }

    class UpdateTruck
    implements Runnable {
        private final StatusDataPublishedByAutochangerTruck s;

        public UpdateTruck(StatusDataPublishedByAutochangerTruck status) {
            this.s = status;
        }

        private void updateErrorComponents() {
            if (this.s.isHandoffInError() || this.s.isOnlineInError() || this.s.isStandbyInError()) {
                AutochangerTruckPanel.this.inErrorDigitalSwitch.setColor(Color.RED);
                AutochangerTruckPanel.this.inErrorjLabel.setText(AutochangerTruckPanel.ERROR_IN_SENSORS);
            } else {
                AutochangerTruckPanel.this.inErrorDigitalSwitch.setColor(Tools.greenColor);
                AutochangerTruckPanel.this.inErrorjLabel.setText(AutochangerTruckPanel.NO_ERROR_IN_SENSORS);
            }
            AutochangerTruckPanel.this.handoffSensorsErrorjLabel.setText(this.s.isHandoffInError() ? "<HTML>Handoff sensors<BR>in error</HTML>" : null);
            AutochangerTruckPanel.this.onlineSensorsErrorjLabel.setText(this.s.isOnlineInError() ? "<HTML>Online sensors<BR>in error</HTML>" : null);
            AutochangerTruckPanel.this.standbySensorsErrorjLabel.setText(this.s.isStandbyInError() ? "<HTML>Standby sensors<BR>in error</HTML>" : null);
        }

        @Override
        public void run() {
            AutochangerTruckPanel.this.handoffDigitalSwitch.updateColor(this.s.isHandoffInError(), this.s.getHandoffSensorValue());
            AutochangerTruckPanel.this.onlineDigitalSwitch.updateColor(this.s.isOnlineInError(), this.s.getOnlineSensorValue());
            AutochangerTruckPanel.this.standbyDigitalSwitch.updateColor(this.s.isStandbyInError(), this.s.getStandbySensorValue());
            AutochangerTruckPanel.this.inTravelDigitalSwitch.setColor(!this.s.getHandoffSensorValue() && !this.s.getOnlineSensorValue() && !this.s.getStandbySensorValue() ? Color.YELLOW : Color.gray);
            this.updateErrorComponents();
            AutochangerTruckPanel.this.positionProgressBar.setValue(this.s.getPosition());
            AutochangerTruckPanel.this.positionProgressBar.setForeground(Color.PINK);
        }
    }
}

