/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import java.util.Locale;
import org.hsqldb.Table;
import org.hsqldb.map.ValuePool;
import org.hsqldb.resources.ResourceBundleHandler;

final class DITableInfo {
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    static final short tableIndexOther = 3;
    private static final int HALF_MAX_INT = 0x3FFFFFFF;
    private int hnd_column_remarks = -1;
    private int hnd_table_remarks = -1;
    private Table table;

    DITableInfo() {
        this.setupBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupBundles() {
        Class<ResourceBundleHandler> clazz = ResourceBundleHandler.class;
        synchronized (ResourceBundleHandler.class) {
            Locale locale = ResourceBundleHandler.getLocale();
            ResourceBundleHandler.setLocale(Locale.getDefault());
            this.hnd_column_remarks = ResourceBundleHandler.getBundleHandle("info-column-remarks", null);
            this.hnd_table_remarks = ResourceBundleHandler.getBundleHandle("info-table-remarks", null);
            ResourceBundleHandler.setLocale(locale);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    Integer getBRIPseudo() {
        return ValuePool.getInt(this.bestRowNotPseudo);
    }

    Integer getBRIScope() {
        return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
    }

    String getColName(int n) {
        return this.table.getColumn((int)n).getName().name;
    }

    String getColRemarks(int n) {
        if (this.table.getTableType() != 1) {
            return this.table.getColumn((int)n).getName().comment;
        }
        String string = this.getName() + "_" + this.getColName(n);
        return ResourceBundleHandler.getString(this.hnd_column_remarks, string);
    }

    String getHsqlType() {
        switch (this.table.getTableType()) {
            case 1: 
            case 3: 
            case 4: {
                return "MEMORY";
            }
            case 5: {
                return "CACHED";
            }
            case 6: 
            case 7: {
                return "TEXT";
            }
        }
        return null;
    }

    String getName() {
        return this.table.getName().name;
    }

    String getRemark() {
        return this.table.getTableType() == 1 ? ResourceBundleHandler.getString(this.hnd_table_remarks, this.getName()) : this.table.getName().comment;
    }

    String getJDBCStandardType() {
        switch (this.table.getTableType()) {
            case 8: {
                return "VIEW";
            }
            case 3: 
            case 6: {
                return "GLOBAL TEMPORARY";
            }
            case 1: {
                return "SYSTEM TABLE";
            }
        }
        if (this.table.getOwner().isSystem()) {
            return "SYSTEM TABLE";
        }
        return "TABLE";
    }

    Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }
}

