/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAccelerometer;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AcceleroPanel
extends JPanel {
    private JTable accelTable;
    private JScrollPane jScrollPane;
    private final DecimalFormat formatter = new DecimalFormat("#####0.00");

    public AcceleroPanel() {
        this.initComponents();
    }

    public void updateAccelero(StatusDataPublishedByAccelerometer s) {
        SwingUtilities.invokeLater(new UpdateAccelero(s));
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.accelTable = new JTable();
        this.accelTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "X AXE", "Y AXE", "Z AXE"}){
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.accelTable.setName("accelTable");
        DefaultTableModel accelTableModel = (DefaultTableModel)this.accelTable.getModel();
        Object[] row1 = new Object[]{"ANGULAR VELOCITY", 0, 0, 0};
        accelTableModel.addRow(row1);
        Object[] row2 = new Object[]{"ACCELERATION", 0, 0, 0};
        accelTableModel.addRow(row2);
        accelTableModel.fireTableDataChanged();
        int rowNB = this.accelTable.getModel().getRowCount();
        for (int i = 0; i < rowNB; ++i) {
            TableColumn column = this.accelTable.getColumnModel().getColumn(i);
            if (i != 0) continue;
            column.setPreferredWidth(150);
        }
        this.jScrollPane.setPreferredSize(new Dimension(500, 60));
        this.jScrollPane.setViewportView(this.accelTable);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.NICE_PINK), "Back Flange Accelerometer"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jScrollPane, gbc);
    }

    public void resetPanel() {
        Tools.resetTable(this.accelTable);
    }

    public static void main(String[] argv) {
        AcceleroPanel p = new AcceleroPanel();
        JFrame frame = new JFrame("Accelero Values");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateAccelero
    implements Runnable {
        private StatusDataPublishedByAccelerometer s;

        public UpdateAccelero(StatusDataPublishedByAccelerometer status) {
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel filterTableModel = (DefaultTableModel)AcceleroPanel.this.accelTable.getModel();
            AcceleroPanel.this.accelTable.setValueAt(AcceleroPanel.this.formatter.format(this.s.getAngularVelocityX()), 0, 1);
            AcceleroPanel.this.accelTable.setValueAt(AcceleroPanel.this.formatter.format(this.s.getAngularVelocityY()), 0, 2);
            AcceleroPanel.this.accelTable.setValueAt(AcceleroPanel.this.formatter.format(this.s.getAngularVelocityZ()), 0, 3);
            AcceleroPanel.this.accelTable.setValueAt(AcceleroPanel.this.formatter.format(this.s.getAccelerationX()), 1, 1);
            AcceleroPanel.this.accelTable.setValueAt(AcceleroPanel.this.formatter.format(this.s.getAccelerationY()), 1, 2);
            AcceleroPanel.this.accelTable.setValueAt(AcceleroPanel.this.formatter.format(this.s.getAccelerationZ()), 1, 3);
            filterTableModel.fireTableDataChanged();
        }
    }
}

