/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

public class VacControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final int SWTP_PUMP = 0;
    private static final int SWTP_VALVE = 1;
    private static final Map<Integer, String> switchMap = new LinkedHashMap<Integer, String>();
    private static final int[] switchTypes;
    private static final Map<Integer, String> latchMap;
    private static final Map<Integer, String> conditionMap;
    private static final int PLC_STATE_WIDTH;
    private static final int CRYO_STATE_WIDTH;
    private static final int HX_STATE_WIDTH;
    private static final int SWITCH_STATE_WIDTH;
    private static final int LATCH_STATE_WIDTH;
    private static final int COND_STATUS_WIDTH;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel sysStatPanel;
    private final JPanel headPanel = new JPanel();
    private JLabel plcStateValue;
    private JLabel cryoStateValue;
    private JLabel hxStateValue;
    private JPanel switchPanel;
    private final JLabel[] switchLabel = new JLabel[23];
    private final JLabel[] switchStatus = new JLabel[23];
    private final ButtonGroup[] switchBG = new ButtonGroup[23];
    private final JRadioButton[] switchOffRB = new JRadioButton[23];
    private final JRadioButton[] switchOnRB = new JRadioButton[23];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[8];
    private final JLabel[] latchStatus = new JLabel[8];
    private final JButton[] latchResetBtn = new JButton[8];
    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[10];
    private final JLabel[] conditionStatus = new JLabel[10];
    private volatile VacSysState vacState;
    private final Object vacStateLock = new Object();
    private static final long serialVersionUID = 1L;

    public VacControlPanel(String subsys) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getVacuumState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePanel(VacSysState vss) {
        Object object = this.vacStateLock;
        synchronized (object) {
            this.vacState = vss;
            SwingUtilities.invokeLater(new UpdateVacState(vss));
        }
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        Object bg;
        this.sysStatPanel = new SystemStatusPanel(this.sender, "MonitorControl");
        this.plcStateValue = UiUtilities.newLabel((String)"X", (int)PLC_STATE_WIDTH);
        this.cryoStateValue = UiUtilities.newLabel((String)"X", (int)CRYO_STATE_WIDTH);
        this.hxStateValue = UiUtilities.newLabel((String)"X", (int)HX_STATE_WIDTH);
        for (int sw : switchMap.keySet()) {
            if (sw < 0) continue;
            this.switchLabel[sw] = UiUtilities.newLabel((String)(switchMap.get(sw) + ":"), (int)0);
            this.switchStatus[sw] = UiUtilities.newLabel((String)"X", (int)SWITCH_STATE_WIDTH);
            int swType = switchTypes[sw];
            boolean confirmDialog = sw == 7 || sw == 12;
            this.switchOffRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "Off" : "Shut", "S" + sw);
            this.switchOnRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "On" : "Open", "O" + sw, confirmDialog);
            this.switchBG[sw] = new ButtonGroup();
            bg = this.switchBG[sw];
            ((ButtonGroup)bg).add(this.switchOffRB[sw]);
            ((ButtonGroup)bg).add(this.switchOnRB[sw]);
        }
        for (int cond : latchMap.keySet()) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchMap.get(cond) + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"X", (int)LATCH_STATE_WIDTH);
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", "R" + cond, true);
        }
        for (int cond : conditionMap.keySet()) {
            this.conditionLabel[cond] = UiUtilities.newLabel((String)(conditionMap.get(cond) + ":"), (int)0);
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"X", (int)COND_STATUS_WIDTH);
        }
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        gbh.insets.left = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"PLC State: ", (int)0), gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.plcStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Cryo Vac State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.cryoStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"HX Vac State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.hxStateValue, gbh);
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Switches");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        gbs.gridy = 0;
        int colm = 0;
        int nRows = (switchMap.size() + 1) / 2;
        bg = switchMap.keySet().iterator();
        while (bg.hasNext()) {
            int sw = (Integer)bg.next();
            if (sw >= 0) {
                gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
                gbs.insets.left = colm == 0 ? 4 : 40;
                gbs.gridx = 4 * colm;
                this.switchPanel.add((Component)this.switchLabel[sw], gbs);
                gbs.insets.left = 4;
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchStatus[sw], gbs);
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            }
            if (++gbs.gridy != nRows) continue;
            gbs.gridy = 0;
            colm = 1;
        }
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 17;
        gbl.insets = new Insets(0, 0, 4, 4);
        gbl.gridy = 0;
        colm = 0;
        nRows = (latchMap.size() + 1) / 2;
        for (int cond : latchMap.keySet()) {
            gbl.insets.top = gbl.gridy == 0 ? 4 : 0;
            gbl.insets.left = colm == 0 ? 4 : 40;
            gbl.gridx = 3 * colm;
            this.latchPanel.add((Component)this.latchLabel[cond], gbl);
            gbl.insets.left = 4;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbl);
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbl);
            if (++gbl.gridy != nRows) continue;
            gbl.gridy = 0;
            colm = 1;
        }
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = 0;
        colm = 0;
        nRows = (conditionMap.size() + 1) / 2;
        for (int cond : conditionMap.keySet()) {
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            gbc.gridx = 2 * colm;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            ++gbc.gridx;
            gbc.insets.left = 4;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            if (++gbc.gridy != nRows) continue;
            gbc.gridy = 0;
            colm = 1;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.sysStatPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.conditionPanel, gbm);
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        if (type == 'O' && !this.switchOnRB[sw].isEnabled()) {
            this.updatePanel(this.vacState);
        } else {
            this.switchOffRB[sw].setEnabled(false);
            this.switchOnRB[sw].setEnabled(false);
            this.sender.sendCommand(null, "setSwitchOn", new Object[]{Switches.getName(sw), type == 'O'});
        }
    }

    public void handleButton(String name) {
        int cond = Integer.valueOf(name.substring(1));
        this.latchResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(null, "clearLatch", new Object[]{cond});
    }

    static {
        switchMap.put(0, "Cryo Turbo Pump");
        switchMap.put(7, "Cryo Gate Valve");
        switchMap.put(8, "Cryo Scroll Pump");
        switchMap.put(1, "Cryo Ion Pump 1");
        switchMap.put(2, "Cryo Ion Pump 2");
        switchMap.put(3, "Cryo Ion Pump 3");
        switchMap.put(4, "Cryo Ion Pump 4");
        switchMap.put(5, "Cryo Ion Pump 5");
        switchMap.put(6, "Cryo Ion Pump 6");
        switchMap.put(-1, "");
        switchMap.put(9, "HX Turbo Pump");
        switchMap.put(12, "HX Gate Valve");
        switchMap.put(13, "HX Scroll Pump");
        switchMap.put(10, "HX Ion Pump 1");
        switchMap.put(11, "HX Ion Pump 2");
        switchMap.put(14, "FTPP O-ring Valve");
        switchMap.put(16, "L3H O-ring Valve");
        switchMap.put(15, "FTH O-ring Valve");
        switchMap.put(17, "L3LF O-ring Valve");
        switchMap.put(18, "Inst Scroll Pump");
        switchTypes = new int[23];
        VacControlPanel.switchTypes[0] = 0;
        VacControlPanel.switchTypes[1] = 0;
        VacControlPanel.switchTypes[2] = 0;
        VacControlPanel.switchTypes[3] = 0;
        VacControlPanel.switchTypes[4] = 0;
        VacControlPanel.switchTypes[5] = 0;
        VacControlPanel.switchTypes[6] = 0;
        VacControlPanel.switchTypes[8] = 0;
        VacControlPanel.switchTypes[7] = 1;
        VacControlPanel.switchTypes[9] = 0;
        VacControlPanel.switchTypes[10] = 0;
        VacControlPanel.switchTypes[11] = 0;
        VacControlPanel.switchTypes[12] = 1;
        VacControlPanel.switchTypes[13] = 0;
        VacControlPanel.switchTypes[14] = 1;
        VacControlPanel.switchTypes[15] = 1;
        VacControlPanel.switchTypes[16] = 1;
        VacControlPanel.switchTypes[17] = 1;
        VacControlPanel.switchTypes[18] = 0;
        latchMap = new LinkedHashMap<Integer, String>();
        latchMap.put(0, "Cryo Vacuum Bad");
        latchMap.put(2, "Cryo Gate Can't Open");
        latchMap.put(1, "Cryo Gate Forced Shut");
        latchMap.put(3, "Cryo Turbo Pump Bad");
        latchMap.put(4, "HX Vacuum Bad");
        latchMap.put(6, "HX Gate Can't Open");
        latchMap.put(5, "HX Gate Forced Shut");
        latchMap.put(7, "HX Turbo Pump Bad");
        conditionMap = new LinkedHashMap<Integer, String>();
        conditionMap.put(0, "Cryo Foreline OK");
        conditionMap.put(2, "Cryo Turbo Vac < 10");
        conditionMap.put(3, "Cryo Gate Delta OK");
        conditionMap.put(1, "Cryo Turbo Stopped");
        conditionMap.put(4, "Cryo Vacuum < 0.01");
        conditionMap.put(5, "HX Foreline OK");
        conditionMap.put(7, "HX Turbo Vac < 10");
        conditionMap.put(8, "HX Gate Delta OK");
        conditionMap.put(6, "HX Turbo Stopped");
        conditionMap.put(9, "HX Vacuum < 0.01");
        PLC_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(PLCState.class);
        CRYO_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(CryoVacuumState.class);
        HX_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(HxVacuumState.class);
        SWITCH_STATE_WIDTH = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class), UiUtilities.maxEnumLabelWidth(DeviceState.class));
        LATCH_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(LatchState.class);
        COND_STATUS_WIDTH = UiUtilities.maxEnumLabelWidth(ConditionState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            VacControlPanel.this.sysStatPanel.disablePanel();
            VacControlPanel.this.plcStateValue.setEnabled(false);
            VacControlPanel.this.cryoStateValue.setEnabled(false);
            VacControlPanel.this.hxStateValue.setEnabled(false);
            Iterator iterator = switchMap.keySet().iterator();
            while (iterator.hasNext()) {
                int sw = (Integer)iterator.next();
                if (sw < 0) continue;
                VacControlPanel.this.switchStatus[sw].setEnabled(false);
                VacControlPanel.this.switchOffRB[sw].setEnabled(false);
                VacControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            iterator = latchMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                VacControlPanel.this.latchStatus[cond].setEnabled(false);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            iterator = conditionMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                VacControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
        }
    }

    class UpdateVacState
    implements Runnable {
        private final VacSysState vs;

        UpdateVacState(VacSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            int cond;
            Enum state;
            VacControlPanel.this.sysStatPanel.updatePanel(this.vs.getTickMillis());
            PLCState plcState = this.vs.getPlcState();
            VacControlPanel.this.plcStateValue.setText(plcState.name());
            VacControlPanel.this.plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN : (plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED));
            VacControlPanel.this.plcStateValue.setEnabled(true);
            CryoVacuumState cvState = this.vs.getCryoVacuumState();
            VacControlPanel.this.cryoStateValue.setText(cvState.name());
            VacControlPanel.this.cryoStateValue.setForeground(cvState == CryoVacuumState.VACUUM ? UiConstants.GREEN : (cvState == CryoVacuumState.UNKNOWN ? UiConstants.BLUE : (cvState == CryoVacuumState.OFF ? UiConstants.RED : Color.BLACK)));
            VacControlPanel.this.cryoStateValue.setEnabled(true);
            HxVacuumState hvState = this.vs.getHxVacuumState();
            VacControlPanel.this.hxStateValue.setText(hvState.name());
            VacControlPanel.this.hxStateValue.setForeground(hvState == HxVacuumState.VACUUM ? UiConstants.GREEN : (hvState == HxVacuumState.UNKNOWN ? UiConstants.BLUE : (hvState == HxVacuumState.OFF ? UiConstants.RED : Color.BLACK)));
            VacControlPanel.this.hxStateValue.setEnabled(true);
            Iterator iterator = switchMap.keySet().iterator();
            while (iterator.hasNext()) {
                Color color;
                int sw = (Integer)iterator.next();
                if (sw < 0) continue;
                state = this.vs.getSwitchState(sw);
                String text = state.name();
                Color color2 = state == SwitchState.OFF ? Color.black : (color = state == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                if (state != SwitchState.OFFLINE) {
                    if (this.vs.getSwitchEnable(sw) == SwitchEnable.OFF) {
                        text = "DISABLD";
                        color = UiConstants.RED;
                    } else {
                        DeviceState devState;
                        if (switchTypes[sw] == 1) {
                            String string = state == SwitchState.OFF ? "SHUT" : (text = state == SwitchState.ON ? "OPEN" : text);
                        }
                        if ((devState = this.vs.getDeviceState(sw)) != null) {
                            text = devState.name();
                            if (devState == DeviceState.FAILED) {
                                color = UiConstants.RED;
                            }
                        }
                    }
                }
                VacControlPanel.this.switchStatus[sw].setText(text);
                VacControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state == SwitchState.ON ? VacControlPanel.this.switchOnRB[sw] : VacControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                VacControlPanel.this.switchStatus[sw].setEnabled(true);
                VacControlPanel.this.switchOffRB[sw].setEnabled(true);
                VacControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            iterator = latchMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                state = this.vs.getLatch(cond);
                VacControlPanel.this.latchStatus[cond].setText(state.name());
                VacControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                VacControlPanel.this.latchStatus[cond].setEnabled(true);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            iterator = conditionMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                state = this.vs.getCondition(cond);
                VacControlPanel.this.conditionStatus[cond].setText(state.name());
                VacControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                VacControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
        }
    }
}

