/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public final class FontChooserPanel
extends JPanel {
    private JCheckBox m_bold;
    private JCheckBox m_italic;
    private JComboBox m_font = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    private SpinnerNumberModel m_fontSize;

    public FontChooserPanel(Font font) {
        super(new GridBagLayout());
        this.setSelectedFont(font);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        JPanel temp = new JPanel(new FlowLayout(1));
        temp.add(new JLabel("Font: "));
        temp.add(this.m_font);
        this.add((Component)temp, c);
        temp = new JPanel(new FlowLayout(1));
        temp.add(new JLabel("Font size (points): "));
        temp.add(new JSpinner(this.m_fontSize));
        this.add((Component)temp, c);
        temp = new JPanel(new FlowLayout(1));
        temp.add(this.m_bold);
        temp.add(this.m_italic);
        this.add((Component)temp, c);
    }

    public Font getSelectedFont() {
        int style = 0;
        if (this.m_bold.isSelected()) {
            style |= 1;
        }
        if (this.m_italic.isSelected()) {
            style |= 2;
        }
        return new Font((String)this.m_font.getSelectedItem(), style, this.m_fontSize.getNumber().intValue());
    }

    public void setSelectedFont(Font font) {
        this.m_font.setSelectedItem(font.getFamily());
        this.m_bold = new JCheckBox("Bold", (font.getStyle() & 1) != 0);
        this.m_italic = new JCheckBox("Italic", (font.getStyle() & 2) != 0);
        this.m_bold.setMnemonic('B');
        this.m_italic.setMnemonic('I');
        this.m_fontSize = new SpinnerNumberModel(font.getSize(), 1, 100, 1);
    }
}

