/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final DigitalSwitch ap1Switch = new DigitalSwitch();
    private final DigitalSwitch ap2Switch = new DigitalSwitch();
    private final DigitalSwitch ap3Switch = new DigitalSwitch();
    private final DigitalSwitch af0Switch = new DigitalSwitch();
    private final DigitalSwitch af1Switch = new DigitalSwitch();
    private final DigitalSwitch af3Switch = new DigitalSwitch();

    public AutochangerStatusPanel() {
        this.initComponents();
    }

    public void updateAutochanger(StatusDataPublishedByAutoChanger status) {
        SwingUtilities.invokeLater(new UpdateAutochanger(status));
    }

    public void updateLoader(StatusDataPublishedByLoader status) {
    }

    public void updateCarousel(StatusDataPublishedByCarousel status) {
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6), "Read on acPlutoGateway"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = Tools.insets_std;
        this.add((Component)new JLabel("AP1 (AC at standby)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("AP2 (AC at handoff)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("AP3 (AC at online)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("AF0 (AC latches opened)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("AF1 (filter detected in AC)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("AF3 (filter locked in AC)"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        this.add((Component)this.ap1Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.ap2Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.ap3Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.af0Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.af1Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.af3Switch, gbc);
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        this.ap1Switch.setColor(Color.gray);
        this.ap2Switch.setColor(Color.gray);
        this.ap3Switch.setColor(Color.gray);
        this.af0Switch.setColor(Color.gray);
        this.af1Switch.setColor(Color.gray);
        this.af3Switch.setColor(Color.gray);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return "Autochanger Protection Status";
    }

    public static void main(String[] args) {
        AutochangerStatusPanel d = new AutochangerStatusPanel();
        JFrame frame = new JFrame("AutochangerProtectionStatusPanel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateCarousel
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        UpdateCarousel(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
        }
    }

    class UpdateLoader
    implements Runnable {
        private final StatusDataPublishedByLoader s;

        UpdateLoader(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
        }
    }

    class UpdateAutochanger
    implements Runnable {
        private final StatusDataPublishedByAutoChanger s;

        UpdateAutochanger(StatusDataPublishedByAutoChanger s) {
            this.s = s;
        }

        @Override
        public void run() {
            AutochangerStatusPanel.this.ap1Switch.updateColor(this.s.isOUT_AP1_InError(), this.s.isOUT_AP1());
            AutochangerStatusPanel.this.ap2Switch.updateColor(this.s.isOUT_AP2_InError(), this.s.isOUT_AP2());
            AutochangerStatusPanel.this.ap3Switch.updateColor(this.s.isOUT_AP3_InError(), this.s.isOUT_AP3());
            AutochangerStatusPanel.this.af0Switch.updateColor(this.s.isOUT_AF0_InError(), this.s.isOUT_AF0());
            AutochangerStatusPanel.this.af1Switch.updateColor(this.s.isOUT_AF1_InError(), this.s.isOUT_AF1());
            AutochangerStatusPanel.this.af3Switch.updateColor(this.s.isOUT_AF3_InError(), this.s.isOUT_AF3());
        }
    }
}

