/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselSocketTablePanel
extends JPanel {
    private JTable socketTable;
    private JScrollPane jScrollPane;
    private static final String[] SOCKET_NAMES = new String[]{"socket1", "socket2", "socket3", "socket4", "socket5"};

    public CarouselSocketTablePanel() {
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateSocket(StatusDataPublishedByCarouselSocket s) {
        SwingUtilities.invokeLater(new UpdateSocket(s));
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.socketTable = new JTable();
        this.socketTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"NAME", "STANDBY POSITION", "FILTER ID", "FILTER NAME"}){
            private static final long serialVersionUID = -6158042587124966771L;
            private final Class[] types;
            private final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, Integer.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        int rowNB = this.socketTable.getModel().getRowCount();
        for (int i = 0; i < rowNB; ++i) {
            TableColumn column = this.socketTable.getColumnModel().getColumn(i);
            if (i != 0) continue;
            column.setPreferredWidth(30);
        }
        this.jScrollPane.setPreferredSize(new Dimension(500, 100));
        this.jScrollPane.setViewportView(this.socketTable);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Tools.NICE_PINK), "Carousel Sockets"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jScrollPane, gbc);
    }

    public static void main(String[] argv) {
        CarouselSocketTablePanel p = new CarouselSocketTablePanel();
        JFrame frame = new JFrame("Sockets Panel");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateSocket
    implements Runnable {
        private StatusDataPublishedByCarouselSocket s;

        public UpdateSocket(StatusDataPublishedByCarouselSocket s) {
            this.s = s;
        }

        @Override
        public void run() {
            DefaultTableModel socketTableModel = (DefaultTableModel)CarouselSocketTablePanel.this.socketTable.getModel();
            int rowNB = socketTableModel.getRowCount();
            for (int i = 0; i < rowNB; ++i) {
                String socketName = "socket" + this.s.getSocketID();
                if (!socketTableModel.getValueAt(i, 0).equals(socketName)) continue;
                if (this.s.isEmpty()) {
                    socketTableModel.setValueAt("", i, 3);
                    socketTableModel.setValueAt("", i, 2);
                    continue;
                }
                socketTableModel.setValueAt(this.s.getFilterName(), i, 3);
                socketTableModel.setValueAt(this.s.getFilterID(), i, 2);
            }
            socketTableModel.fireTableDataChanged();
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            DefaultTableModel socketTableModel = (DefaultTableModel)CarouselSocketTablePanel.this.socketTable.getModel();
            for (String socketName : SOCKET_NAMES) {
                Map config = this.configInfo.getCurrentValuesFor("carousel/" + socketName);
                Object[] tab = new Object[]{socketName, Integer.parseInt((String)config.get("standbyPosition")), "", ""};
                socketTableModel.addRow(tab);
            }
            socketTableModel.fireTableDataChanged();
        }
    }
}

