/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class MpmLatches {
    public static final int LATCH_UT_TEMP = 0;
    public static final int LATCH_UT_LEAK = 1;
    public static final int LATCH_UT_LEAK_FAULT = 2;
    public static final int LATCH_UT_SMOKE = 3;
    public static final int LATCH_UT_SMOKE_FAULT = 4;
    public static final int LATCH_COLD_TEMP_HIGH = 5;
    public static final int LATCH_COLD_TEMP_LOW = 6;
    public static final int LATCH_CRYO_TEMP_HIGH = 7;
    public static final int LATCH_CRYO_TEMP_LOW = 8;
    public static final int LATCH_CRYO_VACUUM = 9;
    public static final int LATCH_HEX_VACUUM = 10;
    public static final int NUM_LATCHES = 11;
    private static final Map<String, Integer> NAME_MAP = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> ID_MAP;

    public static List<String> getNames() {
        return new ArrayList<String>(NAME_MAP.keySet());
    }

    public static String getName(int id) {
        return ID_MAP.get(id);
    }

    public static int getId(String name) throws UtilityException {
        Integer id = NAME_MAP.get(name);
        if (id == null) {
            throw new UtilityException("Invalid latch name: " + name);
        }
        return id;
    }

    static {
        NAME_MAP.put("UTTemp", 0);
        NAME_MAP.put("UTLeak", 1);
        NAME_MAP.put("UTLeakFault", 2);
        NAME_MAP.put("UTSmoke", 3);
        NAME_MAP.put("UTSmokeFault", 4);
        NAME_MAP.put("ColdTempHigh", 5);
        NAME_MAP.put("ColdTempLow", 6);
        NAME_MAP.put("CryoTempHigh", 7);
        NAME_MAP.put("CryoTempLow", 8);
        NAME_MAP.put("CryoVacuum", 9);
        NAME_MAP.put("HexVacuum", 10);
        ID_MAP = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : NAME_MAP.entrySet()) {
            ID_MAP.put((int)e.getValue(), e.getKey());
        }
    }
}

