/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String title = "loader status";
    public static final String LPS = "LPS_0";
    public static final String LPSB = "LPS_1";
    public static final String LRH = "LRH_0";
    public static final String LRHB = "LRH_1";
    private final DigitalSwitch loaderPresenceSwitch = new DigitalSwitch("loaderOnCameraSensor0", "loaderOnCameraSensor1");
    private final DigitalSwitch loader_LPS_Switch = new DigitalSwitch("LPS_0", "LPS_1");
    private final DigitalSwitch loader_LRH_Switch = new DigitalSwitch("LRH_0", "LRH_1");

    public LoaderStatusPanel() {
        this.initComponents();
    }

    void updateFromSensorList(Map<String, Serializable> sMap) {
        SwingUtilities.invokeLater(new UpdateFromSensorList(sMap));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6), "Read on loaderPlutoGateway"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = Tools.insets_std;
        this.add((Component)new JLabel("Loader docked"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Loader_LPS (loader at Storage)"), gbc);
        ++gbc.gridy;
        this.add((Component)new JLabel("Loader_LRH (loader holds filter)"), gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.add((Component)this.loaderPresenceSwitch, gbc);
        ++gbc.gridy;
        this.add((Component)this.loader_LPS_Switch, gbc);
        ++gbc.gridy;
        this.add((Component)this.loader_LRH_Switch, gbc);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.loader_LPS_Switch.setColor(Color.GRAY);
        this.loader_LRH_Switch.setColor(Color.GRAY);
        this.loaderPresenceSwitch.setColor(Color.GRAY);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    @Override
    public String toString() {
        return title;
    }

    public static void main(String[] args) {
        LoaderStatusPanel d = new LoaderStatusPanel();
        JFrame frame = new JFrame("LoaderStatus Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateFromSensorList
    implements Runnable {
        private final Map<String, Serializable> sensorMap;

        public UpdateFromSensorList(Map<String, Serializable> sensorMap) {
            this.sensorMap = sensorMap;
        }

        @Override
        public void run() {
            LoaderStatusPanel.this.loader_LPS_Switch.updateColorComplementary(this.sensorMap);
            LoaderStatusPanel.this.loader_LRH_Switch.updateColorComplementary(this.sensorMap);
            LoaderStatusPanel.this.loaderPresenceSwitch.updateColorRedondantSensor(this.sensorMap);
        }
    }
}

