/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.awt.Color;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.Alert;

public class FcsEnumerations {
    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color darkGreen = new Color(0, 100, 0);
    public static final Color chocolate = new Color(210, 105, 30);
    public static final Color royalblue = new Color(65, 105, 225);
    public static final Color lightblue = new Color(173, 216, 230);
    public static final Color magenta2 = new Color(238, 0, 238);
    public static final Color orange1 = new Color(255, 165, 0);
    public static final String FCS_NAME_FOR_MCM = "FILTER";
    public static final String AC_PLUTOGATEWAY_NAME = "acSensorsGateway";

    public static enum FcsAlert {
        UNSYNC_BOOT("A boot message has been received for a device."),
        EMCY("Received an EMERGENCY message from a device."),
        IN_FAULT("Controller in fault."),
        CAN_BUS_TIMEOUT("Timeout expired while waiting to response from CANbus"),
        CAN_BUS_READING_ERROR("Error in reading on CANbus"),
        CAN_BUS_NOT_INITIALIZED("Could not init canInterface. POWER FAILURE ? Is Clean 24V up ? Check power, reboot pc104 and then restart fcs."),
        HARDWARE_MISSING("HARDWARE NOT DETECTED - POWER FAILURE ?"),
        HARDWARE_ERROR("HARDWARE ERROR"),
        CA_LOCKING_ISSUE("CAROUSEL LOCKING ISSUE"),
        CA_LOCKING_RECOVERY_SUCCESS("CAROUSEL LOCKING RECOVERY SUCCESSFUL"),
        CA_LOCKING_RECOVERY_FAILURE("CAROUSEL LOCKING RECOVERY FAILED"),
        CA_ROTATION_RECOVERY("CAROUSEL ROTATION RECOVERY NEEDED"),
        CA_ROTATION_RECOVERY_SUCCESS("CAROUSEL ROTATION RECOVERY SUCCESSFUL"),
        CA_ROTATION_RECOVERY_FAILURE("CAROUSEL ROTATION RECOVERY FAILED"),
        BAD_SERIAL_NB("Serial number read in CPU different from serial number in configuration"),
        PARAMETER_ERROR("ERROR in CPU controller for a parameter"),
        SDO_ERROR("Error in a request to a CANopen device"),
        AC_SENSOR_ERROR("Autochanger sensors are in error"),
        CA_SENSOR_ERROR("Carousel sensors are in error"),
        LO_SENSOR_ERROR("Loader sensors are in error"),
        AC_TRUCKS_ERROR("Autochanger trucks ERROR"),
        UPDATE_ERROR("ERROR in updateStateWithSensors");

        private final String longDescription;

        private FcsAlert(String longDescription) {
            this.longDescription = longDescription;
        }

        public String getLongDescription() {
            return this.longDescription;
        }

        public Alert getAlert() {
            return this.getAlert(null);
        }

        public Alert getAlert(String prefix) {
            String alertId = this.name();
            if (prefix != null && !prefix.isEmpty()) {
                alertId = prefix + "/" + alertId;
            }
            return new Alert(alertId, this.getLongDescription());
        }
    }

    public static enum HoldingBrakesState {
        TRUE,
        FALSE;

    }

    public static enum FilterReadinessState {
        NOT_READY,
        READY;

    }

    public static enum AutochangerTrucksLocation {
        STANDBY,
        HANDOFF,
        ONLINE,
        IN_TRAVEL;

    }

    public static enum AutochangerInclination {
        STRAIGHT,
        TILTED;

    }

    public static enum McmState {
        UNLOADING,
        LOADING,
        ROTATING,
        LOADED,
        NO_FILTER,
        UNKNOWN;

    }

    public static enum FilterState {
        MOVING_TRUCKS_TO_STANDBY,
        MOVING_TRUCKS_TO_ONLINE,
        MOVING_TRUCKS_TO_HANDOFF,
        TRUCKS_STOPPED,
        MOVING_TRUCKS,
        ROTATING,
        CAROUSEL_STOPPED,
        WAITING_FOR_HARWARE_BOOTING,
        CAN_DEVICES_BOOTING,
        READY,
        OFF_LINE,
        ONLINE_NONE,
        ONLINE_U,
        ONLINE_G,
        ONLINE_R,
        ONLINE_I,
        ONLINE_Z,
        ONLINE_Y,
        ONLINE_PH,
        ONLINE_EF,
        ONLINE_A,
        ONLINE_DU1,
        ONLINE_DU2,
        ONLINE_DR1,
        ONLINE_DZ1,
        ONLINE_DZ2,
        ONLINE_DA1,
        ONLINE_DA2,
        ONLINE_TU,
        ONLINE_TY,
        ONLINE_OA,
        ONLINE_OB,
        ONLINE_OC,
        ONLINE_F15,
        ONLINE_F17,
        ONLINE_F29,
        ONLINE_F3,
        ONLINE_F34,
        ONLINE_F46,
        ONLINE_F48,
        ONLINE_F60;

    }

    public static enum MobileItemAction {
        UNLOCK("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        UNLOCKCLAMPS("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASECLAMPS("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        ROTATE_CAROUSEL_TO_RELATIVE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        ROTATE_CAROUSEL_TO_ABSOLUTE_POSITION("ROTATING CAROUSEL", "CAROUSEL ROTATION IS COMPLETED", "COULD NOT ROTATE CAROUSEL"),
        OPEN("OPENING LATCH", "IS OPENED", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        CLOSE_ONLINECLAMP_MODE_CURRENT("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        CLOSE_ONLINECLAMP_MODE_PROFILE_POSITION("CLOSING ONLINECLAMP", "IS CLOSED", "COULD NOT CLOSE ONLINECLAMP"),
        LOCK_ONLINECLAMP("LOCKING ONLINECLAMP", "IS LOCKED", "COULD NOT LOCK ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        REOPEN_ONLINECLAMP_MODE_CURRENT("OPENING ONLINECLAMP CURRENT MODE", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        OPEN_ONLINECLAMP_MODE_PROFILE_POSITION("OPENING ONLINECLAMP", "IS OPENED", "COULD NOT OPEN ONLINECLAMP"),
        UNLOCK_ONLINECLAMP("UNLOCKING ONLINECLAMP", "IS UNLOCKED", "COULD NOT UNLOCK ONLINECLAMP"),
        MOVE_TO_ABSOLUTE_POSITION("MOVING TO ABSOLUTE POSITION", "ABSOLUTE POSITION REACHED", "COULD NOT MOVE TO ABSOLUTE POSITION"),
        ALIGN_FOLLOWER("ALIGNING FOLLOWER", "FOLLOWER ALIGNED", "COULD NOT ALIGN FOLLOWER"),
        MOVE_FOLLOWER_TRUCK_ALONE("MOVING FOLLOWER_TRUCK", "FOLLOWER_TRUCK MOVED", "COULD NOT MOVE FOLLOWER_TRUCK"),
        UNCLAMPLOADERHOOKS("LOADER CLAMP UNCLAMPING", "HOOKS ARE UNCLAMPED", "COULD NOT UNCLAMP"),
        OPENHOMINGLOADERHOOKS("OPENING LOADER HOOKS", "LOADER HOOKS ARE OPEN", "COULD NOT OPEN LOADER HOOKS"),
        CLOSELOADERHOOKS("CLOSING LOADER HOOKS", "LOADER HOOKS ARE CLOSED", "COULD NOT CLOSE LOADER HOOKS"),
        CLAMPLOADERHOOKS("CLAMPING LOADER HOOKS", "LOADER HOOKS ARE CLAMPED", "COULD NOT CLAMP LOADER HOOKS"),
        MOVE_LOADERCARRIER_TO_STORAGE("MOVING LOADER CARRIER TO STORAGE", "LOADER CARRIER IS AT STORAGE POSITION", "COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVE_LOADERCARRIER_TO_ABSOLUTEPOSITION("MOVING LOADER CARRIER TO ABSOLUTE POSITION", "LOADER CARRIER IS AT REQUIRED POSITION", "COULD NOT MOVE LOADER CARRIER TO REQUIRED POSITION"),
        MOVE_LOADERCARRIER_TO_HANDOFF("MOVING LOADER CARRIER TO HANDOFF", "LOADER CARRIER IS AT HANDOFF POSITION", "COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION"),
        MOVE_LOADERCARRIER_TO_ENGAGED("MOVING LOADER CARRIER TO ENGAGED", "LOADER CARRIER IS AT ENGAGED POSITION", "COULD NOT MOVE LOADER CARRIER TO ENGAGED POSITION");

        private final String shortDescription;
        private final String doneActionMsg;
        private final String failureMsg;

        private MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.shortDescription = aString;
            this.doneActionMsg = aDoneString;
            this.failureMsg = aFailureMsg;
        }

        public String toString() {
            return this.shortDescription;
        }

        public String doneString() {
            return this.doneActionMsg;
        }

        public String getFailureMsg() {
            return this.failureMsg;
        }
    }

    public static enum IOModuleStatus implements ColoredObject
    {
        UNKNOWN_STATUS(0, Color.RED),
        IS_SOCKET_AT_STANDBY(1, greenColor),
        IS_READY_NOT_IN_POSITION(2, Color.BLUE),
        ERROR_READING_POSITION(3, Color.red),
        SAFE_STATE(4, Color.RED),
        BOOTING(5, orange1),
        NOT_POWERED_ON(6, Color.RED),
        NOT_WORKING_FOR_OTHER_REASON(7, chocolate);

        @SkipEncoding
        private final int status;
        @SkipEncoding
        private final Color color;

        private IOModuleStatus(int status, Color color) {
            this.status = status;
            this.color = color;
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public static IOModuleStatus getStatusByCode(int s) {
            IOModuleStatus[] codes = IOModuleStatus.values();
            IOModuleStatus status = null;
            for (IOModuleStatus ioStatus : codes) {
                if (ioStatus.getStatus() != s) continue;
                status = ioStatus;
            }
            if (status == null) {
                throw new IllegalArgumentException(s + ": this status doesn't exist in IOModuleStatus ENUM");
            }
            return status;
        }
    }

    public static enum FilterClampState implements ColoredObject
    {
        READYTOCLAMP(Color.blue, "READY TO CLAMP"),
        UNCLAMPEDONFILTER(chocolate, "UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY(royalblue, "UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER(greenColor, "CLAMPED ON FILTER"),
        UNDEFINED(Color.orange, "UNDEFINED"),
        ERROR(Color.red, "IN ERROR"),
        UNLOCKABLE(magenta2, "FILTER UNLOCKABLE");

        @SkipEncoding
        private final String shortDescription;
        @SkipEncoding
        private final Color color;

        private FilterClampState(Color color, String aString) {
            this.shortDescription = aString;
            this.color = color;
        }

        public String toString() {
            return this.shortDescription;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    public static enum LoaderCarrierLocation {
        STORAGE,
        HANDOFF,
        UNKNOWN,
        ERROR;

    }

    public static enum FilterFamily {
        S("Science Filter"),
        D("Dummy Filter"),
        F("French Dummy Filter"),
        T("Test Filter LNL"),
        O("Open / Non Attributed Filter"),
        U("Unknown Filter");

        private final String familyName;

        private FilterFamily(String familyName) {
            this.familyName = familyName;
        }

        public String getFamilyName() {
            return this.familyName;
        }
    }

    public static enum BrakeState {
        CLOSED,
        NOBRAKE,
        NO_SENSOR;

    }

    public static enum LockStatus implements ColoredObject
    {
        UNLOCKED(Color.blue, "UNLOCKED"),
        LOCKED(greenColor, "LOCKED"),
        UNKNOWN(Color.orange, "UNKNOWN"),
        ERROR(Color.red, "IN ERROR"),
        RELAXED(lightblue, "RELAXED"),
        OPENED(Color.blue, "OPENED"),
        CLOSED(greenColor, "CLOSED"),
        CLAMPED(darkGreen, "CLAMPED"),
        UNCLAMPED(Color.blue, "UNCLAMPED"),
        UNDER_CLAMPED(Color.YELLOW, "UNDER LOAD"),
        OVER_CLAMPED(Color.RED, " OVER LOAD"),
        INTRAVEL(Color.YELLOW, "IN TRAVEL"),
        NOERROR(Color.GREEN, "NO ERROR");

        @SkipEncoding
        private final Color color;
        @SkipEncoding
        private final String text;

        private LockStatus(Color color, String text) {
            this.color = color;
            this.text = text;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum FilterPresenceStatus implements ColoredObject
    {
        NOFILTER(Color.DARK_GRAY),
        ENGAGED(chocolate),
        LOCKABLE(greenColor),
        NOT_LOCKABLE(Color.blue),
        ERROR(Color.red),
        UNKNOWN(Color.YELLOW);

        @SkipEncoding
        private final Color color;

        private FilterPresenceStatus(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    @FunctionalInterface
    public static interface ColoredObject {
        public Color getColor();
    }
}

