/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateBundle;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.bus.states.UnmodifiableStateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class AgentStateService
implements AgentService,
ServiceLifecycle,
BusMessagePreProcessor {
    private static final Logger log = Logger.getLogger("org.lsst.ccs.services.state");
    private volatile StateBundle innerState = new StateBundle(new Enum[0]);
    private final Object innerStateLock = new Object();
    private final ReentrantLock stateWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, Predicate<StateBundle>> stateWaitList;
    private final Map<Class, List<Object>> registeredStates = new HashMap<Class, List<Object>>();
    private boolean canRegisterStates = true;
    private boolean mustRegisterStates = false;
    private CCSTimeStamp lastPublishedFullState = null;
    private final Map<StateChangeListener, List<Class>> stateChangeListeners = new ConcurrentHashMap<StateChangeListener, List<Class>>();
    private final Map<String, UnmodifiableStateBundle> clusterStates = new ConcurrentHashMap<String, UnmodifiableStateBundle>();
    private final Map<String, AtomicInteger> ignoredMessagesCount = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, CCSTimeStamp> firstIgnoredMessageTimestamp = new ConcurrentHashMap<String, CCSTimeStamp>();
    private static final int MAX_MISSED_MESSAGES = 3;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    private AgentStateSpontaneousPublication spontaneousPublicationStrategy;

    @Override
    public String getAgentServiceName() {
        return "stateService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return true;
    }

    @Override
    public void preStart() {
        this.canRegisterStates = false;
        this.spontaneousPublicationStrategy = new AgentStateSpontaneousPublication();
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this.spontaneousPublicationStrategy);
    }

    @Override
    public void preShutdown() {
        if (this.spontaneousPublicationStrategy != null) {
            this.agent.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this.spontaneousPublicationStrategy);
        }
    }

    @Override
    public void preBuild() {
        this.mustRegisterStates = this.dictionaryService != null;
    }

    @Override
    public void preInit() {
        this.agentCommandDictionaryService.addCommandSetToObject(new AgentStateServiceCommands(this), this.agent);
        this.registerState(OperationalState.class, "Operational State", this.agent);
        this.registerState(ConfigurationState.class, "Configuration State", this.agent);
        this.registerState(PhaseState.class, "Phase State", this.agent);
        this.registerState(AlertState.class, "Alert State", this.agent);
        this.registerState(CommandState.class, "Command State", this.agent);
        this.agent.getAgentService(AlertService.class).registerAlert(InfrastructureAlert.STATE_MISMATCH.getAlert(), new ClearAlertHandler(){

            @Override
            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                boolean stateAlert = alert.getAlertId().equals(InfrastructureAlert.STATE_MISMATCH.getAlertId());
                return stateAlert ? ClearAlertHandler.ClearAlertCode.CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        });
    }

    public final <T extends Enum<T>> void registerState(Class<T> state, String description, Object obj) {
        if (!this.canRegisterStates) {
            throw new RuntimeException("Cannot register agent/component states after the HasLifecycle::init phase");
        }
        if (!this.mustRegisterStates) {
            return;
        }
        List stateTargets = this.registeredStates.getOrDefault(state, new ArrayList());
        String objectPath = this.agent.getComponentLookup().getComponentNodeForObject(obj).getPath();
        if (stateTargets.contains(obj)) {
            throw new RuntimeException("State class " + state + " has already been registered for object at path " + objectPath);
        }
        stateTargets.add(obj);
        this.registeredStates.put(state, stateTargets);
        DataProviderInfo info = new DataProviderInfo(objectPath, DataProviderInfo.Type.STATE, state.getTypeName());
        info.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, description);
        String publishedPath = objectPath + "/" + state.getSimpleName();
        if (publishedPath.startsWith("/")) {
            publishedPath = publishedPath.substring(1);
        }
        info.addAttribute(DataProviderInfo.Attribute.PUBLISHED_PATH, publishedPath);
        this.dictionaryService.addDataProviderInfoToDictionary(info);
    }

    public Object getStateLock() {
        return this.innerStateLock;
    }

    public boolean isInState(Enum state) {
        return this.innerState.isInState(state);
    }

    public boolean isComponentInState(String component, Enum state) {
        return this.innerState.isComponentInState(component, state);
    }

    public boolean isInState(StateBundle state) {
        return this.innerState.isInState(state);
    }

    public Enum getState(Class stateClass) {
        return this.innerState.getState(stateClass);
    }

    public Enum getComponentState(String component, Class stateClass) {
        return this.innerState.getComponentState(component, stateClass);
    }

    public void updateAgentState(Enum ... stateChanges) {
        this.updateAgentState(CCSTimeStamp.currentTime(), stateChanges);
    }

    public void updateAgentState(CCSTimeStamp stateTransitionTimestamp, Enum ... stateChanges) {
        StateBundle sb = new StateBundle(stateChanges);
        this.updateAgentState(stateTransitionTimestamp, false, sb);
    }

    public void updateAgentState(StateBundle stateChanges) {
        this.updateAgentState(CCSTimeStamp.currentTime(), stateChanges);
    }

    public void updateAgentState(CCSTimeStamp stateTransitionTimestamp, StateBundle stateChanges) {
        this.updateAgentState(stateTransitionTimestamp, false, stateChanges);
    }

    public void updateAgentComponentState(Object component, Enum ... stateChanges) {
        this.updateAgentComponentState(CCSTimeStamp.currentTime(), component, stateChanges);
    }

    public void updateAgentComponentState(CCSTimeStamp stateTransitionTimestamp, Object component, Enum ... stateChanges) {
        if (component == this.agent) {
            this.updateAgentState(stateChanges);
        }
        StateBundle sb = new StateBundle(new Enum[0]);
        sb.setComponentState(this.agent.getComponentLookup().getComponentNodeForObject(component).getPath(), stateChanges);
        this.updateAgentState(stateTransitionTimestamp, false, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgentState(CCSTimeStamp stateTransitionTimestamp, boolean isInternal, StateBundle stateChanges) {
        if (!isInternal) {
            for (Object state : stateChanges.getDecodedStates().values()) {
                if (!(state instanceof AgentState)) continue;
                throw new IllegalArgumentException("Attempt to modify internal Agent states");
            }
            ArrayList<String> comps = new ArrayList<String>(stateChanges.getComponentsWithStates());
            comps.add("");
            for (String component : comps) {
                Object componentObj = this.agent.getComponentLookup().getComponentByPath(component);
                if (componentObj == null) {
                    log.log(Level.WARNING, "Component state name {0} does not correspond to an object in the agent lookup tree. Please change your code to use the object's full path", new Object[]{component});
                }
                StateBundle sb = componentObj == this.agent ? stateChanges : stateChanges.getComponentStateBundle(component);
                for (Enum state : sb.getDecodedStates().values()) {
                    if (state instanceof AgentState) {
                        throw new IllegalArgumentException("Attempt to modify internal Agent states");
                    }
                    if (!this.mustRegisterStates || ((List)this.registeredStates.getOrDefault(state.getClass(), new ArrayList())).contains(componentObj)) continue;
                    log.log(Level.SEVERE, "State {0} has not been registered with the AgentStateService for object at path {1}. Please register it with AgentStateService::registerState(Class, String, Object) in the HasLifecycle::init phase.", new Object[]{state.getClass(), component});
                }
            }
        }
        Object object = this.innerStateLock;
        synchronized (object) {
            StateBundle before = this.innerState.clone();
            StateBundle after = before.mergeState(stateChanges);
            if (!AgentState.isLegal((StateBundle)before, (StateBundle)after)) {
                this.innerState = before;
                String msg = "Illegal state transition from " + before + " to " + after;
                log.log(Level.SEVERE, msg);
                throw new IllegalArgumentException(msg);
            }
            if (!before.equals((Object)after)) {
                this.innerState = after;
                if (this.agent.isConnectedToTheBuses()) {
                    if (this.lastPublishedFullState == null) {
                        this.publishStateBundleNow();
                    }
                    StatusStateChangeNotification changeNotification = new StatusStateChangeNotification(stateTransitionTimestamp, null);
                    changeNotification.setState(after.diffState(before));
                    this.agent.sendStatusMessage((StatusMessage)changeNotification);
                }
                this.stateWaitNotify(after);
                if (!this.stateChangeListeners.isEmpty()) {
                    this.notifyStateChange(stateTransitionTimestamp, after.diffState(before), before);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishStateBundleNow() {
        Object object = this.innerStateLock;
        synchronized (object) {
            this.agent.sendStatusMessage((StatusMessage)new StatusStateBundle(this.getState()));
            this.lastPublishedFullState = CCSTimeStamp.currentTime();
        }
    }

    public final void updateInternalState(AgentState ... stateChanges) {
        CCSTimeStamp stateTransitionTimeStamp = CCSTimeStamp.currentTime();
        StateBundle sb = new StateBundle(new Enum[0]);
        for (AgentState change : stateChanges) {
            sb.setState(new Enum[]{(Enum)change});
        }
        this.updateAgentState(stateTransitionTimeStamp, true, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitFor(Predicate<StateBundle> target, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.stateWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (target.test(this.getState())) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.stateWaitLock.newCondition();
            if (this.stateWaitList == null) {
                this.stateWaitList = new LinkedHashMap(4);
            }
            this.stateWaitList.put(condition, target);
            while (this.stateWaitList != null && this.stateWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.stateWaitLock.unlock();
        }
        return true;
    }

    private void stateWaitNotify(StateBundle currentState) {
        this.agent.getScheduler().schedule(() -> {
            try {
                this.stateWaitLock.lockInterruptibly();
                try {
                    if (this.stateWaitList == null) {
                        return;
                    }
                    Iterator<Map.Entry<Condition, Predicate<StateBundle>>> it = this.stateWaitList.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Condition, Predicate<StateBundle>> entry = it.next();
                        Predicate<StateBundle> target = entry.getValue();
                        if (!target.test(currentState)) continue;
                        entry.getKey().signal();
                        it.remove();
                    }
                    if (this.stateWaitList.isEmpty()) {
                        this.stateWaitList = null;
                    }
                }
                finally {
                    this.stateWaitLock.unlock();
                }
            }
            catch (InterruptedException ie) {
                log.log(Level.SEVERE, "Exception when notifying for state wait", ie);
            }
        }, 0L, TimeUnit.NANOSECONDS);
    }

    private void notifyStateChange(CCSTimeStamp stateTransitionTimestamp, StateBundle diff, StateBundle oldState) {
        for (Map.Entry<StateChangeListener, List<Class>> e : this.stateChangeListeners.entrySet()) {
            StateChangeListener l = e.getKey();
            List<Class> stateClasses = e.getValue();
            for (Class stateClass : stateClasses) {
                Enum newState = diff.getState(stateClass);
                if (newState != null) {
                    l.stateChanged(stateTransitionTimestamp, this, newState, oldState.getState(stateClass));
                }
                Map changedComponents = diff.getComponentsWithState(stateClass);
                for (Map.Entry componetsEntry : changedComponents.entrySet()) {
                    String componentName = (String)componetsEntry.getKey();
                    Object changedComponent = this.agent.getComponentLookup().getComponentByPath(componentName);
                    if (changedComponent == null) {
                        changedComponent = componentName;
                    }
                    l.stateChanged(stateTransitionTimestamp, changedComponent, (Enum)componetsEntry.getValue(), oldState.getComponentState(componentName, stateClass));
                }
            }
        }
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener, Class ... states) {
        this.stateChangeListeners.put(stateChangeListener, Arrays.asList(states));
    }

    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListeners.remove(stateChangeListener);
    }

    public StateBundle getState() {
        return this.innerState.clone();
    }

    public BusMessage preProcessMessage(BusMessage msg) {
        String agentName = msg.getOriginAgentInfo().getName();
        if (!(msg instanceof StatusStateChangeNotification) && ((StatusMessage)msg).getState() != null) {
            return msg;
        }
        if (!this.clusterStates.containsKey(agentName) && !(msg instanceof StatusStateBundle)) {
            this.messageIgnored(agentName);
            return null;
        }
        this.messageAccepted(agentName);
        if (msg instanceof StatusStateBundle) {
            StateBundle incomingStateBundle = ((StatusStateBundle)msg).getFullState();
            StateBundle existingStateBundle = (StateBundle)this.clusterStates.get(agentName);
            this.clusterStates.put(agentName, new UnmodifiableStateBundle(incomingStateBundle));
            if (existingStateBundle != null) {
                StateBundle diff = existingStateBundle.diffState(incomingStateBundle);
                if (!diff.isEmpty()) {
                    this.agent.getAgentService(AlertService.class).raiseAlert(InfrastructureAlert.STATE_MISMATCH.getAlert(), AlertState.WARNING, "Inconsistent state for " + agentName + " diff: " + diff + "\n existing: " + existingStateBundle + "\n incoming " + incomingStateBundle);
                }
            } else if (!incomingStateBundle.isInState((Enum)PhaseState.INITIALIZING)) {
                StatusStateChangeNotification artificialStateChangeNotification = new StatusStateChangeNotification(((StatusStateBundle)msg).getCCSTimeStamp(), new StateBundle(new Enum[0]));
                artificialStateChangeNotification.setState(incomingStateBundle);
                return artificialStateChangeNotification;
            }
            return null;
        }
        boolean disconnected = false;
        if (msg instanceof StatusStateChangeNotification) {
            StateBundle currentStateBundle;
            StateBundle oldStateBundle = currentStateBundle = (StateBundle)this.clusterStates.getOrDefault(agentName, new UnmodifiableStateBundle(new StateBundle(new Enum[0])));
            StateBundle changedStateBundle = ((StatusStateChangeNotification)msg).getNewState();
            StateBundle newStateBundle = currentStateBundle.mergeState(changedStateBundle);
            this.clusterStates.put(agentName, new UnmodifiableStateBundle(newStateBundle));
            msg = new StatusStateChangeNotification(((StatusStateChangeNotification)msg).getStateTransitionTimestamp(), oldStateBundle);
            if (newStateBundle.isInState((Enum)PhaseState.OFF_LINE)) {
                disconnected = true;
            }
        }
        StateBundle storedState = (StateBundle)this.clusterStates.get(agentName);
        if (disconnected) {
            this.clusterStates.remove(agentName);
        }
        ((StatusMessage)msg).setState(storedState);
        return msg;
    }

    public Bus getBus() {
        return Bus.STATUS;
    }

    private void messageAccepted(String agentName) {
        this.ignoredMessagesCount.remove(agentName);
        this.firstIgnoredMessageTimestamp.remove(agentName);
    }

    private void messageIgnored(String agentName) {
        CCSTimeStamp firstIgnoredMsg = this.firstIgnoredMessageTimestamp.computeIfAbsent(agentName, k -> CCSTimeStamp.currentTime());
        AtomicInteger count = this.ignoredMessagesCount.computeIfAbsent(agentName, k -> new AtomicInteger(1));
        int missedMessages = count.getAndIncrement();
        if (missedMessages > 0 && missedMessages % 3 == 0 && Duration.between(firstIgnoredMsg.getUTCInstant(), CCSTimeStamp.currentTime().getUTCInstant()).getSeconds() > 2L) {
            this.agent.getScheduler().execute(() -> {
                this.agent.getMessagingAccess().sendCommandRequest(new CommandRequest(agentName, "publishState"), new CommandOriginator(){}, false);
                log.log(Level.INFO, "Requested state publication for agent {0}", agentName);
            });
        }
    }

    private class AgentStateSpontaneousPublication
    implements AgentPresenceListener {
        private AgentStateSpontaneousPublication() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connecting(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                Object object = AgentStateService.this.innerStateLock;
                synchronized (object) {
                    if (AgentStateService.this.lastPublishedFullState == null || AgentStateService.this.lastPublishedFullState.getUTCInstant().isBefore(ai.getAgentJoinedTheBusesTime().getUTCInstant().plus(Duration.ofMillis(100L)))) {
                        log.log(Level.FINE, "Publishing state bundle for connecting agents {0}", new Object[]{agents});
                        AgentStateService.this.publishStateBundleNow();
                        break;
                    }
                }
            }
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                AgentStateService.this.clusterStates.remove(ai.getName());
            }
        }
    }

    public class AgentStateServiceCommands {
        private final AgentStateService stateService;

        AgentStateServiceCommands(AgentStateService stateService) {
            this.stateService = stateService;
        }

        @Command(category=Command.CommandCategory.CORE, type=Command.CommandType.QUERY)
        public StateBundle getState() {
            return this.stateService.getState();
        }

        @Command(category=Command.CommandCategory.SYSTEM, type=Command.CommandType.QUERY)
        public void publishState() {
            this.stateService.publishStateBundleNow();
        }
    }
}

