/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.gui.IconStore;

class ClientListCellRenderer
extends DefaultListCellRenderer {
    private Font[] labelFonts_;
    private IconStore iconStore_ = new IconStore(IconStore.createEmptyIcon(16));
    private final Map addHints_ = new HashMap();

    public ClientListCellRenderer() {
        this.addHints_.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.addHints_.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    protected String getLabel(Client client) {
        Metadata meta = client.getMetadata();
        return meta != null ? meta.getName() : null;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints oldHints = g2.getRenderingHints();
        g2.addRenderingHints(this.addHints_);
        super.paintComponent(g);
        g2.setRenderingHints(oldHints);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSel, boolean hasFocus) {
        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSel, hasFocus);
        if (c instanceof JLabel && value instanceof Client) {
            int size;
            JLabel jl = (JLabel)c;
            Client client = (Client)value;
            String label = this.getLabel(client);
            String text = label == null ? client.getId() : label;
            Font font = this.getLabelFont(label == null);
            try {
                size = (int)Math.ceil(font.getMaxCharBounds(((Graphics2D)list.getGraphics()).getFontRenderContext()).getHeight());
            }
            catch (NullPointerException e) {
                size = 16;
            }
            jl.setText(text);
            jl.setFont(font);
            jl.setIcon(ClientListCellRenderer.reshapeIcon(this.iconStore_.getIcon(client), size));
        }
        return c;
    }

    private Font getLabelFont(boolean special) {
        if (this.labelFonts_ == null) {
            Font normalFont = this.getFont().deriveFont(1);
            Font aliasFont = this.getFont().deriveFont(0);
            this.labelFonts_ = new Font[]{normalFont, aliasFont};
        }
        return this.labelFonts_[special ? 1 : 0];
    }

    static Icon reshapeIcon(Icon icon, final int height) {
        double aspect = 2.0;
        final int width = (int)Math.ceil(aspect * (double)height);
        final Icon sIcon = IconStore.scaleIcon(icon, height, aspect, true);
        final int xoff = (width - sIcon.getIconWidth()) / 2;
        return new Icon(){

            public int getIconWidth() {
                return width;
            }

            public int getIconHeight() {
                return height;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                sIcon.paintIcon(c, g, x + xoff, y);
            }
        };
    }
}

