/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.util.concurrent.CountDownLatch;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.canopenjni.CanFestivalJNI;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.CanopenMaster;
import org.lsst.ccs.drivers.canopenjni.CanopenSlave;
import org.lsst.ccs.shell.JLineShell;

public class TestDirectJNI {
    public static void main(String[] args) throws Exception {
        CanFestivalJNI coi = new CanFestivalJNI();
        CommandSetBuilder builder = new CommandSetBuilder();
        CompositeCommandSet compositeSet = new CompositeCommandSet();
        compositeSet.add(builder.buildCommandSet(coi));
        compositeSet.add(builder.buildCommandSet(new TestCommands(coi)));
        JLineShell shell = new JLineShell(compositeSet);
        shell.run();
        System.exit(0);
    }

    public static class TestCommands {
        private final CanOpenInterface coi;

        public TestCommands(CanOpenInterface coi) {
            this.coi = coi;
        }

        @Command
        public void testRSDOTiming(int nodeId, int index, int subindex, int nThreads, int times, int intervalMillis, @Argument(defaultValue="true") boolean sync, @Argument(defaultValue="false") boolean showTraces) throws Exception {
            CountDownLatch latch = new CountDownLatch(nThreads);
            long start = System.currentTimeMillis();
            for (int i = 0; i < nThreads; ++i) {
                new Thread(() -> {
                    String name = Thread.currentThread().getName();
                    int count = 0;
                    for (int j = 0; j < times; ++j) {
                        try {
                            this.coi.rsdo(nodeId, index, subindex);
                            if (showTraces) {
                                System.out.println("thread " + name + " sucess. count : " + count);
                            }
                            ++count;
                            Thread.sleep(intervalMillis);
                            continue;
                        }
                        catch (Exception ex) {
                            System.out.println("thread " + name + " exception. count : " + count + " : " + ex.toString());
                        }
                    }
                    System.out.println("thread " + name + " done. success count : " + count);
                    latch.countDown();
                }, "rsdo-" + i).start();
            }
            if (sync) {
                latch.await();
            }
            long t = System.currentTimeMillis() - start;
            System.out.println("all done in " + t + " ms.");
        }
    }

    public static class DummySlave
    extends CanopenSlave {
        public DummySlave(CanopenMaster master, int nodeId) {
            super(master, nodeId);
        }

        @Override
        public void onBootup() {
            System.out.println("node " + Integer.toHexString(this.nodeId) + " bootup");
            System.out.flush();
        }

        @Override
        public void onEmergencyMessage(int errCode, int errReg) {
            System.out.println("emergency message for node " + Integer.toHexString(this.nodeId) + ", errcode : " + errCode + ", errreg : " + errReg);
            System.out.flush();
        }

        @Override
        protected void updateWithPDO(int cob_id, long pdoVal) {
            System.out.println("updating " + Integer.toHexString(cob_id) + " : " + Long.toHexString(pdoVal));
            System.out.flush();
        }

        @Override
        public int[] getCobIds() {
            return new int[]{640};
        }
    }
}

