/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.DataProviderInfo;

public enum FocalPlaneDataGroup {
    ASPIC_TEMPERATURE("Aspic Temp", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<aspicId>Aspic[UL])/Temp\\d")),
    REB_TEMPERATURE0("Reb Temp2", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/Temp2")),
    REB_TEMPERATURE1("Reb Temp6", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/Temp6")),
    CCD_TEMPERATURE("CCD Temp", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<sensorId>SW|SG\\d|S\\d\\d)/Temp")),
    CCD_CURRENTS("CCD Cur", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/(?<sensorId>SW|SG\\d|S\\d\\d)/Seg(?<amplifierId>\\d\\d)/I")),
    BOARD_CURRENTS0("Bias Cur", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/ODI")),
    BOARD_CURRENTS1("ClockHi I", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/ClkHI")),
    BOARD_CURRENTS2("ClockLo I", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/ClkLI")),
    RTD_TEMPERATURE("RTD Temp", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/RTDTemp")),
    BOARD_POWER("Reb Power", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/Power")),
    HEATER("Heater", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>Reb\\d|Reb[WG])/HtrW"));

    private final String name;
    private final Pattern pattern;

    public static FocalPlaneDataGroup forName(String name) {
        for (FocalPlaneDataGroup g : FocalPlaneDataGroup.values()) {
            if (!g.name.equals(name)) continue;
            return g;
        }
        throw new IllegalArgumentException("No FocalPlaneDataGroup constant with " + name + " name.");
    }

    private FocalPlaneDataGroup(String name, Pattern pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean matchesData(DataProviderInfo dataInfo) {
        return this.pattern.matcher(dataInfo.getPath()).matches();
    }

    public static FocalPlaneDataGroup findFocalPlaneDataGroup(DataProviderInfo dataInfo) {
        for (FocalPlaneDataGroup dataGroup : FocalPlaneDataGroup.values()) {
            if (!dataGroup.matchesData(dataInfo)) continue;
            return dataGroup;
        }
        return null;
    }

    public void addAttributesToDataInfo(DataProviderInfo dataInfo) {
        Matcher m;
        DataProviderInfo.Type dataType = DataProviderInfo.Type.valueOf((String)dataInfo.getAttributeValue(DataProviderInfo.Attribute.DATA_TYPE));
        if ((dataType == DataProviderInfo.Type.MONITORING || dataType == DataProviderInfo.Type.TRENDING) && (m = this.pattern.matcher(dataInfo.getPath())).matches()) {
            dataInfo.addAttribute(DataProviderInfo.Attribute.DATA_GROUP, this.getName());
        }
    }
}

