/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import plotter.AbstractAxisModel;
import plotter.ContinuousAxisModel;

public class LogarithmicAxisModel
extends AbstractAxisModel
implements ContinuousAxisModel {
    private double min;
    private double max;

    public LogarithmicAxisModel(double min, double max) {
        this.setRange(min, max);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        if (this.max != max) {
            this.setRange(this.min, max);
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        if (this.min != min) {
            this.setRange(min, this.max);
        }
    }

    public void setRange(double min, double max) {
        if (this.min != min || this.max != max) {
            if (min >= max || min <= 0.0) {
                throw new IllegalArgumentException("min=" + min + " max=" + max);
            }
            this.min = Math.log10(min);
            this.max = Math.log10(max);
            this.fireAxisChanged();
        }
    }

    @Override
    public double getAxisCoordinateFromModelCoordinate(double param) {
        return (Math.log10(param) - this.min) / (this.max - this.min);
    }

    @Override
    public double getModelCoordinateFromAxisCoordinate(double param) {
        return Math.pow(10.0, this.min + param * (this.max - this.min));
    }
}

