/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.openide.util.lookup.NamedServiceDefinition;
import org.openide.util.lookup.implspi.AbstractServiceProviderProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class NamedServiceProcessor
extends AbstractServiceProviderProcessor {
    private static final String PATH = "META-INF/namedservices.index";
    private static Pattern reference = Pattern.compile("@([^/]+)\\(\\)");

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> all = new HashSet<String>();
        all.add(NamedServiceDefinition.class.getName());
        NamedServiceProcessor.searchAnnotations(all, true);
        return all;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(NamedServiceDefinition.class)) {
            Target target;
            Retention ret;
            ExecutableElement attr;
            NamedServiceDefinition nsd = element.getAnnotation(NamedServiceDefinition.class);
            Matcher m = reference.matcher(nsd.path());
            while (m.find()) {
                attr = NamedServiceProcessor.findAttribute(element, m.group(1));
                if (attr == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The path attribute contains '" + m.group(0) + "' reference, but there is no attribute named '" + m.group(1) + "'", element);
                    continue;
                }
                TypeMirror typeMirror = attr.getReturnType();
                TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
                if (this.processingEnv.getTypeUtils().isAssignable(typeMirror, stringType)) continue;
                ArrayType arrStringType = this.processingEnv.getTypeUtils().getArrayType(stringType);
                if (this.processingEnv.getTypeUtils().isAssignable(typeMirror, arrStringType)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The path attribute contains '" + m.group(0) + "' reference, but attribute '" + m.group(1) + "' does not return String or String[]", element);
            }
            if (!nsd.position().equals("-")) {
                attr = NamedServiceProcessor.findAttribute(element, nsd.position());
                if (attr == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The position attribute contains '" + nsd.position() + "' but no such attribute found.", element);
                } else if (!this.processingEnv.getTypeUtils().isSameType(this.processingEnv.getTypeUtils().getPrimitiveType(TypeKind.INT), attr.getReturnType())) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The position attribute contains '" + nsd.position() + "' but the attribute does not return int.", element);
                }
            }
            if ((ret = element.getAnnotation(Retention.class)) == null || ret.value() != RetentionPolicy.SOURCE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Please specify @Retention(RetentionPolicy.SOURCE) on this annotation", element);
            }
            if ((target = element.getAnnotation(Target.class)) == null || target.value().length != 1 || target.value()[0] != ElementType.TYPE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Please specify @Target(ElementType.TYPE) on this annotation", element);
            }
            this.register(element, PATH);
        }
        HashSet<String> index = new HashSet<String>();
        NamedServiceProcessor.searchAnnotations(index, false);
        for (String className : index) {
            Class<Annotation> c;
            try {
                c = Class.forName(className).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(c)) {
                Annotation a = element.getAnnotation(c);
                NamedServiceDefinition nsd = c.getAnnotation(NamedServiceDefinition.class);
                int cnt = 0;
                for (Class<?> type : nsd.serviceType()) {
                    TypeMirror typeMirror = this.processingEnv.getTypeUtils().erasure(this.asType(type));
                    if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), typeMirror)) continue;
                    ++cnt;
                    for (String p : this.findPath(nsd.path(), a)) {
                        this.register(element, c, typeMirror, p, (int)this.findPosition(nsd.position(), a), new String[0]);
                    }
                }
                if (cnt != 0) continue;
                StringBuilder sb = new StringBuilder();
                String prefix = "The type does not ";
                for (Class<?> type : nsd.serviceType()) {
                    sb.append(prefix);
                    if (type.isInterface()) {
                        sb.append("implement ").append(type.getCanonicalName());
                    } else {
                        sb.append("subclass ").append(type.getCanonicalName());
                    }
                    prefix = ", neither it does ";
                }
                sb.append('.');
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, sb.toString(), element);
            }
        }
        return true;
    }

    private TypeMirror asType(Class<?> type) {
        return this.processingEnv.getElementUtils().getTypeElement(type.getName()).asType();
    }

    /*
     * Unable to fully structure code
     */
    private List<String> findPath(String path, Annotation a) {
        arr = new ArrayList<String>();
        arr.add(path);
        while (true) {
            block3: for (i = 0; i < arr.size(); ++i) {
                m = NamedServiceProcessor.reference.matcher((CharSequence)arr.get(i));
                if (!m.find()) continue;
                methodName = m.group(1);
                try {
                    obj = a.getClass().getMethod(methodName, new Class[0]).invoke((Object)a, new Object[0]);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(methodName, ex);
                }
                if (obj instanceof String) {
                    arr.set(i, NamedServiceProcessor.substitute(path, m, (String)obj));
                    continue;
                }
                if (obj instanceof String[]) {
                    subs = (String[])obj;
                    arr.set(i, NamedServiceProcessor.substitute(path, m, subs[0]));
                    j = 1;
                    while (true) {
                        if (j < subs.length) ** break;
                        continue block3;
                        arr.add(NamedServiceProcessor.substitute(path, m, subs[j]));
                        ++j;
                    }
                }
                throw new IllegalStateException("Wrong return value " + obj);
            }
            break;
        }
        return arr;
    }

    private Integer findPosition(String posDefinition, Annotation a) {
        if (posDefinition.length() == 1 && posDefinition.charAt(0) == '-') {
            try {
                return (Integer)a.getClass().getMethod("position", new Class[0]).invoke((Object)a, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                return Integer.MAX_VALUE;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        try {
            return (Integer)a.getClass().getMethod(posDefinition, new Class[0]).invoke((Object)a, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void searchAnnotations(Set<String> found, boolean canonicalName) {
        try {
            Enumeration<URL> en = NamedServiceProcessor.class.getClassLoader().getResources(PATH);
            while (en.hasMoreElements()) {
                String line;
                URL url = en.nextElement();
                InputStream is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    if (canonicalName) {
                        line = line.replace('$', '.');
                    }
                    found.add(line);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String substitute(String path, Matcher m, String obj) {
        return path.substring(0, m.start(0)) + obj + path.substring(m.end(0));
    }

    private static ExecutableElement findAttribute(Element e, String attrName) {
        for (Element element : e.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(attrName)) continue;
            return (ExecutableElement)element;
        }
        return null;
    }
}

