/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.ChillerPLCState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;

@SkipEncoding
public class ChillerPlcState
implements Serializable {
    private ChillerPLCState plcState = ChillerPLCState.STOPPED;
    private final SwitchState[] switchState = new SwitchState[1];
    private final LatchState[] latchState = new LatchState[5];
    private final ConditionState[] conditionState = new ConditionState[12];
    private static final long serialVersionUID = -8025759035234214279L;

    public ChillerPlcState() {
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.OFFLINE);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.OFF);
    }

    public void setPlcState(ChillerPLCState value) {
        this.plcState = value;
    }

    public ChillerPLCState getPlcState() {
        return this.plcState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }
}

