/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.canopenjni.CanSocket;

public class CanDump {
    public static void main(String[] args) throws Exception {
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        String itf = (String)props.getOrDefault((Object)"itf", "can0");
        System.out.println("dumping " + itf);
        CanSocket socket = new CanSocket(CanSocket.Mode.RAW);
        CanSocket.CanInterface canIf = new CanSocket.CanInterface(socket, itf);
        socket.bind(canIf);
        File file = new File(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "_candump.log");
        PrintWriter pw = new PrintWriter(file);
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            CanSocket.CanFrame f = socket.recv();
                            String s = String.format("%-10s  %03x  [%d] ", itf, f.getCanId().getCanId_SFF(), f.getData().length);
                            for (int n : f.getData()) {
                                s = s + String.format("%02X ", (byte)n);
                            }
                            System.out.println(s);
                            s = String.format("%s,%d,%d", LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), f.getCanId().getCanId_SFF(), f.getData().length);
                            for (int n : f.getData()) {
                                int x = n;
                                if (x < 0) {
                                    x += 256;
                                }
                                s = s + String.format(",%d", x);
                            }
                            pw.println(s);
                            pw.flush();
                        }
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (pw != null) {
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    pw.close();
                }
            }
            throw throwable3;
        }
    }
}

