/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.Font;
import java.util.EnumMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.RTD;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.gui.PageActions;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class GUIUtil {
    private static final Logger LOG = Logger.getLogger(GUIUtil.class.getName());
    private static final Font IN_RANGE_FONT = new JTextField().getFont();
    private static final Font OUT_OF_RANGE_FONT = IN_RANGE_FONT.deriveFont(2);
    private static final Color IN_RANGE_COLOR = Color.GREEN;
    private static final Color OUT_OF_RANGE_COLOR = Color.RED;

    private GUIUtil() {
    }

    public static PageActions fakeDispatcher() {
        return new PageActions(){

            @Override
            public void calibrate() {
                LOG.info("calibrate()");
            }

            @Override
            public void toggleSafetyCheck() {
                LOG.info("toggleSafetyCheck()");
            }

            @Override
            public void center() {
                LOG.info("center()");
            }

            @Override
            public void changeBrakeState(ShutterSide side, boolean brakeEngaged) {
                LOG.log(Level.INFO, "changeBrakeState({0}, {1})", new Object[]{side, brakeEngaged});
            }

            @Override
            public void closeShutter() {
                LOG.info("closeShutter()");
            }

            @Override
            public void connect() {
                LOG.info("connect()");
            }

            @Override
            public void disconnect() {
                LOG.info("disconnect()");
            }

            @Override
            public void prodMode() {
                LOG.info("prodMode()");
            }

            @Override
            public void openShutter() {
                LOG.info("openShutter()");
            }

            @Override
            public void resync() {
                LOG.info("resync()");
            }

            @Override
            public void showStateBundle(PhysicalState phys, SoftwareState soft) {
                LOG.log(Level.INFO, "showStateBundle({0}, {1})", new Object[]{phys, soft});
            }

            @Override
            public void showStatus(ShutterStatus status) {
                LOG.log(Level.INFO, "showStatus({0})", status);
            }

            @Override
            public void showWorkerIsReachable() {
                LOG.info("showWorkerIsReachable()");
            }

            @Override
            public void showWorkerIsUnreachable(String message) {
                LOG.log(Level.INFO, "showWorkerIsUnreachable({0})", message);
            }

            @Override
            public void showTrajectory(MotionDone motion) {
                LOG.log(Level.INFO, "showTrajectory({0})", motion);
            }

            @Override
            public void stopMotion() {
                LOG.info("stopMotion()");
            }

            @Override
            public void takeExposure(double exposureTime) {
                LOG.log(Level.INFO, "takeExposure({0})", exposureTime);
            }
        };
    }

    public static ShutterStatus exampleShutterStatus() {
        EnumMap<ShutterSide, ShutterStatus.AxisStatus> axes = new EnumMap<ShutterSide, ShutterStatus.AxisStatus>(ShutterSide.class);
        for (ShutterSide side : ShutterSide.values()) {
            ShutterStatus.AxisStatus axstat = new ShutterStatus.AxisStatus(side == ShutterSide.PLUSX ? 123.0 : 631.0, side == ShutterSide.PLUSX ? 1667.0 : -1234.0, 0.0, true, side == ShutterSide.PLUSX, false, false, true, 0, side == ShutterSide.PLUSX ? 30.0 : -100.0, side == ShutterSide.PLUSX);
            axes.put(side, axstat);
        }
        TreeMap<RTD, Double> temperature = new TreeMap<RTD, Double>();
        TreeMap<RTD, Boolean> tempIsSafe = new TreeMap<RTD, Boolean>();
        for (RTD rtd : RTD.values()) {
            temperature.put(rtd, 10.0 + (double)rtd.getIndex() * 10.0);
            tempIsSafe.put(rtd, Boolean.FALSE);
        }
        tempIsSafe.put(RTD.MINUSX_MOTOR, Boolean.TRUE);
        ShutterStatus status = new ShutterStatus(0, true, 0, axes, true, temperature, tempIsSafe);
        return status;
    }

    public static Font rangeFont(boolean inRange) {
        return inRange ? IN_RANGE_FONT : OUT_OF_RANGE_FONT;
    }

    public static Color rangeColor(boolean inRange) {
        return inRange ? IN_RANGE_COLOR : OUT_OF_RANGE_COLOR;
    }
}

