/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerThreeOnlineClampsPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoLatchesPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoTrucksPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.PLCAutochangerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = -975949078768889254L;
    protected InterfaceAutochangerGUI subs;
    protected EPOSControllerPanel acTruckXminusControllerPanel;
    protected EPOSControllerPanel acTruckXplusControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel latchXplusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXplusControllerPanel;
    protected EPOSControllerPanel onlineClampYminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    protected CanOpenDevicePanel onlineStrainGaugePanel;
    private EPOSControllerPanel[] controllerPanelsList;
    protected AutochangerThreeOnlineClampsPanel onlineClampsPanel;
    private AutochangerTwoTrucksPanel acTrucksPanel;
    private AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();
    private AutochangerThreeOnlineClampsPanel acClampsPanel = new AutochangerThreeOnlineClampsPanel();
    private final AutochangerGeneralViewPanel acGeneralViewPanel = new AutochangerGeneralViewPanel();
    private PLCAutochangerPanel plcAutochangerPanel;

    public AutochangerGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.setName("AutochangerGatherPanel");
    }

    public AutochangerGatherPanel(InterfaceAutochangerGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.acGeneralViewPanel.setSubsystem(subs);
        this.acClampsPanel.setSubsystem(subs);
        this.acLatchesPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.acTruckXminusControllerPanel.setSubsystem(subs);
        this.acTruckXplusControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXplusControllerPanel.setSubsystem(subs);
        this.onlineClampYminusControllerPanel.setSubsystem(subs);
        this.setName("AutochangerGatherPanel");
    }

    public AutochangerTwoTrucksPanel getAcTrucksPanel() {
        return this.acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return this.acLatchesPanel;
    }

    public AutochangerThreeOnlineClampsPanel getAcClampsPanel() {
        return this.acClampsPanel;
    }

    public AutochangerGeneralViewPanel getAcGeneralViewPanel() {
        return this.acGeneralViewPanel;
    }

    public EPOSControllerPanel getAcTruckXminusControllerPanel() {
        return this.acTruckXminusControllerPanel;
    }

    public EPOSControllerPanel getAcTruckXplusControllerPanel() {
        return this.acTruckXplusControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.latchXminusControllerPanel;
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return this.latchXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.onlineClampXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return this.onlineClampXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampYminusControllerPanel() {
        return this.onlineClampYminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    public CanOpenDevicePanel getOnlineStrainGaugePanel() {
        return this.onlineStrainGaugePanel;
    }

    public PLCAutochangerPanel getPLCAutochangerPanel() {
        return this.plcAutochangerPanel;
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    @Override
    public void initializeGuiWithAutochangerSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        this.plutoGatewayPanel.initializeGuiWithSensorsList(configInfo, sensorsList);
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        if ("canbus0".equals(data.getKey())) {
            this.updateCanOpenHardwarePanel((Integer)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
            this.updateController(Tools.getShortComponentName(data.getKey()), (StatusDataPublishedByEPOSController)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByPlutoGateway) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
            this.plutoGatewayPanel.updatePlutoGateway(Tools.getShortComponentName(data.getKey()), (StatusDataPublishedByPlutoGateway)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
            this.onlineStrainGaugePanel.updateCanOpenDevice(Tools.getShortComponentName(data.getKey()), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTruck) {
            this.updateTruck(data.getKey(), (StatusDataPublishedByAutochangerTruck)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutoChangerTrucks) {
            this.updateTrucks((StatusDataPublishedByAutoChangerTrucks)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerLatch) {
            this.updateLatch(data.getKey(), (StatusDataPublishedByAutochangerLatch)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerTwoLatches) {
            this.updateLatches((StatusDataPublishedByAutochangerTwoLatches)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerOnlineClamp) {
            this.updateClamp(data.getKey(), (StatusDataPublishedByAutochangerOnlineClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByAutochangerThreeClamps) {
            this.updateClamps((StatusDataPublishedByAutochangerThreeClamps)data.getValue());
        } else if (data.getValue() instanceof KeyValueDataList && "acSensorsGateway".equals(Tools.getShortComponentName(data.getKey()))) {
            this.plutoGatewayPanel.updateSensor((KeyValueDataList)data.getValue());
            Map<String, Serializable> sensorMap = ((KeyValueDataList)data.getValue()).getListOfKeyValueData().stream().collect(Collectors.toMap(KeyValueData::getKey, KeyValueData::getValue));
            this.plcAutochangerPanel.updateFromSensorList(sensorMap);
            this.acGeneralViewPanel.updateFromSensorList(sensorMap);
        }
    }

    public void updateController(String name, StatusDataPublishedByEPOSController controllerStatus) {
        for (EPOSControllerPanel ctlPanel : this.controllerPanelsList) {
            ctlPanel.updateController(name, controllerStatus);
        }
        this.acTrucksPanel.updateController(name, controllerStatus);
        this.acClampsPanel.updateController(name, controllerStatus);
        this.acLatchesPanel.updateController(name, controllerStatus);
    }

    protected void updateClamp(String clampLongName, StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClamp(Tools.getShortComponentName(clampLongName), s);
    }

    protected void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        this.acClampsPanel.updateClamps(s);
        this.acGeneralViewPanel.updateClamps(s);
    }

    protected void updateLatch(String latchLongName, StatusDataPublishedByAutochangerLatch s) {
        this.acLatchesPanel.updateLatch(Tools.getShortComponentName(latchLongName), s);
    }

    protected void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.acLatchesPanel.updateLatches(s);
        this.acGeneralViewPanel.updateLatches(s);
    }

    protected void updateTruck(String truckLongName, StatusDataPublishedByAutochangerTruck s) {
        this.acTrucksPanel.updateTruck(Tools.getShortComponentName(truckLongName), s);
    }

    protected void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        this.acTrucksPanel.updateTrucks(s);
        this.acGeneralViewPanel.updateTrucks(s);
    }

    private void initPanels() {
        String fullPathPrefix = this.getCanOpenHardwareListPanel().getTcpProxyName() + "/";
        this.acTruckXminusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "acTruckXminusController");
        this.acTruckXplusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "acTruckXplusController");
        this.latchXminusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "latchXminusController");
        this.latchXplusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "latchXplusController");
        this.onlineClampXminusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "onlineClampXminusController");
        this.onlineClampXplusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "onlineClampXplusController");
        this.onlineClampYminusControllerPanel = new EPOSControllerPanel(fullPathPrefix + "onlineClampYminusController");
        this.controllerPanelsList = new EPOSControllerPanel[]{this.acTruckXminusControllerPanel, this.acTruckXplusControllerPanel, this.latchXminusControllerPanel, this.latchXplusControllerPanel, this.onlineClampXminusControllerPanel, this.onlineClampXplusControllerPanel, this.onlineClampYminusControllerPanel};
        this.plutoGatewayPanel = new PlutoGatewayPanel(fullPathPrefix + "acSensorsGateway");
        this.onlineStrainGaugePanel = new CanOpenDevicePanel(fullPathPrefix + "onlineStrainGauge");
        this.acClampsPanel = new AutochangerThreeOnlineClampsPanel();
        this.acLatchesPanel = new AutochangerTwoLatchesPanel();
        this.acTrucksPanel = new AutochangerTwoTrucksPanel("autochanger/autochangerTrucks");
        this.plcAutochangerPanel = new PLCAutochangerPanel();
    }

    @Override
    public void resetPanel() {
        FCSLOG.info((Object)(this.getName() + " resetting panels"));
        super.resetPanel();
        this.acTruckXminusControllerPanel.resetPanel();
        this.acTruckXplusControllerPanel.resetPanel();
        this.latchXminusControllerPanel.resetPanel();
        this.latchXplusControllerPanel.resetPanel();
        this.onlineClampXminusControllerPanel.resetPanel();
        this.onlineClampXplusControllerPanel.resetPanel();
        this.onlineClampYminusControllerPanel.resetPanel();
        this.plutoGatewayPanel.resetPanel();
        this.onlineStrainGaugePanel.resetPanel();
        this.acGeneralViewPanel.resetPanel();
        this.acLatchesPanel.resetPanel();
        this.acTrucksPanel.resetPanel();
        this.acClampsPanel.resetPanel();
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            AutochangerGatherPanel.this.acGeneralViewPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acClampsPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acLatchesPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acTrucksPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acTruckXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.acTruckXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.latchXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.latchXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampXminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampXplusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineClampYminusControllerPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.plutoGatewayPanel.initializeGui(this.configInfo);
            AutochangerGatherPanel.this.onlineStrainGaugePanel.initializeGui(this.configInfo);
        }
    }
}

