/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.SNode;

public class SummaryTableView
extends AbstractMonitorView {
    public static final String CREATOR_PATH = "Built-In/Aggregating/Summary Table";
    private final AbstractMonitorView.Descriptor descriptor = new AbstractMonitorView.Descriptor();
    private JScrollPane scrollPane;
    private int nColumns;
    private List<MonitorField> columnFields;
    private List<String> columnNames;
    private Model model;
    private Table table;
    private final Set<SNode<Cell[]>> changedNodes = Collections.newSetFromMap(new IdentityHashMap());

    @Create(category="MonitorView", name="Summary Table View", path="Built-In/Aggregating/Summary Table", description="Monitoring data view that displays a summary table, one column per group of channels. Groups are determined by the last segment in the display path.")
    public SummaryTableView() {
    }

    @Override
    public JComponent getPanel() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(new MonitorDisplay.EMPTY());
        }
        return this.scrollPane;
    }

    @Override
    public void install() {
        ThreadUtil.invokeLater(this::start);
        super.install();
    }

    @Override
    public void uninstall() {
        super.uninstall();
        ThreadUtil.invokeLater(this::stop);
    }

    private void start() {
        if (this.filter == null) {
            throw new IllegalStateException("Trying to initialize SummaryTableView without a filter.");
        }
    }

    private void stop() {
        if (this.model != null) {
            this.scrollPane.setViewportView(new MonitorDisplay.EMPTY());
            this.table = null;
            this.model.destroy();
            this.model = null;
        }
    }

    @Override
    protected void resetChannels() {
        if (this.model != null) {
            this.model.destroy();
        }
        this.model = new Model();
        this.table = new Table(this.model);
        this.scrollPane.setViewportView((Component)((Object)this.table));
    }

    @Override
    protected void update() {
        this.changedNodes.forEach(node -> this.model.nodeChanged((TreeNode)node));
        this.changedNodes.clear();
    }

    @Override
    public AbstractMonitorView.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class Table
    extends JXTreeTable {
        Table(TreeTableModel model) {
            super(model);
            MonitorTableCellRenderer renderer = new MonitorTableCellRenderer();
            this.setDefaultRenderer(FormattedValue.class, renderer);
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setShowGrid(true);
            this.setGridColor(Color.DARK_GRAY);
            this.setRowMargin(1);
            this.setColumnMargin(1);
        }

        protected void resetDefaultTableCellRendererColors(Component renderer, int row, int column) {
        }
    }

    private class Cell
    implements MonitorCell,
    Updatable {
        private SNode<Cell[]> node;
        private final int column;
        private final ArrayList<DisplayChannel> channels;
        private FormattedValue formattedValue;

        Cell(SNode<Cell[]> node, int column, ArrayList<DisplayChannel> channels) {
            this.node = node;
            this.column = column;
            this.channels = channels;
        }

        @Override
        public FormattedValue getFormattedValue() {
            return this.formattedValue;
        }

        @Override
        public void setFormattedValue(FormattedValue formattedValue) {
            this.formattedValue = formattedValue;
        }

        @Override
        public MonitorField getField() {
            return SummaryTableView.this.columnFields == null ? MonitorField.DEFAULT_GROUP_FIELD : (MonitorField)SummaryTableView.this.columnFields.get(this.column);
        }

        @Override
        public List<DisplayChannel> getChannels() {
            return this.channels;
        }

        @Override
        public void update(DisplayChannel channelHandle) {
            this.formattedValue = null;
            TreeNode parentNode = this.node.getParent();
            if (parentNode != SummaryTableView.this.model.getRoot()) {
                ((Cell[])((SNode)parentNode).getUserObject())[this.column].update(channelHandle);
            }
            SummaryTableView.this.changedNodes.add(this.node);
        }

        void setNode(SNode<Cell[]> node) {
            this.node = node;
            this.channels.trimToSize();
            this.channels.forEach(dc -> {
                if (dc.getTarget() == null) {
                    dc.setTarget(this);
                }
            });
        }
    }

    private class Model
    extends SModel<Cell[]>
    implements TreeTableModel {
        Model() {
            SummaryTableView.this.columnFields = SummaryTableView.this.getGroupFields();
            SummaryTableView.this.columnNames = SummaryTableView.this.getGroups();
            SummaryTableView.this.nColumns = SummaryTableView.this.columnNames.size();
            LinkedHashMap path2row = new LinkedHashMap();
            SummaryTableView.this.data.forEach((displayPath, displayChannel) -> {
                int i = displayPath.lastIndexOf("/");
                String path = displayPath.substring(0, i);
                String columnName = displayPath.substring(i + 1);
                int columnIndex = SummaryTableView.this.columnNames.indexOf(columnName);
                if (columnIndex != -1) {
                    Cell[] row = (Cell[])path2row.get(path);
                    if (row == null) {
                        row = new Cell[SummaryTableView.this.nColumns];
                        for (int col = 0; col < SummaryTableView.this.nColumns; ++col) {
                            row[col] = new Cell(null, col, new ArrayList<DisplayChannel>());
                        }
                        path2row.put(path, row);
                    }
                    row[columnIndex].channels.add(displayChannel);
                }
            });
            this.update(path2row);
            Object rootNode = this.getRoot();
            if (rootNode != null) {
                Enumeration<TreeNode> en = ((DefaultMutableTreeNode)rootNode).postorderEnumeration();
                while (en.hasMoreElements()) {
                    int col;
                    SNode node = (SNode)en.nextElement();
                    if (node == rootNode) continue;
                    Cell[] cells = (Cell[])node.getUserObject();
                    TreeNode parentNode = node.getParent();
                    if (parentNode == rootNode) {
                        for (Cell cell : cells) {
                            cell.setNode(node);
                        }
                        continue;
                    }
                    Cell[] parentCells = (Cell[])((SNode)parentNode).getUserObject();
                    if (parentCells == null) {
                        parentCells = new Cell[SummaryTableView.this.nColumns];
                        for (col = 0; col < SummaryTableView.this.nColumns; ++col) {
                            Cell cell = cells[col];
                            parentCells[col] = new Cell(null, col, new ArrayList<DisplayChannel>(cell.channels));
                            cell.setNode(node);
                        }
                        ((DefaultMutableTreeNode)parentNode).setUserObject(parentCells);
                        continue;
                    }
                    for (col = 0; col < SummaryTableView.this.nColumns; ++col) {
                        Cell cell = cells[col];
                        parentCells[col].channels.addAll(cell.channels);
                        cell.setNode(node);
                    }
                }
            }
        }

        void destroy() {
            Enumeration<TreeNode> en = ((DefaultMutableTreeNode)this.getRoot()).depthFirstEnumeration();
            while (en.hasMoreElements()) {
                Cell[] cc = (Cell[])((SNode)en.nextElement()).getUserObject();
                if (cc == null) continue;
                for (Cell c : cc) {
                    for (DisplayChannel dc : c.getChannels()) {
                        dc.setTarget(null);
                    }
                }
            }
        }

        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Object.class : FormattedValue.class;
        }

        public int getColumnCount() {
            return SummaryTableView.this.columnNames.size() + 1;
        }

        public String getColumnName(int column) {
            return column == 0 ? "" : (String)SummaryTableView.this.columnNames.get(column - 1);
        }

        public int getHierarchicalColumn() {
            return 0;
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return node;
            }
            SNode sNode = (SNode)node;
            Cell[] cells = (Cell[])sNode.getUserObject();
            if (cells == null) {
                return FormattedValue.EMPTY;
            }
            Cell c = cells[column - 1];
            FormattedValue fv = c.getFormattedValue();
            if (fv == null) {
                MonitorFormat.DEFAULT.format(c);
                fv = c.getFormattedValue();
            }
            return fv;
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public void setValueAt(Object value, Object node, int column) {
        }
    }
}

