/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.Color;
import java.util.Arrays;
import javax.swing.JPanel;
import plotter.Axis;
import plotter.DataArea;
import plotter.Histogram1DOverlay;
import plotter.LinearAxisModel;
import plotter.PlotLayout;
import plotter.ScaledAxisModel;
import plotter.StringAxisModel;
import plotter.TestFrame;

public class TemperatureDemo {
    private static double[] maxTemperature = new double[]{16.1, 16.1, 17.8, 21.3, 25.8, 30.7, 33.5, 33.6, 30.1, 26.7, 21.7, 17.8};
    private static double[] minTemperature = new double[]{7.3, 6.8, 7.8, 10.5, 14.0, 18.5, 21.0, 21.3, 18.8, 16.0, 12.0, 9.2};
    private static String[] month = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static void main(String[] args) {
        StringAxisModel xModel = new StringAxisModel(Arrays.asList(month));
        LinearAxisModel yModel = new LinearAxisModel(0.0, 35.0);
        ScaledAxisModel y2Model = new ScaledAxisModel(yModel, 32.0, 1.8);
        Axis bottomAxis = new Axis(xModel, Axis.AxisPosition.BOTTOM);
        Axis leftAxis = new Axis(yModel, Axis.AxisPosition.LEFT);
        leftAxis.setTitle("\u00b0C");
        Axis rightAxis = new Axis(y2Model, Axis.AxisPosition.RIGHT);
        rightAxis.setTitle("\u00b0F");
        Histogram1DOverlay overlay1 = new Histogram1DOverlay("Max", maxTemperature, xModel, yModel);
        overlay1.setFillColor(Color.RED);
        overlay1.setBinWidthPercentage(50);
        Histogram1DOverlay overlay2 = new Histogram1DOverlay("Min", minTemperature, xModel, yModel);
        overlay2.setBinWidthPercentage(50);
        DataArea da = new DataArea(bottomAxis, leftAxis);
        da.setShowGrid(DataArea.GridStyle.HORIZONTAL);
        da.add(overlay1);
        da.add(overlay2);
        JPanel plotPanel = new JPanel(new PlotLayout());
        plotPanel.add(bottomAxis);
        plotPanel.add(leftAxis);
        plotPanel.add(rightAxis);
        plotPanel.add(da);
        new TestFrame("Temperature Demo", plotPanel);
    }
}

