/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.canopenjni;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.lsst.ccs.drivers.canopenjni.BootMessageListener;
import org.lsst.ccs.drivers.canopenjni.CanOpenInterface;
import org.lsst.ccs.drivers.canopenjni.CanSocket;
import org.lsst.ccs.drivers.canopenjni.ConcurrentCallException;
import org.lsst.ccs.drivers.canopenjni.EmergencyMessageListener;
import org.lsst.ccs.drivers.canopenjni.PDOData;
import org.lsst.ccs.drivers.canopenjni.SDOException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;

public class SocketCanOpen
implements CanOpenInterface {
    public static final Logger log = Logger.getLogger((String)"org.lsst.ccs.driver.canopenjni");
    private long sdoTimeout = 500L;
    private long pdoTimeout = 500L;
    int nodeId = -1;
    String devName;
    CanSocket socket;
    CanSocket.CanInterface canIf;
    Set<Integer> registeredPDOs = new HashSet<Integer>();
    Map<Integer, Instant> lastBeat = new ConcurrentHashMap<Integer, Instant>();
    Map<Integer, Integer> lastState = new ConcurrentHashMap<Integer, Integer>();
    Set<Integer> expectedSlaves = new HashSet<Integer>();
    SynchronousQueue<CanSocket.CanFrame> queue = new SynchronousQueue();
    volatile boolean loopReceive = true;

    @Override
    public void addSlave(int s) {
        this.expectedSlaves.add(s);
    }

    @Override
    public void addSlaves(int[] s) {
        IntStream.of(s).forEach(i -> this.expectedSlaves.add(i));
    }

    @Override
    public Instant getLastBeat(int id) {
        return this.lastBeat.get(id);
    }

    @Override
    public int getLastState(int id) {
        Integer l = this.lastState.get(id);
        return l == null ? -1 : l;
    }

    @Override
    public Set<Integer> getRegisteredPDOs() {
        return Collections.unmodifiableSet(this.registeredPDOs);
    }

    @Override
    public void addReceivedPDO(int cobId) throws DriverException {
        this.registeredPDOs.add(cobId);
    }

    @Override
    public void clearReceivedPDOs() throws DriverException {
        this.registeredPDOs.clear();
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String info(int nodeID) throws DriverException {
        return null;
    }

    @Override
    public void init(int master, String baud, String busName, int nodeID) throws DriverException {
        if (master == 0) {
            throw new DriverException("Slave mode not implemented");
        }
        log.info((Object)"canopenjni.SocketCanOpen 03-FEV-2023-10:40");
        if ("0".equals(busName)) {
            busName = "can0";
        } else if ("1".equals(busName)) {
            busName = "can1";
        }
        this.nodeId = nodeID;
        this.devName = busName;
        try {
            this.socket = new CanSocket(CanSocket.Mode.RAW);
            this.canIf = new CanSocket.CanInterface(this.socket, this.devName);
            this.socket.bind(this.canIf);
            this.startReceive();
            this.sentNMTResetCommAll();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendBootup();
            this.initSlaves();
        }
        catch (IOException e) {
            throw new DriverException("error during SocketCan init", (Throwable)e);
        }
    }

    private boolean allOperational() {
        for (int i : this.expectedSlaves) {
            if (this.lastState.get(i) != null && 5 == this.lastState.get(i)) continue;
            return false;
        }
        return true;
    }

    private void activateHeartBeat(int device) {
        try {
            this.wsdo(device, 4119, 0, 2, 1000L);
        }
        catch (DriverException e) {
            log.info((Object)("Could not activate heartbeat for device " + device + " wsdo failure"));
        }
    }

    private void initSlaves() throws DriverException {
        if (this.expectedSlaves.isEmpty()) {
            log.info((Object)"booting blindly the devices");
            this.sentNMTResetCommAll();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info((Object)"setting blindly the devices to operational");
            this.setNMTStateOperational(0);
            return;
        }
        log.info((Object)"devices init");
        this.setNMTStateOperational(0);
        long ts = System.currentTimeMillis();
        long initTimeout = 1300L;
        while (System.currentTimeMillis() < ts + initTimeout && !this.allOperational()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.allOperational()) {
            log.info((Object)"all devices operational");
            return;
        }
        HashSet<Integer> reboot = new HashSet<Integer>();
        HashSet<Integer> booted = new HashSet<Integer>();
        HashSet<Integer> hbActive = new HashSet<Integer>();
        HashSet<Integer> ops = new HashSet<Integer>();
        for (int i : this.expectedSlaves) {
            if (this.lastState.get(i) != null) continue;
            log.info((Object)String.format("reboot device %02x", i));
            reboot.add(i);
            this.reset(i);
        }
        ts = System.currentTimeMillis();
        while (!(System.currentTimeMillis() >= ts + initTimeout || reboot.isEmpty() && booted.isEmpty())) {
            try {
                for (int i : reboot) {
                    if (this.lastState.get(i) == null) continue;
                    if (this.lastState.get(i) != 5) {
                        log.info((Object)String.format("start device %02x", i));
                        this.ssta(i);
                    }
                    booted.add(i);
                }
                reboot.removeAll(booted);
                for (int i : booted) {
                    if (5 != this.lastState.get(i)) continue;
                    log.info((Object)String.format("device %02x operational", i));
                    ops.add(i);
                }
                booted.removeAll(ops);
                if (!reboot.isEmpty() || !booted.isEmpty()) {
                    Thread.sleep(100L);
                }
                if (System.currentTimeMillis() <= ts + initTimeout / 2L) continue;
                for (int i : booted) {
                    if (hbActive.contains(i) || this.lastState.get(i) == 5) continue;
                    log.info((Object)String.format("activate heartbeat device %02x", i));
                    this.activateHeartBeat(i);
                    hbActive.add(i);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void init() throws DriverException {
        throw new DriverException("Deprecated init method");
    }

    @Override
    public boolean isReady() throws DriverException {
        return this.nodeId > 0;
    }

    private void checkState() throws DriverException {
        if (!this.isReady()) {
            throw new DriverException("driver in invalid state, before init or after quit");
        }
    }

    @Override
    public void quit() throws DriverException {
        this.stopReceive();
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
                this.nodeId = -1;
            }
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    @Override
    public void reset(int nodeId) throws DriverException {
        this.checkState();
        this.sendNMT((byte)-127, (byte)nodeId);
    }

    @Override
    public synchronized int scan() throws DriverException {
        this.initSlaves();
        return 0;
    }

    @Override
    public void setBootMessageListener(BootMessageListener bml) throws DriverException {
        throw new DriverException("Unimplemented method");
    }

    @Override
    public void setEmergencyMessageListener(EmergencyMessageListener eml) throws DriverException {
        throw new DriverException("Unimplemented method");
    }

    @Override
    public void setNMTStateOperational(int nodeId) throws DriverException {
        this.checkState();
        this.sendNMT((byte)1, (byte)nodeId);
    }

    @Override
    public void setPdoTimeout(long to) throws DriverException {
        this.pdoTimeout = to;
    }

    @Override
    public void setSdoTimeout(long to) throws DriverException {
        this.sdoTimeout = to;
    }

    @Override
    public void ssta(int nodeId) throws DriverException {
        this.checkState();
        this.sendNMT((byte)1, (byte)nodeId);
    }

    @Override
    public void ssto(int nodeId) throws DriverException {
        this.checkState();
        this.sendNMT((byte)2, (byte)nodeId);
    }

    @Override
    public void start() throws DriverException {
    }

    @Override
    public void stop() throws DriverException {
    }

    @Override
    public synchronized PDOData sync() throws DriverException {
        this.checkState();
        this.sendSync();
        return this.rcvPDO();
    }

    @Override
    public synchronized long rsdo(int nodeId, int index, int subindex) throws DriverException, DriverTimeoutException, ConcurrentCallException {
        this.checkState();
        this.emptyQueue();
        byte[] respStart = this.sendRsdo(nodeId, index, subindex);
        CanSocket.CanFrame f = this.getNextFrame(1408 + nodeId, respStart, this.sdoTimeout);
        if (f == null) {
            throw new DriverException("No RSDO ACK");
        }
        byte[] data = f.getData();
        long value = (long)data[4] & 0xFFL | ((long)data[5] & 0xFFL) << 8 | ((long)data[6] & 0xFFL) << 16 | ((long)data[7] & 0xFFL) << 24;
        if (data[0] == -128) {
            throw new SDOException("RSDO error code " + String.format("%08x", value), nodeId, index, subindex, 0, (int)value);
        }
        return value;
    }

    @Override
    public synchronized void wsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException, DriverTimeoutException, ConcurrentCallException {
        this.checkState();
        this.emptyQueue();
        byte[] respStart = this.sendWsdo(nodeId, index, subindex, size, data);
        CanSocket.CanFrame f = this.getNextFrame(1408 + nodeId, respStart, this.sdoTimeout);
        if (f == null) {
            throw new DriverException("No WSDO ACK");
        }
        byte[] respData = f.getData();
        long value = (long)respData[4] & 0xFFL | ((long)respData[5] & 0xFFL) << 8 | ((long)respData[6] & 0xFFL) << 16 | ((long)respData[7] & 0xFFL) << 24;
        if (respData[0] == -128) {
            throw new SDOException("WSDO error code " + String.format("%08x", value), nodeId, index, subindex, 0, (int)value);
        }
    }

    private void sendSync() throws DriverException {
        try {
            CanSocket.CanFrame syncFrame = new CanSocket.CanFrame(this.canIf, new CanSocket.CanId(128), new byte[0]);
            this.emptyQueue();
            this.socket.send(syncFrame);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void sendBootup() throws DriverException {
        try {
            CanSocket.CanFrame bootFrame = new CanSocket.CanFrame(this.canIf, new CanSocket.CanId(1792 + this.nodeId), new byte[]{5});
            this.socket.send(bootFrame);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void sendNMT(byte command, byte target) throws DriverException {
        try {
            CanSocket.CanFrame nmtFrame = new CanSocket.CanFrame(this.canIf, new CanSocket.CanId(0), new byte[]{command, target});
            this.socket.send(nmtFrame);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void sentNMTResetCommAll() throws DriverException {
        this.sendNMT((byte)-126, (byte)0);
    }

    private void emptyQueue() {
        while (true) {
            try {
                while (this.queue.poll(10L, TimeUnit.MICROSECONDS) != null) {
                }
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private byte[] sendWsdo(int nodeId, int index, int subindex, int size, long data) throws DriverException {
        if (size > 4) {
            throw new DriverException("Only expedited transfers are implemented, size " + size + " bytes unsopported");
        }
        if (size < 1) {
            throw new DriverException("bad size " + size + " bytes unsopported");
        }
        byte cmd = (byte)(47 - 4 * (size - 1));
        CanSocket.CanFrame wsdoFrame = new CanSocket.CanFrame(this.canIf, new CanSocket.CanId(1536 + nodeId), new byte[]{cmd, (byte)(index & 0xFF), (byte)(index >> 8 & 0xFF), (byte)subindex, (byte)(data & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL)});
        try {
            this.socket.send(wsdoFrame);
            return new byte[]{96, (byte)(index & 0xFF), (byte)(index >> 8 & 0xFF), (byte)subindex};
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private byte[] sendRsdo(int nodeId, int index, int subindex) throws DriverException {
        CanSocket.CanFrame rsdoFrame = new CanSocket.CanFrame(this.canIf, new CanSocket.CanId(1536 + nodeId), new byte[]{64, (byte)(index & 0xFF), (byte)(index >> 8 & 0xFF), (byte)subindex, 0, 0, 0, 0});
        try {
            this.socket.send(rsdoFrame);
            return new byte[]{-1, (byte)(index & 0xFF), (byte)(index >> 8 & 0xFF), (byte)subindex};
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void runReceive() {
        while (this.loopReceive) {
            try {
                CanSocket.CanFrame f = this.socket.recv();
                if (f == null) continue;
                int cobid = f.getCanId().getCanId_SFF();
                int cob = cobid >> 7;
                int id = cobid & 0x7F;
                if (cob == 14) {
                    this.lastBeat.put(id, Instant.now());
                    this.lastState.put(id, Integer.valueOf(f.getData()[0]));
                    continue;
                }
                this.queue.put(f);
            }
            catch (IOException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void startReceive() {
        this.loopReceive = true;
        new Thread(() -> this.runReceive()).start();
    }

    private void stopReceive() {
        this.loopReceive = false;
    }

    private CanSocket.CanFrame getNextFrame(long timeout) {
        try {
            return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private CanSocket.CanFrame getNextFrame(int canid, long timeout) {
        long ts = System.currentTimeMillis();
        while (System.currentTimeMillis() < ts + timeout) {
            CanSocket.CanFrame f = this.getNextFrame(timeout);
            if (f == null || f.getCanId().getCanId_SFF() != canid) continue;
            return f;
        }
        return null;
    }

    private CanSocket.CanFrame getNextFrame(int canid, byte[] dataStart, long timeout) {
        long ts = System.currentTimeMillis();
        block0: while (System.currentTimeMillis() < ts + timeout) {
            byte[] data;
            CanSocket.CanFrame f = this.getNextFrame(timeout);
            if (f == null || f.getCanId().getCanId_SFF() != canid || (data = f.getData())[0] != dataStart[0] && data[0] != -128 && dataStart[0] != -1) continue;
            for (int i = 1; i < dataStart.length; ++i) {
                if (data[i] != dataStart[i]) continue block0;
            }
            return f;
        }
        return null;
    }

    private PDOData rcvPDO() {
        PDOData pdata = new PDOData();
        HashSet<Integer> expectedPDOs = new HashSet<Integer>();
        expectedPDOs.addAll(this.registeredPDOs);
        long ts = System.currentTimeMillis();
        while (System.currentTimeMillis() < ts + this.pdoTimeout && !expectedPDOs.isEmpty()) {
            int canid;
            CanSocket.CanFrame f = this.getNextFrame(this.pdoTimeout);
            if (f == null || !expectedPDOs.contains(canid = f.getCanId().getCanId_SFF())) continue;
            expectedPDOs.remove(canid);
            byte[] fdata = f.getData();
            long value = 0L;
            for (int i = fdata.length - 1; i >= 0; --i) {
                value = value << 8 | (long)fdata[i] & 0xFFL;
            }
            pdata.updatePDO(canid, value);
        }
        if (!expectedPDOs.isEmpty()) {
            pdata.errCode = 153;
        }
        return pdata;
    }
}

