/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CanOpenDevicePanel
extends JPanel {
    private static final long serialVersionUID = -7222037685600465352L;
    private final String deviceName;
    private final String publishedDataKey;
    private JPanel generalInfoPanel;
    private final JLabel nLabel = new JLabel("Name: ");
    private final JLabel snLabel = new JLabel("Serial number: ");
    private final JLabel nIDhexaLabel = new JLabel("CANopen nodeID (hexa): ");
    private final JLabel nIDdecLabel = new JLabel("CANopen nodeID (decimal): ");
    private final JLabel bLabel = new JLabel("booted: ");
    private final JLabel iLabel = new JLabel("initialized: ");
    private final JLabel nameLabel = new JLabel("Unknown");
    private final JLabel serialLabel = new JLabel("XXXXXXXXX");
    private final JLabel nodeIDhexaLabel = new JLabel("1A");
    private final JLabel nodeIDdecLabel = new JLabel("26");
    private final JLabel bootedLabel = new JLabel("false");
    private final JLabel initLabel = new JLabel("false");

    public CanOpenDevicePanel(String deviceName) {
        this.deviceName = Tools.getShortComponentName(deviceName);
        this.publishedDataKey = deviceName;
        this.initComponents();
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateCanOpenDevice(String deviceToUpdateName, StatusDataPublishedByHardware status) {
        if (this.deviceName.equals(Tools.getShortComponentName(deviceToUpdateName))) {
            SwingUtilities.invokeLater(new UpdateCanOpenDevice(status));
        }
    }

    private void initComponents() {
        this.nameLabel.setText(this.publishedDataKey);
        this.generalInfoPanel = new JPanel();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        this.generalInfoPanel.add((Component)this.nLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.snLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nIDhexaLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nIDdecLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.bLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.iLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        this.generalInfoPanel.add((Component)this.nameLabel, gbc3);
        this.nameLabel.setFont(Tools.BIG_FONT);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.serialLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nodeIDhexaLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.nodeIDdecLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.bootedLabel, gbc3);
        ++gbc3.gridy;
        this.generalInfoPanel.add((Component)this.initLabel, gbc3);
        this.setBorder(BorderFactory.createLineBorder(Color.GREEN));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.generalInfoPanel, gbc);
    }

    public void resetPanel() {
        this.serialLabel.setText("UNKNOWN");
        this.nodeIDdecLabel.setText("0");
        this.nodeIDhexaLabel.setText("0x0");
        this.bootedLabel.setText("false");
        this.initLabel.setText("false");
    }

    @Override
    public String toString() {
        if (this.deviceName == null) {
            return "Unamed CANopen Device Panel";
        }
        int ind = this.deviceName.lastIndexOf("/");
        return ind >= 0 ? this.deviceName.substring(ind + 1) : this.deviceName;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame("CANOpen Device Panel");
        CanOpenDevicePanel p = new CanOpenDevicePanel("My so cude CANopen device");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateCanOpenDevice
    implements Runnable {
        private final StatusDataPublishedByHardware s;

        public UpdateCanOpenDevice(StatusDataPublishedByHardware status) {
            this.s = status;
        }

        @Override
        public void run() {
            CanOpenDevicePanel.this.bootedLabel.setText(Boolean.toString(this.s.isBooted()));
            CanOpenDevicePanel.this.initLabel.setText(Boolean.toString(this.s.isInitialized()));
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map config = this.configInfo.getCurrentValuesFor(CanOpenDevicePanel.this.deviceName);
            CanOpenDevicePanel.this.serialLabel.setText((String)config.get("serialNB"));
            String nodeID = (String)config.get("nodeID");
            CanOpenDevicePanel.this.nodeIDdecLabel.setText(nodeID);
            CanOpenDevicePanel.this.nodeIDhexaLabel.setText("0x" + Integer.toHexString(Integer.parseInt(nodeID)));
        }
    }
}

