/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.PaddingException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsData
extends Data {
    private final Object[][] dataArray;

    public RandomGroupsData() {
        this.dataArray = new Object[0][];
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public RandomGroupsData(Object[][] x) {
        this.dataArray = x;
    }

    @Override
    protected void fillHeader(Header h) throws FitsException {
        if (this.dataArray.length <= 0 || this.dataArray[0].length != 2) {
            throw new FitsException("Data not conformable to Random Groups");
        }
        Standard.context(RandomGroupsData.class);
        Object paraSamp = this.dataArray[0][0];
        Object dataSamp = this.dataArray[0][1];
        Class<?> pbase = ArrayFuncs.getBaseClass(paraSamp);
        Class<?> dbase = ArrayFuncs.getBaseClass(dataSamp);
        if (pbase != dbase) {
            throw new FitsException("Data and parameters do not agree in type for random group");
        }
        int[] pdims = ArrayFuncs.getDimensions(paraSamp);
        int[] ddims = ArrayFuncs.getDimensions(dataSamp);
        if (pdims.length != 1) {
            throw new FitsException("Parameters are not 1 d array for random groups");
        }
        h.setSimple(true);
        if (dbase == Byte.TYPE) {
            h.setBitpix(8);
        } else if (dbase == Short.TYPE) {
            h.setBitpix(16);
        } else if (dbase == Integer.TYPE) {
            h.setBitpix(32);
        } else if (dbase == Long.TYPE) {
            h.setBitpix(64);
        } else if (dbase == Float.TYPE) {
            h.setBitpix(-32);
        } else if (dbase == Double.TYPE) {
            h.setBitpix(-64);
        } else {
            throw new FitsException("Data type:" + dbase + " not supported for random groups");
        }
        h.setNaxes(ddims.length + 1);
        h.addValue(Standard.NAXISn.n(1), 0);
        for (int i = 2; i <= ddims.length + 1; ++i) {
            h.addValue(Standard.NAXISn.n(i), ddims[i - 2]);
        }
        h.addValue((IFitsHeader)Standard.GROUPS, true);
        h.addValue((IFitsHeader)Standard.GCOUNT, this.dataArray.length);
        h.addValue((IFitsHeader)Standard.PCOUNT, pdims[0]);
        Standard.context(null);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public Object getData() {
        return this.dataArray;
    }

    @Override
    protected long getTrueSize() {
        if (this.dataArray != null && this.dataArray.length > 0) {
            return (ArrayFuncs.computeLSize(this.dataArray[0][0]) + ArrayFuncs.computeLSize(this.dataArray[0][1])) * (long)this.dataArray.length;
        }
        return 0L;
    }

    @Override
    public void read(ArrayDataInput str) throws FitsException {
        this.setFileOffset(str);
        try {
            str.readLArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("IO error reading Random Groups data " + e);
        }
        int pad = FitsUtil.padding(this.getTrueSize());
        try {
            str.skipAllBytes(pad);
        }
        catch (EOFException e) {
            throw new PaddingException("EOF reading padding after random groups", this, e);
        }
        catch (IOException e) {
            throw new FitsException("IO error reading padding after random groups", e);
        }
    }

    @Override
    public void write(ArrayDataOutput str) throws FitsException {
        try {
            str.writeArray(this.dataArray);
            FitsUtil.pad(str, this.getTrueSize());
        }
        catch (IOException e) {
            throw new FitsException("IO error writing random groups data " + e);
        }
    }
}

