/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.AuxHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.ThermalConstants;
import org.lsst.ccs.subsystem.refrig.data.ThermalState;

public class AuxHeaterPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final String[] heaterNames = new String[3];
    private static final int switchLabelWidth;
    private static final int switchStateWidth;
    private static final Map<AuxHeaterState, Color> stateColors;
    private static final int horzInset;
    private final int id;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private JLabel switchLabel;
    private JLabel switchStatus;
    private JLabel powerUnitsLabel;
    private ButtonGroup switchBG;
    private JRadioButton switchOffRB;
    private JRadioButton switchOnRB;
    private TextFieldX powerTextField;
    private static final long serialVersionUID = 1L;

    AuxHeaterPanel(int id, CommandSender sender) {
        this.id = id;
        this.sender = sender;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
    }

    public void updatePanel(ThermalState rs) {
        this.switchStatus.setEnabled(true);
        AuxHeaterState pState = rs.getAuxHeaterState(this.id);
        this.switchStatus.setText(pState.name());
        Color color = stateColors.get((Object)pState);
        color = color == null ? UiConstants.PURPLE : color;
        this.switchStatus.setForeground(color);
        boolean isOn = ThermalConstants.auxOnStates.contains((Object)pState);
        JRadioButton selButton = isOn ? this.switchOnRB : this.switchOffRB;
        selButton.setSelected(true);
        this.switchOffRB.setEnabled(isOn);
        this.switchOnRB.setEnabled(pState == AuxHeaterState.OFF);
        this.powerTextField.update((Object)rs.getAuxHeaterPower(this.id), true);
    }

    public void disablePanel() {
        this.switchStatus.setEnabled(false);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.powerTextField.setDisabled();
    }

    private void initComponents() {
        this.switchLabel = UiUtilities.newLabel((String)(heaterNames[this.id] + ":"), (int)switchLabelWidth);
        this.switchStatus = UiUtilities.newLabel((String)"OFF", (int)switchStateWidth);
        this.switchOffRB = this.uiUtils.newRadioButton("Off", "F");
        this.switchOnRB = this.uiUtils.newRadioButton("On", "T");
        this.switchBG = new ButtonGroup();
        this.switchBG.add(this.switchOffRB);
        this.switchBG.add(this.switchOnRB);
        this.powerTextField = this.uiUtils.newTextFieldX("10000.0", "", 2, true);
        this.powerUnitsLabel = UiUtilities.newLabel((String)"W", (int)0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, horzInset, 0, horzInset);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)this.switchLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchStatus, gbc);
        ++gbc.gridx;
        this.add((Component)this.switchOffRB, gbc);
        ++gbc.gridx;
        gbc.insets.right = 0;
        this.add((Component)this.switchOnRB, gbc);
        ++gbc.gridx;
        this.add((Component)this.powerTextField, gbc);
        ++gbc.gridx;
        gbc.insets.right = horzInset;
        this.add((Component)this.powerUnitsLabel, gbc);
    }

    public void handleRadioButton(String name) {
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.sender.sendCommand(null, "setAuxHeaterState", new Object[]{this.id, name.charAt(0) == 'T' ? 1 : 0});
    }

    public void handleTextFieldX(String name, Object value) {
        this.sender.sendCommand(null, "setAuxHeaterPower", new Object[]{this.id, (Double)value});
    }

    static {
        AuxHeaterPanel.heaterNames[0] = "-Y";
        AuxHeaterPanel.heaterNames[1] = "+Y";
        AuxHeaterPanel.heaterNames[2] = "Center";
        switchLabelWidth = UiUtilities.maxLabelWidth((String[])heaterNames, (String)":");
        switchStateWidth = UiUtilities.maxEnumLabelWidth(AuxHeaterState.class);
        stateColors = new HashMap<AuxHeaterState, Color>();
        stateColors.put(AuxHeaterState.OFF, Color.BLACK);
        stateColors.put(AuxHeaterState.ON, UiConstants.GREEN);
        stateColors.put(AuxHeaterState.OFFLINE, UiConstants.BLUE);
        stateColors.put(AuxHeaterState.DISABLD, UiConstants.RED);
        stateColors.put(AuxHeaterState.VOLTERR, UiConstants.PURPLE);
        stateColors.put(AuxHeaterState.NOLOAD, UiConstants.PURPLE);
        horzInset = UiUtilities.getLabelSize((String)"M").width / 2;
    }
}

