/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerConfig;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SequencerRoutines;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Visitable;

@XmlRootElement(name="sequencer")
@XmlType(propOrder={"sequencerConfig", "sequencerRoutines"})
public class Sequencer
implements Visitable {
    private SequencerConfig sequencerConfig = new SequencerConfig();
    private SequencerRoutines sequencerRoutines = new SequencerRoutines();

    @XmlElement(name="sequencer-config")
    public SequencerConfig getSequencerConfig() {
        return this.sequencerConfig;
    }

    public void setSequencerConfig(SequencerConfig sequencerConfig) {
        this.sequencerConfig = sequencerConfig;
    }

    @XmlElement(name="sequencer-routines")
    public SequencerRoutines getSequencerRoutines() {
        return this.sequencerRoutines;
    }

    public void setSequencerRoutines(SequencerRoutines sequencerRoutines) {
        this.sequencerRoutines = sequencerRoutines;
    }

    public void complete() {
        String n;
        for (FunctionPointer functionPointer : this.sequencerConfig.getFuncPtrs()) {
            if (functionPointer.getFunction() != null) continue;
            n = functionPointer.getFcnName();
            if (n == null) {
                throw new RuntimeException("no name for function pointer " + functionPointer.getId());
            }
            Function f = this.sequencerConfig.getFunctions().stream().filter(m -> m.getId().equals(n)).findFirst().orElseThrow(() -> new RuntimeException("cannot find function " + n + " for pointer " + functionPointer.getId()));
            functionPointer.setFunction(f);
        }
        for (SubroutinePointer subroutinePointer : this.sequencerConfig.getSubPtrs()) {
            if (subroutinePointer.getSubroutine() != null) continue;
            n = subroutinePointer.getSubName();
            if (n == null) {
                throw new RuntimeException("no name for function pointer " + subroutinePointer.getId());
            }
            Subroutine s = this.sequencerRoutines.getSubroutines().stream().filter(m -> m.getId().equals(n)).findFirst().orElseThrow(() -> new RuntimeException("cannot find subroutine " + n + " for pointer " + subroutinePointer.getId()));
            subroutinePointer.setSubroutine(s);
        }
        for (Subroutine subroutine : this.sequencerRoutines.getSubroutines()) {
            subroutine.complete(this);
        }
        for (Main main : this.sequencerRoutines.getMains()) {
            main.complete(this);
        }
    }

    public void validate() {
        this.sequencerConfig.validate();
        this.sequencerRoutines.validate();
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public void saveAsXML(File xmlFile) throws IOException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sequencer.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try (FileOutputStream out = new FileOutputStream(xmlFile);){
            m.marshal((Object)this, (OutputStream)out);
        }
    }

    public void saveAsText(File textFile) throws IOException, JAXBException, TransformerException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Sequencer.class});
        try (FileOutputStream out = new FileOutputStream(textFile);){
            JAXBSource source = new JAXBSource(context, (Object)this);
            TransformerFactory tf = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", this.getClass().getClassLoader());
            try (InputStream s = this.getClass().getResourceAsStream("seq.xsl");){
                Transformer t = tf.newTransformer(new StreamSource(s));
                t.transform((Source)source, new StreamResult(out));
            }
        }
    }
}

