/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Monitor;

public class Alarm
implements HasLifecycle {
    public static final int EVENT_TRIP = 0;
    public static final int EVENT_LIMBO = 1;
    public static final int EVENT_LIMBO_FROM_ERROR = 1;
    public static final int EVENT_LIMBO_FROM_GOOD = 2;
    public static final int EVENT_RESET = 3;
    private final Map<Channel, DataProviderState> currentChannelStates = new ConcurrentHashMap<Channel, DataProviderState>();
    private final Map<Channel, DataProviderState> channelStatesToBeProcessed = new ConcurrentHashMap<Channel, DataProviderState>();
    private final Map<Channel, AtomicInteger> consecutiveReadingsBelowCurrentState = new ConcurrentHashMap<Channel, AtomicInteger>();
    private final Map<Channel, String> channelCausesToBeProcessed = new ConcurrentHashMap<Channel, String>();
    protected String description = " ";
    protected int eventParm;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<Monitor.AlarmHandler> alarmHandlers = new ArrayList<Monitor.AlarmHandler>();
    private DataProviderState state = DataProviderState.NOMINAL;
    private DataProviderState oldstate = DataProviderState.NOMINAL;
    private final Object updateStateLock = new Object();
    @LookupName
    protected String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(Channel ch, DataProviderState value, String cause) {
        Object object = this.updateStateLock;
        synchronized (object) {
            DataProviderState currentChannelState = this.currentChannelStates.get(ch);
            AtomicInteger consecutiveReadings = this.consecutiveReadingsBelowCurrentState.computeIfAbsent(ch, k -> new AtomicInteger(0));
            boolean processStateTransition = false;
            if (currentChannelState == null) {
                processStateTransition = true;
                consecutiveReadings.set(0);
            } else if (value.ordinal() > currentChannelState.ordinal()) {
                processStateTransition = true;
                consecutiveReadings.set(0);
            } else if (value.ordinal() < currentChannelState.ordinal()) {
                processStateTransition = consecutiveReadings.incrementAndGet() >= 5;
            } else if (value.ordinal() == currentChannelState.ordinal()) {
                consecutiveReadings.set(0);
            }
            if (processStateTransition) {
                this.channelStatesToBeProcessed.put(ch, value);
                this.channelCausesToBeProcessed.put(ch, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            if (this.channelStatesToBeProcessed.size() > 0) {
                String alarmCause = "";
                for (Channel ch : this.channelStatesToBeProcessed.keySet()) {
                    DataProviderState channelStateToBeProcessed = this.channelStatesToBeProcessed.remove(ch);
                    String channelCauseToBeProcessed = this.channelCausesToBeProcessed.remove(ch);
                    DataProviderState currentChannelState = this.currentChannelStates.get(ch);
                    if (currentChannelState != null && currentChannelState == channelStateToBeProcessed) continue;
                    this.currentChannelStates.put(ch, channelStateToBeProcessed);
                    alarmCause = alarmCause + channelCauseToBeProcessed + "\n";
                }
                DataProviderState newState = DataProviderState.OFF_LINE;
                for (DataProviderState channelState : this.currentChannelStates.values()) {
                    if (channelState.ordinal() <= newState.ordinal()) continue;
                    newState = channelState;
                }
                if (newState != this.state && this.currentChannelStates.size() > 0) {
                    this.oldstate = this.state;
                    this.state = newState;
                    this.processAlarmTrigger(alarmCause);
                }
            }
        }
    }

    void processAlarmTrigger(String alarmCause) {
        block8: {
            DataProviderState newState = this.getAlarmState();
            DataProviderState oldState = this.getAlarmState();
            Integer event = null;
            if (newState == DataProviderState.ALARM) {
                event = 0;
            } else if (oldState == DataProviderState.ALARM) {
                event = newState == DataProviderState.NOMINAL ? 3 : 1;
            } else if (newState == DataProviderState.NOMINAL) {
                event = 3;
            } else if (newState == DataProviderState.WARNING) {
                event = 2;
            }
            if (this.eventParm < 0 || event == null) break block8;
            for (Monitor.AlarmHandler alarmHandler : this.alarmHandlers) {
                if (alarmHandler.processAlarm(event, this.eventParm, alarmCause, this.name)) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        Object object = this.updateStateLock;
        synchronized (object) {
            this.state = DataProviderState.NOMINAL;
            this.currentChannelStates.clear();
        }
    }

    public boolean canClearState() {
        return this.state == DataProviderState.NOMINAL;
    }

    String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    DataProviderState getAlarmState() {
        return this.state;
    }

    DataProviderState getAlarmPreviousState() {
        return this.oldstate;
    }

    int getAlarmId() {
        return this.eventParm;
    }
}

