/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import menus.IncludeInMenu;
import menus.MaxValue;
import menus.MinValue;
import plotter.Axis;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;
import plotter.DiscreteAxisModel;

public class Histogram1DOverlay
extends DataOverlay {
    private DiscreteAxisModel xModel;
    private ContinuousAxisModel yModel;
    private boolean showLinesBetweenPoints = false;
    private boolean showErrorBars = true;
    private boolean showHistogramBars = true;
    private boolean fillHistogramBars = true;
    private boolean showDataPoints = false;
    private float errorBarWidth = 1.0f;
    private Color fillColor = Color.GREEN;
    private Color errorBarColor = Color.BLACK;
    private Color outlineColor = Color.BLACK;
    private int binWidthPercentage = 100;
    private boolean showLabels = false;
    private double[] data;
    private double[] minus;
    private double[] plus;

    Histogram1DOverlay(String title, DiscreteAxisModel x, ContinuousAxisModel y) {
        super(title);
        this.xModel = x;
        this.yModel = y;
    }

    Histogram1DOverlay(String title, double[] data, DiscreteAxisModel x, ContinuousAxisModel y) {
        super(title);
        this.data = data;
        this.xModel = x;
        this.yModel = y;
    }

    void setMinusErrorBars(double[] error) {
        if (error.length != this.data.length) {
            throw new IllegalArgumentException();
        }
        this.minus = error;
    }

    void setData(double[] data) {
        this.data = data;
    }

    void setErrorBars(double[] error) {
        if (error.length != this.data.length) {
            throw new IllegalArgumentException();
        }
        this.minus = error;
        this.plus = error;
    }

    void setPlusErrorBars(double[] error) {
        if (error.length != this.data.length) {
            throw new IllegalArgumentException();
        }
        this.plus = error;
    }

    @Override
    public void paint(Graphics2D g) {
        int i;
        DataArea da = this.getDataArea();
        Axis x = da.getAxisForModel(this.xModel);
        Axis y = da.getAxisForModel(this.yModel);
        GeneralPath poly = new GeneralPath();
        int nBins = this.data.length;
        float y0 = (float)y.getPhysicalCoordinateFromAxisCoordinate(0.0, da);
        float x0 = (float)x.getPhysicalCoordinateFromAxisCoordinate(0.0, da);
        if (this.showHistogramBars) {
            float x2;
            float x1;
            float yNew;
            if (this.binWidthPercentage >= 100) {
                poly.moveTo(x0, y0);
                for (i = 0; i < nBins; ++i) {
                    yNew = (float)y.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(this.data[i]), da);
                    x1 = (float)x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getLowerAxisCoordinateFromBin(i), da);
                    x2 = (float)x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getUpperAxisCoordinateFromBin(i), da);
                    poly.lineTo(x1, Math.min(yNew, y0));
                    poly.lineTo(x2, Math.min(yNew, y0));
                }
                x0 = (float)x.getPhysicalCoordinateFromAxisCoordinate(1.0, da);
                poly.lineTo(x0, y0);
            } else {
                for (i = 0; i < nBins; ++i) {
                    yNew = (float)y.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(this.data[i]), da);
                    x1 = (float)x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getLowerAxisCoordinateFromBin(i), da);
                    x2 = (float)x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getUpperAxisCoordinateFromBin(i), da);
                    float bx1 = x1 + (x2 - x1) * (100.0f - (float)this.binWidthPercentage) / 200.0f;
                    float bx2 = x1 + (x2 - x1) * (100.0f + (float)this.binWidthPercentage) / 200.0f;
                    if (!(yNew < y0)) continue;
                    poly.moveTo(bx1, y0);
                    poly.lineTo(bx1, yNew);
                    poly.lineTo(bx2, yNew);
                    poly.lineTo(bx2, y0);
                }
            }
            g.setStroke(new BasicStroke(1.0f));
            if (this.fillHistogramBars) {
                g.setColor(this.fillColor);
                g.fill(poly);
            }
            g.setColor(this.outlineColor);
            g.draw(poly);
            poly.reset();
            if (this.showLabels) {
                for (i = 0; i < nBins; ++i) {
                    yNew = (float)y.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(this.data[i]), da);
                    x1 = (float)x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getLowerAxisCoordinateFromBin(i), da);
                    x2 = (float)x.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getUpperAxisCoordinateFromBin(i), da);
                    String label = String.valueOf(this.data[i]);
                    FontMetrics fm = g.getFontMetrics();
                    Rectangle2D bounds = fm.getStringBounds(label, g);
                    g.drawString(label, (float)((double)x1 + ((double)(x2 - x1) - bounds.getWidth()) / 2.0), (float)((double)yNew + bounds.getHeight()));
                }
            }
        }
        if (this.showErrorBars && this.plus != null && this.minus != null) {
            for (i = 0; i < nBins; ++i) {
                double xCenter = (this.xModel.getLowerAxisCoordinateFromBin(i) + this.xModel.getUpperAxisCoordinateFromBin(i)) / 2.0;
                float xm = (float)x.getPhysicalCoordinateFromAxisCoordinate(xCenter, da);
                double xe = 3.0;
                double yplus = y.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(this.data[i] + this.plus[i]), da);
                double yminus = y.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(this.data[i] - this.minus[i]), da);
                if (Double.isNaN(yplus) || Double.isNaN(yminus) || yminus == yplus) continue;
                poly.moveTo((double)xm, yplus);
                poly.lineTo((double)xm, Math.min((double)y0, yminus));
                poly.moveTo((double)xm - xe, yplus);
                poly.lineTo((double)xm + xe, yplus);
                poly.moveTo((double)xm - xe, yminus);
                poly.lineTo((double)xm + xe, yminus);
            }
            BasicStroke s = new BasicStroke(this.errorBarWidth, 2, 1);
            g.setStroke(s);
            g.setColor(this.errorBarColor);
            g.draw(poly);
            poly.reset();
        }
    }

    public Color getErrorBarColor() {
        return this.errorBarColor;
    }

    @IncludeInMenu(value="Error Bar Color")
    public void setErrorBarColor(Color errorBarColor) {
        this.errorBarColor = errorBarColor;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    @IncludeInMenu(value="Fill Color")
    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
        this.repaint();
    }

    public boolean isFillHistogramBars() {
        return this.fillHistogramBars;
    }

    @IncludeInMenu(value="Fill Histogram Bars")
    public void setFillHistogramBars(boolean fillHistogramBars) {
        this.fillHistogramBars = fillHistogramBars;
        this.repaint();
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @IncludeInMenu(value="Outline Color")
    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
        this.repaint();
    }

    public int getBinWidthPercentage() {
        return this.binWidthPercentage;
    }

    @IncludeInMenu(value="Histogram Bar Width")
    @MinValue(value=1)
    @MaxValue(value=100)
    public void setBinWidthPercentage(int binWidthPercentage) {
        this.binWidthPercentage = binWidthPercentage;
        this.repaint();
    }

    public boolean isShowErrorBars() {
        return this.showErrorBars;
    }

    @IncludeInMenu(value="Show Error Bars")
    public void setShowErrorBars(boolean showErrorBars) {
        this.showErrorBars = showErrorBars;
        this.repaint();
    }

    public boolean isShowHistogramBars() {
        return this.showHistogramBars;
    }

    @IncludeInMenu(value="Show Histogram Bars")
    public void setShowHistogramBars(boolean showHistogramBars) {
        this.showHistogramBars = showHistogramBars;
        this.repaint();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    @IncludeInMenu(value="Show Bar Labels")
    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.repaint();
    }
}

