/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.gconsole.util.swing.BoxedComboBox;
import org.lsst.ccs.gconsole.util.swing.BoxedSpinner;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

class SelfDestructor
implements AWTEventListener {
    private final String PROP_BEFORE = "org.lsst.ccs.gui.self-destruct.before";
    private final String PROP_AFTER = "org.lsst.ccs.gui.self-destruct.after";
    private int beforeCountdown;
    private int afterCountdown;
    private long lastTouch;
    private PeriodicTask task;
    private JLabel timeLeftLabel;

    SelfDestructor() {
        Console c = Console.getConsole();
        c.addProperty("org.lsst.ccs.gui.self-destruct.before", 176400);
        c.addProperty("org.lsst.ccs.gui.self-destruct.after", 90000);
        c.getConsoleLookup().add((Object)new Pref());
    }

    void restart() {
        ThreadUtil.invokeLater(() -> {
            Console c = Console.getConsole();
            this.beforeCountdown = (Integer)c.getProperty("org.lsst.ccs.gui.self-destruct.before");
            this.afterCountdown = (Integer)c.getProperty("org.lsst.ccs.gui.self-destruct.after");
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            if (this.task != null) {
                this.task.cancel(true);
                this.task = null;
            }
            this.timeLeftLabel = null;
            if (this.beforeCountdown > 0) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
                this.lastTouch = System.currentTimeMillis();
                this.task = Console.getConsole().getScheduler().scheduleAtFixedRate(this::check, 1L, 1L, TimeUnit.MINUTES);
            }
        });
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (this.timeLeftLabel == null) {
            this.lastTouch = System.currentTimeMillis();
        }
    }

    private void killConsole() {
        if (this.task != null) {
            this.task.cancel(true);
        }
        try {
            Console.getConsole().shutdownAgent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startCountdown() {
        if (this.timeLeftLabel != null) {
            return;
        }
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
        boolean kill = true;
        if (this.afterCountdown > 0) {
            this.lastTouch = System.currentTimeMillis();
            this.timeLeftLabel = new JLabel();
            this.updateLabel();
            this.task = Console.getConsole().getScheduler().scheduleAtFixedRate(() -> SwingUtilities.invokeLater(() -> this.updateLabel()), 1L, 1L, TimeUnit.SECONDS);
            Object[] options = new Object[]{"Keep alive", "Shut down"};
            try {
                int n = JOptionPane.showOptionDialog(Console.getConsole().getWindow(), this.timeLeftLabel, "Idle CCS console", 0, -1, null, options, options[0]);
                if (n == 0) {
                    kill = false;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.timeLeftLabel = null;
        }
        if (kill) {
            this.killConsole();
        } else {
            this.restart();
        }
    }

    private void check() {
        SwingUtilities.invokeLater(() -> {
            if (System.currentTimeMillis() - this.lastTouch > (long)this.beforeCountdown * 1000L) {
                this.startCountdown();
            }
        });
    }

    private void updateLabel() {
        if (this.timeLeftLabel == null) {
            return;
        }
        int remainSeconds = this.afterCountdown - (int)((System.currentTimeMillis() - this.lastTouch) / 1000L);
        if (remainSeconds > 0) {
            int minutes;
            StringBuilder sb = new StringBuilder("<html><center>This console will be shut down due to inactivity in<p>");
            int hours = remainSeconds / 3600;
            if (hours > 0) {
                sb.append(hours).append(" hours ");
            }
            if ((minutes = (remainSeconds %= 3600) / 60) > 0) {
                sb.append(minutes).append(" minutes ");
            }
            sb.append(remainSeconds %= 60).append(" seconds.");
            this.timeLeftLabel.setText(sb.toString());
        } else if (remainSeconds > -2) {
            this.timeLeftLabel.setText("Shutting down...");
        } else {
            this.killConsole();
        }
    }

    private static final class PrefGUI
    extends JPanel {
        private final String DAYS = "days";
        private final String HOURS = "hours";
        private final String MINUTES = "minutes";
        private JCheckBox killBox;
        private JCheckBox warnBox;
        private JSpinner killSpinner;
        private JSpinner warnSpinner;
        private JComboBox<String> killCombo;
        private JComboBox<String> warnCombo;
        private JLabel warnLabel;

        PrefGUI() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createTitledBorder("Idle console shutdown"));
            Box line = Box.createHorizontalBox();
            this.add(line);
            line.add(Box.createRigidArea(Const.HDIM));
            this.killBox = new JCheckBox("Shut down if idle for ");
            line.add(this.killBox);
            this.killBox.addActionListener(e -> this.enableComponents());
            this.killSpinner = new BoxedSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            line.add(this.killSpinner);
            line.add(Box.createRigidArea(Const.HDIM));
            this.killCombo = new BoxedComboBox<String>(new String[]{"days", "hours", "minutes"});
            line.add(this.killCombo);
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(Box.createHorizontalGlue());
            line = Box.createHorizontalBox();
            this.add(line);
            line.add(Box.createRigidArea(new Dimension(30, 0)));
            this.warnBox = new JCheckBox("Warn ");
            line.add(this.warnBox);
            this.warnBox.addActionListener(e -> {
                boolean warningEnabled = this.warnBox.isSelected();
                this.warnSpinner.setEnabled(warningEnabled);
                this.warnCombo.setEnabled(warningEnabled);
            });
            this.warnSpinner = new BoxedSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            line.add(this.warnSpinner);
            line.add(Box.createRigidArea(Const.HDIM));
            this.warnCombo = new BoxedComboBox<String>(new String[]{"days", "hours", "minutes"});
            line.add(this.warnCombo);
            this.warnLabel = new JLabel(" before shutdown.");
            line.add(this.warnLabel);
            line.add(Box.createRigidArea(Const.HDIM));
            line.add(Box.createHorizontalGlue());
            this.add(Box.createVerticalGlue());
        }

        void set(int beforeCountdown, int afterCountdown) {
            this.set(beforeCountdown, this.killBox, this.killSpinner, this.killCombo);
            this.set(afterCountdown, this.warnBox, this.warnSpinner, this.warnCombo);
            this.enableComponents();
        }

        int[] get() {
            int beforeCountdown = this.get(this.killBox, this.killSpinner, this.killCombo);
            int afterCountdown = this.get(this.warnBox, this.warnSpinner, this.warnCombo);
            return new int[]{beforeCountdown, afterCountdown};
        }

        private void enableComponents() {
            if (this.killBox.isSelected()) {
                this.killSpinner.setEnabled(true);
                this.killCombo.setEnabled(true);
                this.warnBox.setEnabled(true);
                boolean warningEnabled = this.warnBox.isSelected();
                this.warnSpinner.setEnabled(warningEnabled);
                this.warnCombo.setEnabled(warningEnabled);
                this.warnLabel.setEnabled(true);
            } else {
                this.killSpinner.setEnabled(false);
                this.killCombo.setEnabled(false);
                this.warnBox.setEnabled(false);
                this.warnSpinner.setEnabled(false);
                this.warnCombo.setEnabled(false);
                this.warnLabel.setEnabled(false);
            }
        }

        private void set(int seconds, JCheckBox box, JSpinner spinner, JComboBox combo) {
            boolean enabled = seconds > 0;
            box.setSelected(enabled);
            seconds = Math.abs(seconds);
            if ((seconds /= 60) % 60 == 0) {
                if ((seconds /= 60) % 24 == 0) {
                    seconds /= 24;
                    combo.setSelectedItem("days");
                } else {
                    combo.setSelectedItem("hours");
                }
            } else {
                combo.setSelectedItem("minutes");
            }
            spinner.setValue(seconds);
        }

        int get(JCheckBox box, JSpinner spinner, JComboBox combo) {
            int seconds = (Integer)spinner.getValue();
            String unit = (String)combo.getSelectedItem();
            seconds = "days".equals(unit) ? (seconds *= 86400) : ("hours".equals(unit) ? (seconds *= 3600) : (seconds *= 60));
            if (!box.isSelected()) {
                seconds = -seconds;
            }
            return seconds;
        }
    }

    private class Pref
    implements PreferencesTopic {
        private Pref() {
        }

        public String[] path() {
            return new String[]{"LSST"};
        }

        public JComponent component() {
            PrefGUI panel = new PrefGUI();
            Console c = Console.getConsole();
            int beforeCountdown = (Integer)c.getProperty("org.lsst.ccs.gui.self-destruct.before");
            int afterCountdown = (Integer)c.getProperty("org.lsst.ccs.gui.self-destruct.after");
            panel.set(beforeCountdown, afterCountdown);
            return panel;
        }

        public boolean apply(JComponent jc) {
            try {
                PrefGUI panel = (PrefGUI)jc;
                int[] seconds = panel.get();
                Console c = Console.getConsole();
                c.setProperty("org.lsst.ccs.gui.self-destruct.before", seconds[0]);
                c.setProperty("org.lsst.ccs.gui.self-destruct.after", seconds[1]);
                SelfDestructor.this.restart();
                return true;
            }
            catch (RuntimeException x) {
                return false;
            }
        }
    }
}

