/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonData;
import hep.aida.util.comparison.KolmogorovSmirnovComparisonAlgorithm;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactory;

public class GoodmanComparisonAlgorithm
extends KolmogorovSmirnovComparisonAlgorithm {
    private static final String[] names = new String[]{"Goodman", "KolmogorovSmirnovChi2Approx", "KSChi2Approx"};
    private static final ChiSquaredDistribution chi2Distribution = DistributionFactory.newInstance().createChiSquareDistribution(3.0);

    @Override
    public String[] algorithmNames() {
        return names;
    }

    @Override
    public double quality(IComparisonData d1, IComparisonData d2) {
        double distance = this.evaluateDistance(d1, d2);
        double entries1 = this.entries(d1);
        double entries2 = this.entries(d2);
        double n = entries1 * entries2 / (entries1 + entries2);
        double chi2 = 4.0 * distance * distance * n;
        double prob = Double.NaN;
        try {
            prob = chi2Distribution.cumulativeProbability(chi2);
        }
        catch (MathException me) {
            throw new RuntimeException("Problems evaluating probability ", me);
        }
        return prob;
    }
}

