/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.CornerRaft;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;

public class CCD
extends Geometry<Segment> {
    private CCDType ccdType;
    private final List<Segment> segments = new ArrayList<Segment>();
    private Reb parentReb;

    CCD(CCDType ccdType) {
        this(2, 8, ccdType);
    }

    CCD(int parallelSegmentsCount, int serialSegmentsCount, CCDType ccdType) {
        super("S", new Dimension(ccdType.getCCDGeometryConstants().getPhysicalAreaParallelSize(), ccdType.getCCDGeometryConstants().getPhysicalAreaSerialSize()), parallelSegmentsCount, serialSegmentsCount);
        this.ccdType = ccdType;
    }

    @Override
    protected void addGeometryToGrid(Segment segment, int p, int s) {
        int x = (int)this.ccdType.getCCDGeometryConstants().getParallelEdge() + (this.getParallelChildrenCount() - 1 - p) * segment.getWidth();
        int y = (int)this.ccdType.getCCDGeometryConstants().getSerialEdge() + (this.getSerialChildrenCount() - 1 - s) * segment.getHeight();
        this.addGeometry(segment, x, y);
        this.segments.add(segment);
        Collections.sort(this.segments, (o1, o2) -> o1.getChannel() > o2.getChannel() ? 1 : -1);
    }

    @Override
    public String getUniqueId() {
        return this.parentReb != null ? this.parentReb.getUniqueId() + "." + this.getName() : super.getUniqueId();
    }

    public int getActiveSerialSize() {
        return this.ccdType.getCCDGeometryConstants().getSegmentSerialActiveSize() * this.getSerialChildrenCount();
    }

    public int getActiveParallelSize() {
        return this.ccdType.getCCDGeometryConstants().getSegmentParallelActiveSize() * this.getParallelChildrenCount();
    }

    public CCDType getType() {
        return this.ccdType;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    @Deprecated
    public List<String> getSegmentNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Segment s : this.segments) {
            result.add(s.getName());
        }
        return result;
    }

    public Segment getSegmentByName(String name) {
        String shortName = name.replace("Segment", "Seg");
        for (Segment s : this.segments) {
            if (!s.getName().equals(shortName)) continue;
            return s;
        }
        throw new IllegalArgumentException("Could not find segment " + name + " in CCD: " + this.getName());
    }

    public static CCD createCCD(CCDType ccdType) {
        CCD ccd = new CCD(ccdType);
        for (int s = 0; s < ccd.getSerialChildrenCount(); ++s) {
            for (int p = 0; p < ccd.getParallelChildrenCount(); ++p) {
                int channel = p == 0 ? 16 - s : 1 + s;
                Segment segment = Segment.createCCDSegment(ccdType, channel);
                ccd.addChildGeometry(segment, p, s);
            }
        }
        return ccd;
    }

    void setParentReb(Reb reb) {
        this.parentReb = reb;
    }

    void setCcdType(CCDType type) {
        if (this.getParent() instanceof CornerRaft) {
            throw new RuntimeException("CCD type cannot be changed for a corner raft");
        }
        this.ccdType = type;
    }
}

