/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselDisk;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class CarouselGeneralViewPanel
extends JPanel {
    private static final long serialVersionUID = 3579024322081964467L;
    private static final String NONE = "None";
    private InterfaceCarouselGUI subs;
    private final DecimalFormat formatter = new DecimalFormat("######.000");
    private final JPanel generalInfoPanel = new JPanel();
    private final JLabel profileVelocityLabel = new JLabel();
    private final JLabel profileAccelerationLabel = new JLabel();
    private final JLabel profileDecelerationLabel = new JLabel();
    private final JLabel rotationTimeoutLabel = new JLabel();
    private final JPanel actualParametersPanel = new JPanel();
    private final JLabel homingLabel = new JLabel();
    private final JLabel actualPositionLabel = new JLabel();
    private final JLabel deltaPositionLabel = new JLabel();
    private final JLabel positionSensorTypeLabel = new JLabel();
    private final JLabel actualSpeedLabel = new JLabel();
    private final JLabel actualCurrentLabel = new JLabel();
    private final JLabel standbyLabel = new JLabel();
    private final DigitalSwitch standbySwitch = new DigitalSwitch();
    private final JLabel socketAtStandbyLabel = new JLabel();
    private final JLabel filterAtStandbyLabel = new JLabel();
    private final JPanel controllerPanel = new JPanel();
    private final DigitalSwitch controllerSwitch = new DigitalSwitch();
    private final JLabel enableStatusLabel = new JLabel();
    private final JLabel eposStateLabel = new JLabel();
    private final CarouselDisk carouselDisk = new CarouselDisk();
    private final JPanel controlPanel = new JPanel();
    private final JButton updatePositionButton = new JButton("Update Position");
    private final JButton rotateButton = new JButton("RotateSocketToStandby");
    private final JButton slowModeButton = new JButton("SetSlowMode");
    private final JButton fastModeButton = new JButton("SetFastMode");
    private final JTextField socketNBField = new JTextField(1);
    private final JLabel socketLabel = new JLabel("enter socket nb:");
    private int socketID;
    private final JPanel temperaturesPanel = new JPanel();
    private final JLabel temp1Label = new JLabel();
    private final JLabel temp2Label = new JLabel();
    private final JLabel temp3Label = new JLabel();
    private final JLabel temp4Label = new JLabel();
    private final JPanel sensorsPanel = new JPanel();
    private final JLabel s1Label = new JLabel();
    private final JLabel s2Label = new JLabel();
    private final JLabel s3Label = new JLabel();
    private final JLabel s4Label = new JLabel();
    private final JLabel s5Label = new JLabel();
    private final JLabel s6Label = new JLabel();
    private final JLabel s7Label = new JLabel();
    private final JLabel s8Label = new JLabel();

    public CarouselGeneralViewPanel() {
        this.initComponents();
    }

    protected void setSubsystem(InterfaceCarouselGUI subs) {
        this.subs = subs;
    }

    private void setDefaultValues() {
        this.profileVelocityLabel.setText("0.0");
        this.profileAccelerationLabel.setText("0.0");
        this.profileDecelerationLabel.setText("0.0");
        this.rotationTimeoutLabel.setText("0.0");
        this.homingLabel.setText("NOT DONE");
        this.homingLabel.setForeground(Color.BLUE);
        this.actualPositionLabel.setText("--");
        this.deltaPositionLabel.setText("--");
        this.actualSpeedLabel.setText("0.0");
        this.actualCurrentLabel.setText("0.0");
        this.standbyLabel.setText("NOT AT STANDBY position");
        this.standbySwitch.setColor(Color.gray);
        this.socketAtStandbyLabel.setText(NONE);
        this.filterAtStandbyLabel.setText("NO FILTER");
        this.temp1Label.setText("0.0");
        this.temp2Label.setText("0.0");
        this.temp3Label.setText("0.0");
        this.temp4Label.setText("0.0");
        this.s1Label.setText("0.0");
        this.s2Label.setText("0.0");
        this.s3Label.setText("0.0");
        this.s4Label.setText("0.0");
        this.s5Label.setText("0.0");
        this.s6Label.setText("0.0");
        this.s7Label.setText("0.0");
        this.s8Label.setText("0.0");
        this.controllerSwitch.setColor(Color.gray);
        this.enableStatusLabel.setText("UNKNOWN");
        this.eposStateLabel.setText("UNKNOWN STATE");
    }

    protected void initializeGui(ConfigurationInfo configInfo) {
    }

    protected void update(StatusDataPublishedByCarousel s) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from carousel data:"));
        SwingUtilities.invokeLater(new Update(s));
    }

    protected void update(String filterName, String socketName) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from filter data:"));
        SwingUtilities.invokeLater(new UpdateFilter(filterName, socketName));
    }

    protected void update(StatusDataPublishedByEPOSController s) {
        FCSCst.FCSLOG.debug((Object)(this.getName() + " updating from carousel controller data:"));
        SwingUtilities.invokeLater(new UpdateController(s));
    }

    private void initComponents() {
        this.setName("carouselGeneralViewPanel");
        this.updatePositionButton.addActionListener(evt -> this.updatePositionButtonActionPerformed(evt));
        this.slowModeButton.addActionListener(evt -> this.slowModeButtonActionPerformed(evt));
        this.fastModeButton.addActionListener(evt -> this.fastModeButtonActionPerformed(evt));
        this.rotateButton.addActionListener(evt -> this.rotateButtonActionPerformed(evt));
        this.setDefaultValues();
        this.generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        this.generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.generalInfoPanel.add((Component)new JLabel("ProfileVelocity:"), gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)new JLabel("ProfileAcceleration:"), gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)new JLabel("ProfileDeceleration:"), gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)new JLabel("RotationTimeout:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        this.generalInfoPanel.add((Component)this.profileVelocityLabel, gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)this.profileAccelerationLabel, gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)this.profileDecelerationLabel, gbc);
        ++gbc.gridy;
        this.generalInfoPanel.add((Component)this.rotationTimeoutLabel, gbc);
        this.actualParametersPanel.setBorder(BorderFactory.createLineBorder(Color.yellow));
        this.actualParametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 21;
        this.actualParametersPanel.add((Component)new JLabel("Homing: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Position: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Delta Position: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("P. Sensor Type: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Speed: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Current: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.standbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Socket at STANDBY: "), gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)new JLabel("Filter at STANDBY: "), gbc1);
        ++gbc1.gridx;
        gbc1.gridy = 0;
        gbc1.anchor = 22;
        this.actualParametersPanel.add((Component)this.homingLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.deltaPositionLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.positionSensorTypeLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualSpeedLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.actualCurrentLabel, gbc1);
        ++gbc1.gridy;
        this.standbySwitch.setColor(Color.gray);
        this.actualParametersPanel.add((Component)this.standbySwitch, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.socketAtStandbyLabel, gbc1);
        ++gbc1.gridy;
        this.actualParametersPanel.add((Component)this.filterAtStandbyLabel, gbc1);
        this.controllerPanel.setBorder(BorderFactory.createLineBorder(Color.MAGENTA, 6));
        this.controllerPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 21;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.controllerPanel.add((Component)new JLabel("Controller status :"), gbc);
        ++gbc.gridy;
        gbc.anchor = 10;
        this.controllerSwitch.setSize(40);
        gbc.gridheight = 2;
        this.controllerPanel.add((Component)this.controllerSwitch, gbc);
        gbc.gridheight = 1;
        ++gbc.gridx;
        this.controllerPanel.add((Component)this.enableStatusLabel, gbc);
        ++gbc.gridy;
        this.controllerPanel.add((Component)this.eposStateLabel, gbc);
        this.temperaturesPanel.setBorder(BorderFactory.createTitledBorder("Temperatures (pt100)"));
        this.temperaturesPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.temperaturesPanel.add((Component)new JLabel("Temperature1:"), gbc);
        ++gbc.gridy;
        this.temperaturesPanel.add((Component)new JLabel("Temperature2:"), gbc);
        ++gbc.gridy;
        this.temperaturesPanel.add((Component)new JLabel("Temperature3:"), gbc);
        ++gbc.gridy;
        this.temperaturesPanel.add((Component)new JLabel("Temperature4:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        this.temperaturesPanel.add((Component)this.temp1Label, gbc);
        ++gbc.gridy;
        this.temperaturesPanel.add((Component)this.temp2Label, gbc);
        ++gbc.gridy;
        this.temperaturesPanel.add((Component)this.temp3Label, gbc);
        ++gbc.gridy;
        this.temperaturesPanel.add((Component)this.temp4Label, gbc);
        this.sensorsPanel.setBorder(BorderFactory.createTitledBorder("Sensors (ai814)"));
        this.sensorsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 21;
        this.sensorsPanel.add((Component)new JLabel("Sensor1:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor2:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor3:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor4:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor5:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor6:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor7:"), gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)new JLabel("Sensor8:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.anchor = 22;
        this.sensorsPanel.add((Component)this.s1Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s2Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s3Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s4Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s5Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s6Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s7Label, gbc);
        ++gbc.gridy;
        this.sensorsPanel.add((Component)this.s8Label, gbc);
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.gridwidth = 2;
        this.controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.slowModeButton, gbc4);
        ++gbc4.gridy;
        this.controlPanel.add((Component)this.fastModeButton, gbc4);
        ++gbc4.gridy;
        gbc4.anchor = 13;
        gbc4.gridwidth = 1;
        this.controlPanel.add((Component)this.socketLabel, gbc4);
        ++gbc4.gridx;
        gbc4.anchor = 17;
        gbc4.fill = 0;
        this.controlPanel.add((Component)this.socketNBField, gbc4);
        ++gbc4.gridy;
        gbc4.gridx = 0;
        gbc4.gridwidth = 2;
        gbc4.fill = 2;
        gbc4.anchor = 23;
        this.controlPanel.add((Component)this.rotateButton, gbc4);
        this.setBorder(BorderFactory.createTitledBorder("CAROUSEL GENERAL VIEW"));
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.gridwidth = 2;
        this.add((Component)this.carouselDisk, gbc);
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 2;
        this.add((Component)this.generalInfoPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.actualParametersPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.controllerPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.controlPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.add((Component)this.temperaturesPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.sensorsPanel, gbc);
    }

    private void updatePositionButtonActionPerformed(ActionEvent evt) {
        this.subs.updatePosition();
    }

    private void slowModeButtonActionPerformed(ActionEvent evt) {
        this.subs.setSlowMode();
    }

    private void fastModeButtonActionPerformed(ActionEvent evt) {
        this.subs.setFastMode();
    }

    private void rotateButtonActionPerformed(ActionEvent evt) {
        this.socketID = Integer.parseInt(this.socketNBField.getText());
        this.subs.rotate(this.socketID);
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.carouselDisk.resetPanel();
    }

    @Override
    public String toString() {
        return "Carousel General View";
    }

    public static void main(String[] argv) {
        CarouselGeneralViewPanel d = new CarouselGeneralViewPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class UpdateController
    implements Runnable {
        private final StatusDataPublishedByEPOSController s;

        private UpdateController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (!this.s.isBooted()) {
                CarouselGeneralViewPanel.this.controllerSwitch.setColor(Color.RED);
                CarouselGeneralViewPanel.this.enableStatusLabel.setText("not booted");
                CarouselGeneralViewPanel.this.eposStateLabel.setText("");
            } else if (this.s.isEnabled()) {
                CarouselGeneralViewPanel.this.controllerSwitch.setColor(Tools.greenColor);
                CarouselGeneralViewPanel.this.enableStatusLabel.setText("enable");
            } else {
                CarouselGeneralViewPanel.this.controllerSwitch.setColor(Color.ORANGE);
                CarouselGeneralViewPanel.this.enableStatusLabel.setText("disable");
            }
            if (this.s.isBooted() && this.s.getState() != null) {
                CarouselGeneralViewPanel.this.eposStateLabel.setText(this.s.getState().name());
            }
        }
    }

    public class UpdateFilter
    implements Runnable {
        private final String filterName;
        private final String socketName;

        public UpdateFilter(String filterName, String socketName) {
            this.filterName = filterName;
            this.socketName = socketName;
        }

        @Override
        public void run() {
            CarouselGeneralViewPanel.this.carouselDisk.update(this.filterName, this.socketName);
        }
    }

    public class Update
    implements Runnable {
        private final StatusDataPublishedByCarousel s;

        public Update(StatusDataPublishedByCarousel s) {
            this.s = s;
        }

        @Override
        public void run() {
            String sensorType;
            if (this.s.isHomingDone()) {
                CarouselGeneralViewPanel.this.homingLabel.setText("DONE");
                CarouselGeneralViewPanel.this.homingLabel.setForeground(Tools.greenColor);
            } else {
                CarouselGeneralViewPanel.this.homingLabel.setText("NOT_DONE");
                CarouselGeneralViewPanel.this.homingLabel.setForeground(Color.BLUE);
            }
            CarouselGeneralViewPanel.this.actualPositionLabel.setText(Integer.toString(this.s.getPosition()));
            if (this.s.isAtStandby()) {
                CarouselGeneralViewPanel.this.deltaPositionLabel.setText(Integer.toString(this.s.getDeltaPositionAtStandby()));
            } else {
                CarouselGeneralViewPanel.this.deltaPositionLabel.setText("--");
            }
            switch (this.s.getPositionSensorType()) {
                case 4: {
                    sensorType = "Ssi";
                    break;
                }
                case 8: {
                    sensorType = "Inc";
                    break;
                }
                default: {
                    sensorType = Integer.toString(this.s.getPositionSensorType());
                }
            }
            CarouselGeneralViewPanel.this.positionSensorTypeLabel.setText(sensorType);
            CarouselGeneralViewPanel.this.actualSpeedLabel.setText(Double.toString(this.s.getVelocity()));
            CarouselGeneralViewPanel.this.actualCurrentLabel.setText(Double.toString(this.s.getCurrent()));
            CarouselGeneralViewPanel.this.profileVelocityLabel.setText(Long.toString(this.s.getProfileVelocity()));
            CarouselGeneralViewPanel.this.profileAccelerationLabel.setText(Long.toString(this.s.getProfileAcceleration()));
            CarouselGeneralViewPanel.this.profileDecelerationLabel.setText(Long.toString(this.s.getProfileDeceleration()));
            CarouselGeneralViewPanel.this.rotationTimeoutLabel.setText(Long.toString(this.s.getRotationTimeout()));
            if (this.s.isAtStandby()) {
                CarouselGeneralViewPanel.this.standbyLabel.setText("AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Tools.greenColor);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setFont(Tools.BIG_FONT);
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(this.s.isEmptyAtStandby() ? "NO FILTER" : this.s.getFilterAtStandbyName());
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setFont(Tools.BIG_FONT);
            } else {
                CarouselGeneralViewPanel.this.standbyLabel.setText("NOT AT STANDBY position");
                CarouselGeneralViewPanel.this.standbySwitch.setColor(Color.orange);
                CarouselGeneralViewPanel.this.socketAtStandbyLabel.setText(this.s.getSocketAtStandbyName());
                CarouselGeneralViewPanel.this.filterAtStandbyLabel.setText(CarouselGeneralViewPanel.NONE);
            }
            CarouselGeneralViewPanel.this.carouselDisk.update(this.s);
            CarouselGeneralViewPanel.this.temp1Label.setText(CarouselGeneralViewPanel.this.formatter.format((double)this.s.getTemperature1() / 1000.0));
            CarouselGeneralViewPanel.this.temp2Label.setText(CarouselGeneralViewPanel.this.formatter.format((double)this.s.getTemperature2() / 1000.0));
            CarouselGeneralViewPanel.this.temp3Label.setText(CarouselGeneralViewPanel.this.formatter.format((double)this.s.getTemperature3() / 1000.0));
            CarouselGeneralViewPanel.this.temp4Label.setText(CarouselGeneralViewPanel.this.formatter.format((double)this.s.getTemperature4() / 1000.0));
            CarouselGeneralViewPanel.this.s1Label.setText(Long.toString(this.s.getSensor1()));
            CarouselGeneralViewPanel.this.s2Label.setText(Long.toString(this.s.getSensor2()));
            CarouselGeneralViewPanel.this.s3Label.setText(Long.toString(this.s.getSensor3()));
            CarouselGeneralViewPanel.this.s4Label.setText(Long.toString(this.s.getSensor4()));
            CarouselGeneralViewPanel.this.s5Label.setText(Long.toString(this.s.getSensor5()));
            CarouselGeneralViewPanel.this.s6Label.setText(Long.toString(this.s.getSensor6()));
            CarouselGeneralViewPanel.this.s7Label.setText(Long.toString(this.s.getSensor7()));
            CarouselGeneralViewPanel.this.s8Label.setText(Long.toString(this.s.getSensor8()));
        }
    }
}

