/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

public class EPOSEnumerations {

    public static enum EposState {
        SWITCH_ON_DISABLED,
        READY_TO_SWITCH_ON,
        SWITCHED_ON,
        OPERATION_ENABLE,
        FAULT,
        UNKNOWN_STATE;

    }

    public static enum EposMode {
        HOMING(6, Parameter.HomeOffset, Parameter.QuickStopDeceleration, Parameter.SpeedForSwitchSearch, Parameter.SpeedForZeroSearch, Parameter.HomingAcceleration, Parameter.CurrentThresholdHomingMode, Parameter.HomePosition),
        PROFILE_POSITION(1, Parameter.MaxFollowingError, Parameter.MinPositionLimit, Parameter.MaxPositionLimit, Parameter.MaxProfileVelocity, Parameter.ProfileVelocity, Parameter.ProfileAcceleration, Parameter.ProfileDeceleration, Parameter.QuickStopDeceleration, Parameter.MotionProfileType, Parameter.PositionWindow, Parameter.PositionWindowTime),
        PROFILE_VELOCITY(3, new Parameter[0]),
        POSITION(255, new Parameter[0]),
        MASTER_ENCODER(251, new Parameter[0]),
        VELOCITY(254, new Parameter[0]),
        CURRENT(253, Parameter.ContinuousCurrentLimit, Parameter.OutputCurrentLimit, Parameter.MaxSpeedInCurrentMode, Parameter.PolePairNumber, Parameter.ThermalTimeConstantWinding, Parameter.MotorType, Parameter.PositionSensorType);

        private final int mode;
        private final Parameter[] parameters;

        private EposMode(int mode, Parameter ... params) {
            this.mode = mode;
            this.parameters = (Parameter[])params.clone();
        }

        public int getMode() {
            return this.mode;
        }

        public Parameter[] getParameters() {
            return (Parameter[])this.parameters.clone();
        }

        public static EposMode getMode(int m) {
            EposMode[] modes = EposMode.values();
            EposMode eposMode = null;
            for (EposMode mode : modes) {
                if (mode.getMode() != m) continue;
                eposMode = mode;
            }
            if (eposMode == null) {
                throw new IllegalArgumentException(m + ": this mode doesn't exist in CanOpenEpos.EposMode ENUM");
            }
            return eposMode;
        }

        public static EposMode getModeForParameter(Parameter parameter) {
            EposMode eposMode = null;
            for (EposMode mode : EposMode.values()) {
                for (Parameter param : mode.getParameters()) {
                    if (!param.equals((Object)parameter)) continue;
                    eposMode = mode;
                }
            }
            if (eposMode == null) {
                throw new IllegalArgumentException((Object)((Object)parameter) + ": this EPOS parameter doesn't exist in CanOpenEpos.EposMode ENUM");
            }
            return eposMode;
        }
    }

    public static enum Parameter {
        ConfigurationOfDigitalInput1(8304, 1, 2, false),
        ConfigurationOfDigitalInput2(8304, 2, 2, false),
        ConfigurationOfDigitalInput3(8304, 3, 2, false),
        DigitalInputFonctionnalityState(8305, 1, 2, false),
        DigitalInputFonctionnalityMask(8305, 2, 2, false),
        DigitalInputFonctionnalityPolarity(8305, 3, 2, false),
        DigitalInputFonctionnalityExecutionMask(8305, 4, 2, false),
        DigitalOutputFonctionnalityState(8312, 1, 2, false),
        DigitalOutputFonctionnalityMask(8312, 2, 2, false),
        DigitalOutputFonctionnalityPolarity(8312, 3, 2, false),
        ConfigurationOfDigitalOutput1(8313, 1, 2, false),
        ConfigurationOfDigitalOutput2(8313, 2, 2, false),
        ConfigurationOfDigitalOutput3(8313, 3, 2, false),
        ConfigurationOfDigitalOutput4(8313, 4, 2, false),
        CurrentThresholdHomingMode(8320, 0, 2, false),
        HomePosition(8321, 0, 4, false),
        BrakeReactionRiseTime(8448, 1, 2, false),
        BrakeReactionFallTime(8448, 2, 2, false),
        BrakeTimeout(8448, 3, 2, false),
        PositionSensorType(8720, 2, 2, false),
        SSIEncoderActualPosition(8721, 3, 4, true),
        PositionActualValue(24676, 0, 4, true),
        MaxFollowingError(24677, 0, 4, false),
        PositionWindow(24679, 0, 4, false),
        PositionWindowTime(24680, 0, 2, false),
        HomeOffset(24700, 0, 4, true),
        MinPositionLimit(24701, 1, 4, true),
        MaxPositionLimit(24701, 2, 4, true),
        MaxProfileVelocity(24703, 0, 4, false),
        ProfileVelocity(24705, 0, 4, false),
        ProfileAcceleration(24707, 0, 4, false),
        ProfileDeceleration(24708, 0, 4, false),
        QuickStopDeceleration(24709, 0, 4, false),
        MotionProfileType(24710, 0, 2, false),
        HomingMethod(24728, 0, 1, true),
        SpeedForSwitchSearch(24729, 1, 2, false),
        SpeedForZeroSearch(24729, 2, 2, false),
        HomingAcceleration(24730, 0, 4, false),
        MotorType(25602, 0, 2, false),
        ContinuousCurrentLimit(25616, 1, 2, false),
        OutputCurrentLimit(25616, 2, 2, false),
        PolePairNumber(25616, 3, 1, false),
        MaxSpeedInCurrentMode(25616, 4, 4, false),
        ThermalTimeConstantWinding(25616, 5, 2, false),
        StatusWord(24641, 0, 2, false);

        private final int index;
        private final int subindex;
        private final int size;
        private final boolean signed;

        private Parameter(int index, int subindex, int size, boolean signed) {
            this.index = index;
            this.subindex = subindex;
            this.size = size;
            this.signed = signed;
        }

        public int getIndex() {
            return this.index;
        }

        public int getSubindex() {
            return this.subindex;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isSigned() {
            return this.signed;
        }

        public String display() {
            StringBuilder sb = new StringBuilder(this.toString());
            sb.append("/index=").append(Integer.toHexString(this.index));
            sb.append("/subindex=").append(Integer.toHexString(this.subindex));
            sb.append("/size=").append(this.size).append(" bytes");
            if (this.signed) {
                sb.append("/SIGNED");
            } else {
                sb.append("/UNSIGNED");
            }
            return sb.toString();
        }
    }
}

