/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

public class VacControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final int SWTP_PUMP = 0;
    private static final int SWTP_VALVE = 1;
    private static final String[] switchNames = new String[19];
    private static final int[] switchTypes;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final int SYS_STATE_WIDTH;
    private static final int PLC_STATE_WIDTH;
    private static final int SWITCH_STATE_WIDTH;
    private static final int LATCH_STATE_WIDTH;
    private static final int COND_STATUS_WIDTH;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private int switchMask = 0;
    private int latchMask = 0;
    private int conditionMask = 0;
    private final JPanel headPanel = new JPanel();
    private JLabel sysStateValue;
    private JLabel plcStateValue;
    private TextFieldX periodTextField;
    private JPanel switchPanel;
    private final JLabel[] switchLabel = new JLabel[19];
    private final JLabel[] switchStatus = new JLabel[19];
    private final ButtonGroup[] switchBG = new ButtonGroup[19];
    private final JRadioButton[] switchOffRB = new JRadioButton[19];
    private final JRadioButton[] switchOnRB = new JRadioButton[19];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[8];
    private final JLabel[] latchStatus = new JLabel[8];
    private final JButton[] latchResetBtn = new JButton[8];
    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[10];
    private final JLabel[] conditionStatus = new JLabel[10];
    private static final long serialVersionUID = 1L;

    public VacControlPanel(String subsys) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getVacuumState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
    }

    public void updatePanel(VacSysState vss) {
        SwingUtilities.invokeLater(new UpdateVacState(vss));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int cond;
        this.sysStateValue = UiUtilities.newLabel((String)"X", (int)SYS_STATE_WIDTH);
        this.plcStateValue = UiUtilities.newLabel((String)"X", (int)PLC_STATE_WIDTH);
        this.periodTextField = this.uiUtils.newTextFieldX("00000.0", "U", 2);
        for (int sw = 0; sw < 19; ++sw) {
            this.switchLabel[sw] = UiUtilities.newLabel((String)(switchNames[sw] + ":"), (int)0);
            this.switchStatus[sw] = UiUtilities.newLabel((String)"X", (int)SWITCH_STATE_WIDTH);
            int swType = switchTypes[sw];
            this.switchOffRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "Off" : "Shut", "S" + sw);
            this.switchOnRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "On" : "Open", "O" + sw);
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(this.switchOffRB[sw]);
            bg.add(this.switchOnRB[sw]);
        }
        for (cond = 0; cond < 8; ++cond) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchNames[cond] + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"X", (int)LATCH_STATE_WIDTH);
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", "R" + cond, true);
        }
        for (cond = 0; cond < 10; ++cond) {
            this.conditionLabel[cond] = UiUtilities.newLabel((String)(conditionNames[cond] + ":"), (int)0);
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"X", (int)COND_STATUS_WIDTH);
        }
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        gbh.insets.left = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"System State: ", (int)0), gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.sysStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"PLC State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.plcStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Update Period: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.periodTextField, gbh);
        ++gbh.gridx;
        gbh.insets.right = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"sec", (int)0), gbh);
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Switches");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.gridx = 0;
        gbs.gridy = 0;
        gbs.insets.bottom = -8;
        this.switchPanel.add((Component)new JLabel(" "), gbs);
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.gridx = 0;
        gbl.gridy = 0;
        gbl.insets.bottom = -8;
        this.latchPanel.add((Component)new JLabel(" "), gbl);
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.bottom = -8;
        this.conditionPanel.add((Component)new JLabel(" "), gbc);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.conditionPanel, gbm);
    }

    private void updateSwitchLayout(int switches) {
        for (int sw = 0; sw < 19; ++sw) {
            if ((this.switchMask & 1 << sw) == 0) continue;
            this.switchPanel.remove(this.switchLabel[sw]);
            this.switchPanel.remove(this.switchStatus[sw]);
            this.switchPanel.remove(this.switchOffRB[sw]);
            this.switchPanel.remove(this.switchOnRB[sw]);
        }
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        gbs.gridy = -1;
        int colm = 0;
        for (int sw = 0; sw < 19; ++sw) {
            if ((switches & 1 << sw) == 0) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 4;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            ++gbs.gridx;
            colm = (colm + 1) % 2;
        }
        this.switchMask = switches;
    }

    private void updateLatchLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.latchMask & 1 << cond) == 0) continue;
            this.latchPanel.remove(this.latchLabel[cond]);
            this.latchPanel.remove(this.latchStatus[cond]);
            this.latchPanel.remove(this.latchResetBtn[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < 8; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond], gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbc);
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.latchMask = conditions;
    }

    private void updateConditionLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.conditionMask & 1 << cond) == 0) continue;
            this.conditionPanel.remove(this.conditionLabel[cond]);
            this.conditionPanel.remove(this.conditionStatus[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < 10; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            ++gbc.gridx;
            gbc.insets.left = 4;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.conditionMask = conditions;
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        this.switchOffRB[sw].setEnabled(false);
        this.switchOnRB[sw].setEnabled(false);
        this.sender.sendCommand(null, "setSwitchOn", new Object[]{Switches.getName(sw), type == 'O'});
    }

    public void handleButton(String name) {
        int cond = Integer.valueOf(name.substring(1));
        this.latchResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(null, "clearLatch", new Object[]{cond});
    }

    public void handleTextFieldX(String name, Object value) {
        this.periodTextField.setEnabled(false);
        this.sender.sendCommand("MonitorControl", "setPublishPeriod", new Object[]{(int)(1000.0 * (Double)value)});
    }

    static {
        VacControlPanel.switchNames[0] = "Cryo Turbo Pump";
        VacControlPanel.switchNames[1] = "Cryo Ion Pump 1";
        VacControlPanel.switchNames[2] = "Cryo Ion Pump 2";
        VacControlPanel.switchNames[3] = "Cryo Ion Pump 3";
        VacControlPanel.switchNames[4] = "Cryo Ion Pump 4";
        VacControlPanel.switchNames[5] = "Cryo Ion Pump 5";
        VacControlPanel.switchNames[6] = "Cryo Ion Pump 6";
        VacControlPanel.switchNames[7] = "Cryo Gate Valve";
        VacControlPanel.switchNames[8] = "Cryo Scroll Pump";
        VacControlPanel.switchNames[9] = "Hx Turbo Pump";
        VacControlPanel.switchNames[10] = "Hx Ion Pump 1";
        VacControlPanel.switchNames[11] = "Hx Ion Pump 2";
        VacControlPanel.switchNames[12] = "Hx Gate Valve";
        VacControlPanel.switchNames[13] = "Hx Scroll Pump";
        VacControlPanel.switchNames[14] = "FTPP O-ring Valve";
        VacControlPanel.switchNames[15] = "FTH O-ring Valve";
        VacControlPanel.switchNames[16] = "L3H O-ring Valve";
        VacControlPanel.switchNames[17] = "L3LF O-ring Valve";
        VacControlPanel.switchNames[18] = "Inst Scroll Pump";
        switchTypes = new int[19];
        VacControlPanel.switchTypes[0] = 0;
        VacControlPanel.switchTypes[1] = 0;
        VacControlPanel.switchTypes[2] = 0;
        VacControlPanel.switchTypes[3] = 0;
        VacControlPanel.switchTypes[4] = 0;
        VacControlPanel.switchTypes[5] = 0;
        VacControlPanel.switchTypes[6] = 0;
        VacControlPanel.switchTypes[8] = 0;
        VacControlPanel.switchTypes[7] = 1;
        VacControlPanel.switchTypes[9] = 0;
        VacControlPanel.switchTypes[10] = 0;
        VacControlPanel.switchTypes[11] = 0;
        VacControlPanel.switchTypes[12] = 1;
        VacControlPanel.switchTypes[13] = 0;
        VacControlPanel.switchTypes[14] = 1;
        VacControlPanel.switchTypes[15] = 1;
        VacControlPanel.switchTypes[16] = 1;
        VacControlPanel.switchTypes[17] = 1;
        VacControlPanel.switchTypes[18] = 0;
        latchNames = new String[8];
        VacControlPanel.latchNames[2] = "Cryo Gate Can't Open";
        VacControlPanel.latchNames[1] = "Cryo Gate Forced Shut";
        VacControlPanel.latchNames[0] = "Cryo Vacuum Bad";
        VacControlPanel.latchNames[3] = "Cryo Turbo Pump Bad";
        VacControlPanel.latchNames[6] = "Hx Gate Can't Open";
        VacControlPanel.latchNames[5] = "Hx Gate Forced Shut";
        VacControlPanel.latchNames[4] = "Hx Vacuum Bad";
        VacControlPanel.latchNames[7] = "Hx Turbo Pump Bad";
        conditionNames = new String[10];
        VacControlPanel.conditionNames[0] = "Cryo Foreline OK";
        VacControlPanel.conditionNames[2] = "Cryo Turbo Pr < 10";
        VacControlPanel.conditionNames[1] = "Cryo Turbo Pump Off";
        VacControlPanel.conditionNames[4] = "Cryo Vacuum < 0.001";
        VacControlPanel.conditionNames[3] = "Cryo Vacuum < 0.1";
        VacControlPanel.conditionNames[5] = "HX Foreline OK";
        VacControlPanel.conditionNames[7] = "HX Turbo Pr < 10";
        VacControlPanel.conditionNames[6] = "HX Turbo Pump Off";
        VacControlPanel.conditionNames[9] = "HX Vacuum < 0.001";
        VacControlPanel.conditionNames[8] = "HX Vacuum < 0.1";
        SYS_STATE_WIDTH = UiUtilities.maxLabelWidth((String[])new String[]{"RUNNING", "STOPPED"}, (String)"");
        PLC_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(PLCState.class);
        SWITCH_STATE_WIDTH = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class), UiUtilities.maxEnumLabelWidth(DeviceState.class));
        LATCH_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(LatchState.class);
        COND_STATUS_WIDTH = UiUtilities.maxEnumLabelWidth(ConditionState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            VacControlPanel.this.sysStateValue.setText("STOPPED");
            VacControlPanel.this.sysStateValue.setForeground(UiConstants.RED);
            VacControlPanel.this.plcStateValue.setEnabled(false);
            VacControlPanel.this.periodTextField.setDisabled();
            for (int sw = 0; sw < 19; ++sw) {
                VacControlPanel.this.switchStatus[sw].setEnabled(false);
                VacControlPanel.this.switchOffRB[sw].setEnabled(false);
                VacControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 8; ++cond) {
                VacControlPanel.this.latchStatus[cond].setEnabled(false);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (cond = 0; cond < 10; ++cond) {
                VacControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
        }
    }

    class UpdateVacState
    implements Runnable {
        private final VacSysState vs;

        UpdateVacState(VacSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            Enum state;
            int cond;
            VacControlPanel.this.sysStateValue.setText("RUNNING");
            VacControlPanel.this.sysStateValue.setForeground(UiConstants.GREEN);
            PLCState plcState = this.vs.getPlcState();
            VacControlPanel.this.plcStateValue.setText(plcState.name());
            VacControlPanel.this.plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN : (plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED));
            VacControlPanel.this.plcStateValue.setEnabled(true);
            VacControlPanel.this.periodTextField.update((Object)((double)this.vs.getTickMillis() / 1000.0), true);
            int switches = 0;
            for (int sw = 0; sw < 19; ++sw) {
                Color color;
                switches |= 1 << sw;
                SwitchState state2 = this.vs.getSwitchState(sw);
                String text = state2.name();
                Color color2 = state2 == SwitchState.OFF ? Color.black : (color = state2 == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                if (state2 != SwitchState.OFFLINE) {
                    if (this.vs.getSwitchEnable(sw) == SwitchEnable.OFF) {
                        text = "DISABLD";
                        color = UiConstants.RED;
                    } else {
                        DeviceState devState;
                        if (switchTypes[sw] == 1) {
                            String string = state2 == SwitchState.OFF ? "SHUT" : (text = state2 == SwitchState.ON ? "OPEN" : text);
                        }
                        if ((devState = this.vs.getDeviceState(sw)) != null) {
                            text = devState.name();
                            if (devState == DeviceState.FAILED) {
                                color = UiConstants.RED;
                            }
                        }
                    }
                }
                VacControlPanel.this.switchStatus[sw].setText(text);
                VacControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state2 == SwitchState.ON ? VacControlPanel.this.switchOnRB[sw] : VacControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                VacControlPanel.this.switchStatus[sw].setEnabled(true);
                VacControlPanel.this.switchOffRB[sw].setEnabled(true);
                VacControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            if (switches != VacControlPanel.this.switchMask) {
                VacControlPanel.this.updateSwitchLayout(switches);
            }
            int conditions = 0;
            for (cond = 0; cond < 8; ++cond) {
                conditions |= 1 << cond;
                state = this.vs.getLatch(cond);
                VacControlPanel.this.latchStatus[cond].setText(state.name());
                VacControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                VacControlPanel.this.latchStatus[cond].setEnabled(true);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            if (conditions != VacControlPanel.this.latchMask) {
                VacControlPanel.this.updateLatchLayout(conditions);
            }
            conditions = 0;
            for (cond = 0; cond < 10; ++cond) {
                conditions |= 1 << cond;
                state = this.vs.getCondition(cond);
                VacControlPanel.this.conditionStatus[cond].setText(state.name());
                VacControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                VacControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            if (conditions != VacControlPanel.this.conditionMask) {
                VacControlPanel.this.updateConditionLayout(conditions);
            }
        }
    }
}

