/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui.gantry;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryReplyListener;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.IgnoreLoadCell;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.RaftBay;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.SetOrientation;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.StopAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.WeighRaft;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GantryControls
extends JPanel
implements MotorReplyListener,
GantryReplyListener {
    private final BlockingQueue<Object> commandQueue;
    private boolean xEnabled;
    private boolean yEnabled;
    private JTextField airPressureField;
    private JTextField bayPositionField;
    private JSpinner baySelectionSpinner;
    private JButton clockwiseButton;
    private JButton counterclockwiseButton;
    private JButton disableAllAxesButton;
    private JButton downButton;
    private JButton enableAllAxesButton;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JTextField gantryOrientationField;
    private JCheckBox ignoreLoadCellCheckbox;
    private JCheckBox jCheckBox4;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField loadCellReadingField;
    private JButton minusXButton;
    private JButton minusYButton;
    private JButton moveToBayButton;
    private JButton plusXButton;
    private JButton plusYButton;
    private JTextField raftWeightField;
    private JCheckBox rotationEnableCheckbox;
    private JTextField rotationSpeedField;
    private JTextField rotationStepField;
    private JTextField thetaPositionField;
    private JButton upButton;
    private JButton weighRaftButton;
    private JTextField xPositionField;
    private JCheckBox xyEnableCheckbox;
    private JTextField xySpeedField;
    private JTextField xyStepField;
    private JTextField yPositionField;
    private JCheckBox zEnableCheckbox;
    private JTextField zPositionField;
    private JTextField zSpeedField;
    private JTextField zStepField;

    public GantryControls(BlockingQueue<Object> commandQueue) {
        this.commandQueue = commandQueue;
        this.xEnabled = false;
        this.yEnabled = false;
        this.initComponents();
        ((JSpinner.DefaultEditor)this.baySelectionSpinner.getEditor()).getTextField().setEditable(false);
        this.xyStepField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String text = ((JTextField)input).getText();
                try {
                    double d = Double.valueOf(text);
                    return d > 0.0;
                }
                catch (NumberFormatException exc) {
                    return false;
                }
            }

            @Override
            public boolean shouldYieldFocus(JComponent input) {
                return true;
            }
        });
        this.xySpeedField.setInputVerifier(this.xyStepField.getInputVerifier());
        this.rotationStepField.setInputVerifier(this.xyStepField.getInputVerifier());
        this.rotationSpeedField.setInputVerifier(this.xyStepField.getInputVerifier());
        this.zStepField.setInputVerifier(this.xyStepField.getInputVerifier());
        this.zSpeedField.setInputVerifier(this.xyStepField.getInputVerifier());
    }

    private void queueCommand(Object cmd) {
        if (!this.commandQueue.offer(cmd)) {
            JOptionPane.showMessageDialog(this, "Queue overflow, command lost.", null, 2);
        }
    }

    private void updateMotionToolTip(JButton increaseCoordButton, JButton decreaseCoordButton, double newCoord, JTextField stepField, JCheckBox enableBox) {
        try {
            if (enableBox.isSelected()) {
                double step = Double.valueOf(stepField.getText());
                increaseCoordButton.setToolTipText(String.format("%.3f", newCoord + step));
                decreaseCoordButton.setToolTipText(String.format("%.3f", newCoord - step));
            } else {
                increaseCoordButton.setToolTipText("Disabled");
                decreaseCoordButton.setToolTipText("Disabled");
            }
        }
        catch (NumberFormatException exc) {
            increaseCoordButton.setToolTipText("Bad step");
            decreaseCoordButton.setToolTipText("Bad step");
        }
    }

    @Override
    public void axisStatus(AxisStatus cmd) {
        String axis = cmd.getAxisName();
        String position = String.format("%.3f", cmd.getPosition());
        boolean enabled = cmd.isEnabled();
        if (axis.equals("Z")) {
            this.zPositionField.setText(position);
            this.zEnableCheckbox.setSelected(enabled);
            this.updateMotionToolTip(this.downButton, this.upButton, cmd.getPosition(), this.zStepField, this.zEnableCheckbox);
        } else if (axis.equals("X")) {
            this.xPositionField.setText(position);
            this.xEnabled = enabled;
        } else if (axis.equals("Y")) {
            this.yPositionField.setText(position);
            this.yEnabled = enabled;
        } else if (axis.equals("THETA")) {
            this.thetaPositionField.setText(position);
            this.rotationEnableCheckbox.setSelected(enabled);
            this.updateMotionToolTip(this.counterclockwiseButton, this.clockwiseButton, cmd.getPosition(), this.rotationStepField, this.rotationEnableCheckbox);
        }
        this.xyEnableCheckbox.setSelected(this.xEnabled & this.yEnabled);
        if (axis.equals("X")) {
            this.updateMotionToolTip(this.plusXButton, this.minusXButton, cmd.getPosition(), this.xyStepField, this.xyEnableCheckbox);
        } else if (axis.equals("Y")) {
            this.updateMotionToolTip(this.plusYButton, this.minusYButton, cmd.getPosition(), this.xyStepField, this.xyEnableCheckbox);
        }
    }

    @Override
    public void gantryStatus(GantryStatus cmd) {
        String lc = String.format("%.2f", cmd.getLoadCellReading());
        String air = String.format("%.2f", cmd.getAirPressure());
        String weight = String.format("%.2f", cmd.getRaftWeight());
        this.loadCellReadingField.setText(lc);
        this.airPressureField.setText(air);
        this.ignoreLoadCellCheckbox.setSelected(cmd.loadCellIsIgnored());
        if (cmd.getPressureOK()) {
            this.airPressureField.setBackground(Color.WHITE);
            this.airPressureField.setForeground(Color.BLACK);
        } else {
            this.airPressureField.setBackground(Color.BLACK);
            this.airPressureField.setForeground(Color.YELLOW);
        }
        this.raftWeightField.setText(weight);
        this.gantryOrientationField.setText(cmd.getOrientation().toString());
    }

    private void initComponents() {
        this.jCheckBox4 = new JCheckBox();
        this.baySelectionSpinner = new JSpinner();
        this.moveToBayButton = new JButton();
        this.ignoreLoadCellCheckbox = new JCheckBox();
        this.weighRaftButton = new JButton();
        this.jLabel3 = new JLabel();
        this.raftWeightField = new JTextField();
        this.jLabel4 = new JLabel();
        this.loadCellReadingField = new JTextField();
        this.bayPositionField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.plusXButton = new JButton();
        this.minusXButton = new JButton();
        this.plusYButton = new JButton();
        this.minusYButton = new JButton();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.xyStepField = new JTextField();
        this.jLabel12 = new JLabel();
        this.xySpeedField = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.clockwiseButton = new JButton();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.rotationStepField = new JTextField();
        this.jLabel21 = new JLabel();
        this.counterclockwiseButton = new JButton();
        this.rotationSpeedField = new JTextField();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.downButton = new JButton();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel25 = new JLabel();
        this.zStepField = new JTextField();
        this.jLabel26 = new JLabel();
        this.upButton = new JButton();
        this.zSpeedField = new JTextField();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(100, 20), new Dimension(100, 20), new Dimension(100, 20));
        this.jLabel2 = new JLabel();
        this.xPositionField = new JTextField();
        this.jLabel29 = new JLabel();
        this.yPositionField = new JTextField();
        this.jLabel30 = new JLabel();
        this.jLabel31 = new JLabel();
        this.thetaPositionField = new JTextField();
        this.jLabel32 = new JLabel();
        this.jLabel33 = new JLabel();
        this.zPositionField = new JTextField();
        this.jLabel34 = new JLabel();
        this.jLabel35 = new JLabel();
        this.jLabel36 = new JLabel();
        this.airPressureField = new JTextField();
        this.jLabel37 = new JLabel();
        this.enableAllAxesButton = new JButton();
        this.disableAllAxesButton = new JButton();
        this.xyEnableCheckbox = new JCheckBox();
        this.rotationEnableCheckbox = new JCheckBox();
        this.zEnableCheckbox = new JCheckBox();
        this.filler2 = new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10));
        this.filler3 = new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10));
        this.gantryOrientationField = new JTextField();
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox4, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jCheckBox4.text"));
        this.setMaximumSize(new Dimension(1040, 490));
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.baySelectionSpinner.setModel(new SpinnerListModel((Object[])RaftBay.values()));
        this.baySelectionSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GantryControls.this.baySelectionChanged(evt);
            }
        });
        this.add((Component)this.baySelectionSpinner, new AbsoluteConstraints(299, 22, 100, 40));
        this.moveToBayButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.moveToBayButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.moveToBayButton.text"));
        this.moveToBayButton.setEnabled(false);
        this.add((Component)this.moveToBayButton, new AbsoluteConstraints(521, 27, 170, -1));
        this.ignoreLoadCellCheckbox.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreLoadCellCheckbox, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.ignoreLoadCellCheckbox.text"));
        this.ignoreLoadCellCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.changeLoadCellIgnore(evt);
            }
        });
        this.add((Component)this.ignoreLoadCellCheckbox, new AbsoluteConstraints(647, 104, 360, -1));
        this.weighRaftButton.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.weighRaftButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.weighRaftButton.text"));
        this.weighRaftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.weightRaftRequest(evt);
            }
        });
        this.add((Component)this.weighRaftButton, new AbsoluteConstraints(650, 200, 266, -1));
        this.jLabel3.setFont(new Font("DejaVu LGC Sans", 1, 13));
        this.jLabel3.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel3.text"));
        this.add((Component)this.jLabel3, new AbsoluteConstraints(700, 130, 160, -1));
        this.raftWeightField.setEditable(false);
        this.raftWeightField.setHorizontalAlignment(11);
        this.raftWeightField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.raftWeightField.text"));
        this.add((Component)this.raftWeightField, new AbsoluteConstraints(870, 130, 80, -1));
        this.jLabel4.setFont(new Font("DejaVu LGC Sans", 1, 13));
        this.jLabel4.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel4.text"));
        this.add((Component)this.jLabel4, new AbsoluteConstraints(647, 170, 210, -1));
        this.loadCellReadingField.setEditable(false);
        this.loadCellReadingField.setHorizontalAlignment(11);
        this.loadCellReadingField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.loadCellReadingField.text"));
        this.add((Component)this.loadCellReadingField, new AbsoluteConstraints(870, 170, 80, -1));
        this.bayPositionField.setEditable(false);
        this.bayPositionField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.bayPositionField.text"));
        this.add((Component)this.bayPositionField, new AbsoluteConstraints(433, 28, -1, -1));
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel1.text"));
        this.add((Component)this.jLabel1, new AbsoluteConstraints(0, 0, 240, -1));
        this.jLabel5.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel5.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel5.text"));
        this.add((Component)this.jLabel5, new AbsoluteConstraints(345, 0, 279, -1));
        this.plusXButton.setBackground(this.getBackground());
        this.plusXButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/up-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.plusXButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.plusXButton.text"));
        this.plusXButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.plusXButton, new AbsoluteConstraints(97, 98, 80, 60));
        this.minusXButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/down-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.minusXButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.minusXButton.text"));
        this.minusXButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.minusXButton, new AbsoluteConstraints(100, 250, 80, 60));
        this.plusYButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/left-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.plusYButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.plusYButton.text"));
        this.plusYButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.plusYButton, new AbsoluteConstraints(31, 168, 60, 80));
        this.minusYButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/right-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.minusYButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.minusYButton.text"));
        this.minusYButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.minusYButton, new AbsoluteConstraints(190, 160, 60, 80));
        this.jLabel6.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel6.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel6.text"));
        this.add((Component)this.jLabel6, new AbsoluteConstraints(106, 76, 60, -1));
        this.jLabel7.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel7.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel7.text"));
        this.add((Component)this.jLabel7, new AbsoluteConstraints(107, 317, 60, -1));
        this.jLabel8.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel8.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel8.text"));
        this.add((Component)this.jLabel8, new AbsoluteConstraints(0, 196, 30, -1));
        this.jLabel9.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel9.text"));
        this.add((Component)this.jLabel9, new AbsoluteConstraints(250, 190, 30, -1));
        this.jLabel10.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel10.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel10.text"));
        this.add((Component)this.jLabel10, new AbsoluteConstraints(97, 197, 90, -1));
        this.jLabel11.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel11.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel11.text"));
        this.add((Component)this.jLabel11, new AbsoluteConstraints(0, 344, 85, -1));
        this.xyStepField.setHorizontalAlignment(11);
        this.xyStepField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.xyStepField.text"));
        this.add((Component)this.xyStepField, new AbsoluteConstraints(97, 339, 80, -1));
        this.jLabel12.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel12.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel12.text"));
        this.add((Component)this.jLabel12, new AbsoluteConstraints(0, 377, 85, -1));
        this.xySpeedField.setHorizontalAlignment(11);
        this.xySpeedField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.xySpeedField.text"));
        this.add((Component)this.xySpeedField, new AbsoluteConstraints(97, 372, 80, -1));
        this.jLabel13.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel13.text"));
        this.add((Component)this.jLabel13, new AbsoluteConstraints(189, 344, 50, -1));
        this.jLabel14.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel14.text"));
        this.add((Component)this.jLabel14, new AbsoluteConstraints(189, 377, 70, -1));
        this.clockwiseButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/down-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.clockwiseButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.clockwiseButton.text"));
        this.clockwiseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.clockwiseButton, new AbsoluteConstraints(340, 250, 80, 60));
        this.jLabel15.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel15.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel15.text"));
        this.add((Component)this.jLabel15, new AbsoluteConstraints(288, 76, 170, -1));
        this.jLabel16.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel16.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel16.text"));
        this.add((Component)this.jLabel16, new AbsoluteConstraints(326, 320, 100, -1));
        this.jLabel19.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel19.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel19.text"));
        this.add((Component)this.jLabel19, new AbsoluteConstraints(324, 198, 110, -1));
        this.jLabel20.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel20.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel20.text"));
        this.add((Component)this.jLabel20, new AbsoluteConstraints(272, 344, 50, -1));
        this.rotationStepField.setHorizontalAlignment(11);
        this.rotationStepField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.rotationStepField.text"));
        this.add((Component)this.rotationStepField, new AbsoluteConstraints(334, 339, 80, -1));
        this.jLabel21.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel21.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel21.text"));
        this.add((Component)this.jLabel21, new AbsoluteConstraints(262, 377, 60, -1));
        this.counterclockwiseButton.setBackground(this.getBackground());
        this.counterclockwiseButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/up-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.counterclockwiseButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.counterclockwiseButton.text"));
        this.counterclockwiseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.counterclockwiseButton, new AbsoluteConstraints(340, 100, 80, 60));
        this.rotationSpeedField.setHorizontalAlignment(11);
        this.rotationSpeedField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.rotationSpeedField.text"));
        this.add((Component)this.rotationSpeedField, new AbsoluteConstraints(334, 372, 80, -1));
        this.jLabel22.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel22, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel22.text"));
        this.add((Component)this.jLabel22, new AbsoluteConstraints(422, 344, 50, -1));
        this.jLabel23.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel23, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel23.text"));
        this.add((Component)this.jLabel23, new AbsoluteConstraints(421, 377, 70, -1));
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/down-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.downButton.text"));
        this.downButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.downButton, new AbsoluteConstraints(560, 260, 80, 60));
        this.jLabel17.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel17.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel17.text"));
        this.add((Component)this.jLabel17, new AbsoluteConstraints(560, 80, 80, -1));
        this.jLabel18.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel18.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel18.text"));
        this.add((Component)this.jLabel18, new AbsoluteConstraints(560, 320, 80, -1));
        this.jLabel24.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel24.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel24, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel24.text"));
        this.add((Component)this.jLabel24, new AbsoluteConstraints(555, 197, 90, -1));
        this.jLabel25.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel25.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel25, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel25.text"));
        this.add((Component)this.jLabel25, new AbsoluteConstraints(493, 345, 50, -1));
        this.zStepField.setHorizontalAlignment(11);
        this.zStepField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.zStepField.text"));
        this.add((Component)this.zStepField, new AbsoluteConstraints(555, 340, 80, -1));
        this.jLabel26.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel26.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel26.text"));
        this.add((Component)this.jLabel26, new AbsoluteConstraints(483, 378, 60, -1));
        this.upButton.setBackground(this.getBackground());
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/org/lsst/ccs/subsystem/motorplatform/gui/up-arrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.upButton.text"));
        this.upButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                GantryControls.this.motionButtonPressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                GantryControls.this.motionButtonReleased(evt);
            }
        });
        this.add((Component)this.upButton, new AbsoluteConstraints(560, 100, 80, 60));
        this.zSpeedField.setHorizontalAlignment(11);
        this.zSpeedField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.zSpeedField.text"));
        this.add((Component)this.zSpeedField, new AbsoluteConstraints(555, 373, 80, -1));
        this.jLabel27.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel27.text"));
        this.add((Component)this.jLabel27, new AbsoluteConstraints(647, 345, 50, -1));
        this.jLabel28.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel28, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel28.text"));
        this.add((Component)this.jLabel28, new AbsoluteConstraints(647, 378, 70, -1));
        this.add((Component)this.filler1, new AbsoluteConstraints(0, 56, 480, -1));
        this.jLabel2.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel2.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel2.text"));
        this.add((Component)this.jLabel2, new AbsoluteConstraints(0, 405, 85, 28));
        this.xPositionField.setEditable(false);
        this.xPositionField.setHorizontalAlignment(11);
        this.xPositionField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.xPositionField.text"));
        this.add((Component)this.xPositionField, new AbsoluteConstraints(97, 406, 80, -1));
        this.jLabel29.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel29, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel29.text"));
        this.add((Component)this.jLabel29, new AbsoluteConstraints(189, 411, 50, -1));
        this.yPositionField.setEditable(false);
        this.yPositionField.setHorizontalAlignment(11);
        this.yPositionField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.yPositionField.text"));
        this.add((Component)this.yPositionField, new AbsoluteConstraints(97, 439, 80, -1));
        this.jLabel30.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel30, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel30.text"));
        this.add((Component)this.jLabel30, new AbsoluteConstraints(189, 444, 50, -1));
        this.jLabel31.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel31.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel31, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel31.text"));
        this.add((Component)this.jLabel31, new AbsoluteConstraints(0, 439, 85, 28));
        this.thetaPositionField.setEditable(false);
        this.thetaPositionField.setHorizontalAlignment(11);
        this.thetaPositionField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.thetaPositionField.text"));
        this.add((Component)this.thetaPositionField, new AbsoluteConstraints(334, 406, 80, -1));
        this.jLabel32.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel32, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel32.text"));
        this.add((Component)this.jLabel32, new AbsoluteConstraints(426, 411, 50, -1));
        this.jLabel33.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel33.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel33, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel33.text"));
        this.add((Component)this.jLabel33, new AbsoluteConstraints(262, 405, 60, 28));
        this.zPositionField.setEditable(false);
        this.zPositionField.setHorizontalAlignment(11);
        this.zPositionField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.zPositionField.text"));
        this.add((Component)this.zPositionField, new AbsoluteConstraints(555, 407, 80, -1));
        this.jLabel34.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel34, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel34.text"));
        this.add((Component)this.jLabel34, new AbsoluteConstraints(647, 412, 50, -1));
        this.jLabel35.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel35.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel35, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel35.text"));
        this.add((Component)this.jLabel35, new AbsoluteConstraints(499, 406, 44, 28));
        this.jLabel36.setFont(new Font("DejaVu LGC Sans", 1, 13));
        this.jLabel36.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel36, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel36.text"));
        this.add((Component)this.jLabel36, new AbsoluteConstraints(730, 260, 170, -1));
        this.airPressureField.setEditable(false);
        this.airPressureField.setHorizontalAlignment(11);
        this.airPressureField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.airPressureField.text"));
        this.add((Component)this.airPressureField, new AbsoluteConstraints(910, 260, 70, -1));
        this.jLabel37.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel37, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.jLabel37.text"));
        this.add((Component)this.jLabel37, new AbsoluteConstraints(990, 260, 50, -1));
        this.enableAllAxesButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.enableAllAxesButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.enableAllAxesButton.text"));
        this.enableAllAxesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.enableAllAxes(evt);
            }
        });
        this.add((Component)this.enableAllAxesButton, new AbsoluteConstraints(790, 300, 180, -1));
        this.disableAllAxesButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.disableAllAxesButton, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.disableAllAxesButton.text"));
        this.disableAllAxesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.disableAllAxes(evt);
            }
        });
        this.add((Component)this.disableAllAxesButton, new AbsoluteConstraints(790, 360, 180, -1));
        Mnemonics.setLocalizedText((AbstractButton)this.xyEnableCheckbox, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.xyEnableCheckbox.text"));
        this.xyEnableCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.changeXYEnable(evt);
            }
        });
        this.add((Component)this.xyEnableCheckbox, new AbsoluteConstraints(130, 210, -1, -1));
        Mnemonics.setLocalizedText((AbstractButton)this.rotationEnableCheckbox, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.rotationEnableCheckbox.text"));
        this.rotationEnableCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.changeRotationEnable(evt);
            }
        });
        this.add((Component)this.rotationEnableCheckbox, new AbsoluteConstraints(370, 210, -1, -1));
        Mnemonics.setLocalizedText((AbstractButton)this.zEnableCheckbox, (String)NbBundle.getMessage(GantryControls.class, (String)"GantryControls.zEnableCheckbox.text"));
        this.zEnableCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GantryControls.this.changeZEnable(evt);
            }
        });
        this.add((Component)this.zEnableCheckbox, new AbsoluteConstraints(590, 210, -1, -1));
        this.add((Component)this.filler2, new AbsoluteConstraints(130, 470, -1, -1));
        this.add((Component)this.filler3, new AbsoluteConstraints(130, 470, 20, 20));
        this.gantryOrientationField.setEditable(false);
        this.gantryOrientationField.setHorizontalAlignment(0);
        this.gantryOrientationField.setText(NbBundle.getMessage(GantryControls.class, (String)"GantryControls.gantryOrientationField.text"));
        this.add((Component)this.gantryOrientationField, new AbsoluteConstraints(0, 20, 210, 30));
    }

    private void motionButtonPressed(MouseEvent evt) {
        if (evt.getButton() == 1) {
            String axisName = null;
            Double step = null;
            Double speed = null;
            Double direction = null;
            if (evt.getSource() == this.plusXButton) {
                axisName = "X";
                step = this.getNumber(this.xyStepField);
                direction = 1.0;
                speed = this.getNumber(this.xySpeedField);
            } else if (evt.getSource() == this.minusXButton) {
                axisName = "X";
                step = this.getNumber(this.xyStepField);
                direction = -1.0;
                speed = this.getNumber(this.xySpeedField);
            } else if (evt.getSource() == this.plusYButton) {
                axisName = "Y";
                step = this.getNumber(this.xyStepField);
                direction = 1.0;
                speed = this.getNumber(this.xySpeedField);
            } else if (evt.getSource() == this.minusYButton) {
                axisName = "Y";
                step = this.getNumber(this.xyStepField);
                direction = -1.0;
                speed = this.getNumber(this.xySpeedField);
            } else if (evt.getSource() == this.counterclockwiseButton) {
                axisName = "THETA";
                step = this.getNumber(this.rotationStepField);
                direction = 1.0;
                speed = this.getNumber(this.rotationSpeedField);
            } else if (evt.getSource() == this.clockwiseButton) {
                axisName = "THETA";
                step = this.getNumber(this.rotationStepField);
                direction = -1.0;
                speed = this.getNumber(this.rotationSpeedField);
            } else if (evt.getSource() == this.upButton) {
                axisName = "Z";
                step = this.getNumber(this.zStepField);
                direction = -1.0;
                speed = this.getNumber(this.zSpeedField);
            } else if (evt.getSource() == this.downButton) {
                axisName = "Z";
                step = this.getNumber(this.zStepField);
                direction = 1.0;
                speed = this.getNumber(this.zSpeedField);
            } else {
                throw new RuntimeException("GUI bug: Unrecognized motion buttion");
            }
            if (step != null && speed != null) {
                Duration time = Duration.ofMillis((int)(1000.0 * step / speed));
                this.queueCommand(new MoveAxisRelative(axisName, step * direction, time));
            } else {
                JOptionPane.showMessageDialog(this, "Speeds and steps must be positive real numbers.", "", 2);
            }
        }
    }

    private void motionButtonReleased(MouseEvent evt) {
        String axisName = null;
        if (evt.getButton() == 1) {
            if (evt.getSource() == this.plusXButton) {
                axisName = "X";
            } else if (evt.getSource() == this.minusXButton) {
                axisName = "X";
            } else if (evt.getSource() == this.plusYButton) {
                axisName = "Y";
            } else if (evt.getSource() == this.minusYButton) {
                axisName = "Y";
            } else if (evt.getSource() == this.counterclockwiseButton) {
                axisName = "THETA";
            } else if (evt.getSource() == this.clockwiseButton) {
                axisName = "THETA";
            } else if (evt.getSource() == this.upButton) {
                axisName = "Z";
            } else if (evt.getSource() == this.downButton) {
                axisName = "Z";
            } else {
                throw new RuntimeException("GUI bug: Unrecognized motion buttion");
            }
            this.queueCommand(new StopAxis(axisName));
            if (axisName.equals("Z")) {
                this.ignoreLoadCellCheckbox.setSelected(false);
            }
        }
    }

    private void enableAllAxes(ActionEvent evt) {
        this.queueCommand(new EnableAllAxes());
    }

    private void disableAllAxes(ActionEvent evt) {
        this.queueCommand(new DisableAllAxes());
    }

    private void weightRaftRequest(ActionEvent evt) {
        this.queueCommand(new WeighRaft());
    }

    private void changeXYEnable(ActionEvent evt) {
        boolean enable = this.xyEnableCheckbox.isSelected();
        this.queueCommand(new ChangeAxisEnable("X", enable));
        this.queueCommand(new ChangeAxisEnable("Y", enable));
    }

    private void changeRotationEnable(ActionEvent evt) {
        this.queueCommand(new ChangeAxisEnable("THETA", this.rotationEnableCheckbox.isSelected()));
    }

    private void changeZEnable(ActionEvent evt) {
        this.queueCommand(new ChangeAxisEnable("Z", this.zEnableCheckbox.isSelected()));
    }

    private void changeLoadCellIgnore(ActionEvent evt) {
        this.queueCommand(new IgnoreLoadCell(this.ignoreLoadCellCheckbox.isSelected()));
    }

    private void baySelectionChanged(ChangeEvent evt) {
        RaftBay bay = (RaftBay)((Object)this.baySelectionSpinner.getValue());
        this.queueCommand(new SetOrientation(bay.getOrientation()));
    }

    private Double getNumber(JTextField field) {
        Double result = null;
        if (field.getInputVerifier().verify(field)) {
            result = Double.valueOf(field.getText());
        }
        return result;
    }
}

