/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.loader.ui.InterfaceLoaderGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class LoaderCarrierPanel
extends JPanel {
    private static final long serialVersionUID = 2323057246140272874L;
    private final String carrierName;
    private InterfaceLoaderGUI subs;
    private final DigitalSwitch storageDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch engagedDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel cajLabel = new JLabel("Carrier position");
    private final JLabel actualPositionjLabel = new JLabel("0");
    private final JLabel speedjLabel = new JLabel("0");
    private final JLabel profileVelocityjLabel = new JLabel("0");
    private final JLabel profileAccelerationjLabel = new JLabel("0");
    private final JLabel profileDecelerationjLabel = new JLabel("0");
    private final JLabel currentjLabel = new JLabel("0");
    private final JProgressBar positionProgressBar = new JProgressBar(1, 0, 500);
    private int handoffPosition;
    private final JLabel storagePositionjLabel = new JLabel(Integer.toString(0));
    private final JLabel engagedPositionjLabel = new JLabel(Integer.toString(0));
    private final JLabel handoffPositionjLabel = new JLabel(Integer.toString(0));
    private final JLabel speedMaxjLabel = new JLabel(Integer.toString(0));
    private final JLabel speedLowjLabel = new JLabel(Integer.toString(0));
    private final JLabel speedHighjLabel = new JLabel(Integer.toString(0));
    private final JLabel currentMaxjLabel = new JLabel(Integer.toString(0));
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton slowModeButton = new JButton("SetSlowMode");
    private final JButton fastModeButton = new JButton("SetFastMode");
    private final JButton goToStorageButton = new JButton("goToStorage");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToEngagedButton = new JButton("goToEngaged");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");
    private JPanel controllerPanel;
    private final DigitalSwitch faultSwitch = new DigitalSwitch();

    public LoaderCarrierPanel(String carrierName) {
        this.carrierName = carrierName;
        this.initComponents();
    }

    public void setSubsystem(InterfaceLoaderGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier status) {
        SwingUtilities.invokeLater(new UpdateCarrier(status));
    }

    private void initComponents() {
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsActionPerformed(evt));
        this.updatePositionButton.addActionListener(evt -> this.updatePositionActionPerformed(evt));
        this.slowModeButton.addActionListener(evt -> this.slowModeButtonActionPerformed(evt));
        this.fastModeButton.addActionListener(evt -> this.fastModeButtonActionPerformed(evt));
        this.goToHandoffButton.addActionListener(evt -> this.goToHandoffActionPerformed(evt));
        this.goToEngagedButton.addActionListener(evt -> this.goToEngagedActionPerformed(evt));
        this.goToStorageButton.addActionListener(evt -> this.goToStorageActionPerformed(evt));
        this.quickStopButton.addActionListener(evt -> this.quickStopActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortActionPerformed(evt));
        JPanel paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        paramPanel.add((Component)new JLabel("Actual Position: "), gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)new JLabel("Speed (rpm): "), gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)new JLabel("Current (mA): "), gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)new JLabel("ProfileVelocity: "), gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)new JLabel("ProfileAcceleration: "), gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)new JLabel("ProfileDeceleration: "), gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        gbc2.anchor = 22;
        paramPanel.add((Component)this.actualPositionjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.speedjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.currentjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.profileVelocityjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.profileAccelerationjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.profileDecelerationjLabel, gbc2);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Configurable parameters"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        generalInfoPanel.add((Component)new JLabel("Storage Position: "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Engaged Position: "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Hand-Off Position: "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Speed max (rpm): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Speed low (rpm): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Speed high (rpm): "), gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)new JLabel("Current max (mA): "), gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        generalInfoPanel.add((Component)this.storagePositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.engagedPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.handoffPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedMaxjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedLowjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedHighjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.currentMaxjLabel, gbc3);
        this.controllerPanel = new JPanel();
        this.controllerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.controllerPanel.setLayout(new GridBagLayout());
        this.faultSwitch.setSize(40);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.controllerPanel.add((Component)new JLabel("Controller Status"), gbcf);
        ++gbcf.gridy;
        this.controllerPanel.add((Component)this.faultSwitch, gbcf);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.slowModeButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.fastModeButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToHandoffButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToEngagedButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToStorageButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.abortButton, gbc4);
        this.setBorder(BorderFactory.createTitledBorder("LOADER CARRIER"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 11;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.cajLabel.setFont(Tools.BIG_FONT);
        this.add((Component)this.cajLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 12;
        this.add((Component)new JLabel("Storage"), gbc);
        ++gbc.gridx;
        this.add((Component)this.storageDigitalSwitch, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)new JLabel("In Travel"), gbc);
        ++gbc.gridx;
        this.add((Component)this.inTravelDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)new JLabel("Engaged"), gbc);
        ++gbc.gridx;
        this.add((Component)this.engagedDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)new JLabel("Hand-Off"), gbc);
        ++gbc.gridx;
        this.add((Component)this.handoffDigitalSwitch, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.gridheight = 4;
        gbc.fill = 3;
        this.positionProgressBar.setBorderPainted(true);
        this.positionProgressBar.setBackground(Tools.greenColor);
        this.positionProgressBar.setStringPainted(true);
        this.add((Component)this.positionProgressBar, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridheight = 2;
        this.add((Component)paramPanel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.gridheight = 2;
        this.add((Component)generalInfoPanel, gbc);
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        this.add((Component)this.controllerPanel, gbc);
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.gridheight = 2;
        this.add((Component)controlPanel, gbc);
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.storageDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.engagedDigitalSwitch.setColor(Color.gray);
        this.inErrorDigitalSwitch.setColor(Color.gray);
        this.actualPositionjLabel.setText("0.0");
        this.speedjLabel.setText("0.0");
        this.profileVelocityjLabel.setText("0.0");
        this.profileAccelerationjLabel.setText("0.0");
        this.profileDecelerationjLabel.setText("0.0");
        this.currentjLabel.setText("0.0");
        this.faultSwitch.setColor(Color.GRAY);
    }

    public void resetPanel() {
        this.setDefaultValues();
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(ActionEvent evt) {
        this.subs.loUpdateCarrierPosition();
    }

    private void slowModeButtonActionPerformed(ActionEvent evt) {
        this.subs.setLoSlowMode();
    }

    private void fastModeButtonActionPerformed(ActionEvent evt) {
        this.subs.setLoFastMode();
    }

    private void goToHandoffActionPerformed(ActionEvent evt) {
        this.subs.loGoToHandOff();
    }

    private void goToEngagedActionPerformed(ActionEvent evt) {
        this.subs.loGoToEngaged();
    }

    private void goToStorageActionPerformed(ActionEvent evt) {
        this.subs.loGoToStorage();
    }

    private void quickStopActionPerformed(ActionEvent evt) {
        this.subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    @Override
    public String toString() {
        return "Carrier Panel";
    }

    public static void main(String[] argv) {
        LoaderCarrierPanel d = new LoaderCarrierPanel("my_carrier");
        JFrame frame = new JFrame("Loader Carrier Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class UpdateCarrier
    implements Runnable {
        private final StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier status) {
            this.s = status;
        }

        @Override
        public void run() {
            LoaderCarrierPanel.this.storageDigitalSwitch.setColor(this.s.isAtStorage() ? Tools.greenColor : Color.gray);
            LoaderCarrierPanel.this.handoffDigitalSwitch.setColor(this.s.isAtHandoff() ? Tools.greenColor : Color.gray);
            LoaderCarrierPanel.this.engagedDigitalSwitch.setColor(this.s.isAtEngaged() ? Tools.greenColor : Color.gray);
            LoaderCarrierPanel.this.inTravelDigitalSwitch.setColor(!this.s.isAtHandoff() && !this.s.isAtStorage() && !this.s.isAtEngaged() ? Color.YELLOW : Color.gray);
            LoaderCarrierPanel.this.positionProgressBar.setValue(-this.s.getPosition());
            LoaderCarrierPanel.this.positionProgressBar.setForeground(Color.PINK);
            LoaderCarrierPanel.this.actualPositionjLabel.setText(Integer.toString(this.s.getPosition()));
            LoaderCarrierPanel.this.speedjLabel.setText(Integer.toString(this.s.getSpeed()));
            LoaderCarrierPanel.this.currentjLabel.setText(Integer.toString(this.s.getCurrent()));
            LoaderCarrierPanel.this.profileVelocityjLabel.setText(Long.toString(this.s.getProfileVelocity()));
            LoaderCarrierPanel.this.profileAccelerationjLabel.setText(Long.toString(this.s.getProfileAcceleration()));
            LoaderCarrierPanel.this.profileDecelerationjLabel.setText(Long.toString(this.s.getProfileDeceleration()));
            LoaderCarrierPanel.this.faultSwitch.setColor(this.s.isControllerInError() ? Color.RED : Tools.greenColor);
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForCarrier = this.configInfo.getCurrentValuesFor(LoaderCarrierPanel.this.carrierName);
            LoaderCarrierPanel.this.handoffPosition = Tools.toInt(configForCarrier, "handoffPosition");
            int engagedPosition = Tools.toInt(configForCarrier, "engagedPosition");
            int storagePosition = Tools.toInt(configForCarrier, "storagePosition");
            LoaderCarrierPanel.this.storagePositionjLabel.setText(Integer.toString(storagePosition));
            LoaderCarrierPanel.this.handoffPositionjLabel.setText(Integer.toString(LoaderCarrierPanel.this.handoffPosition));
            LoaderCarrierPanel.this.engagedPositionjLabel.setText(Integer.toString(engagedPosition));
            LoaderCarrierPanel.this.speedMaxjLabel.setText((String)configForCarrier.get("maxSpeed"));
            LoaderCarrierPanel.this.speedLowjLabel.setText((String)configForCarrier.get("lowSpeed"));
            LoaderCarrierPanel.this.speedHighjLabel.setText((String)configForCarrier.get("highSpeed"));
            LoaderCarrierPanel.this.currentMaxjLabel.setText((String)configForCarrier.get("maxCurrent"));
            LoaderCarrierPanel.this.positionProgressBar.setMinimum(-LoaderCarrierPanel.this.handoffPosition);
            LoaderCarrierPanel.this.positionProgressBar.setMaximum(-storagePosition);
            LoaderCarrierPanel.this.positionProgressBar.setValue(0);
            LoaderCarrierPanel.this.faultSwitch.setColor(Color.GRAY);
            LoaderCarrierPanel.this.subs.setLoGoToHandoffTimeout(Tools.toInt(configForCarrier, "timeoutForGoingToHandOff"));
            LoaderCarrierPanel.this.subs.setLoGoToStorageTimeout(Tools.toInt(configForCarrier, "timeoutForGoingToStorage"));
            LoaderCarrierPanel.this.subs.setLoGoToEngagedTimeout(Tools.toInt(configForCarrier, "timeoutForGoingToEngaged"));
        }
    }
}

