/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselSocketPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.FilterListPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.InterfaceCarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.HYTTC580Panel;

public class CarouselGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = -975949078768889254L;
    private final String[] socketNames = new String[]{"socket1", "socket2", "socket3", "socket4", "socket5"};
    private final CarouselGeneralViewPanel caGeneralViewPanel = new CarouselGeneralViewPanel();
    protected final transient Map<String, CarouselSocketPanel> socketPanels = new TreeMap<String, CarouselSocketPanel>();
    protected InterfaceCarouselGUI subs;
    private EPOSControllerPanel clampXminusControllerPanel;
    private EPOSControllerPanel clampXplusControllerPanel;
    private EPOSControllerPanel carouselControllerPanel;
    private HYTTC580Panel hyTTCPanel;
    private CanOpenDevicePanel cancbxai814Panel;
    private CanOpenDevicePanel cancbxpt100Panel;
    private FilterListPanel filterListPanel;

    public CarouselGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
    }

    public CarouselGatherPanel(InterfaceCarouselGUI subs, String tcpProxyName) {
        super(tcpProxyName);
        this.initPanels();
        this.subs = subs;
        this.clampXminusControllerPanel.setSubsystem(subs);
        this.clampXplusControllerPanel.setSubsystem(subs);
        this.carouselControllerPanel.setSubsystem(subs);
        this.caGeneralViewPanel.setSubsystem(subs);
        this.socketPanels.entrySet().stream().forEach(entry -> ((CarouselSocketPanel)entry.getValue()).setSubsystem(subs));
        this.filterListPanel.setSubsystem(subs);
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return this.clampXminusControllerPanel;
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return this.clampXplusControllerPanel;
    }

    public EPOSControllerPanel getCarouselControllerPanel() {
        return this.carouselControllerPanel;
    }

    public HYTTC580Panel getHyTTCPanel() {
        return this.hyTTCPanel;
    }

    public CanOpenDevicePanel getCancbxAI814Panel() {
        return this.cancbxai814Panel;
    }

    public CanOpenDevicePanel getCancbxPT100Panel() {
        return this.cancbxpt100Panel;
    }

    public CarouselGeneralViewPanel getCaGeneralViewPanel() {
        return this.caGeneralViewPanel;
    }

    public FilterListPanel getFilterListPanel() {
        return this.filterListPanel;
    }

    public Map<String, CarouselSocketPanel> getSocketPanels() {
        return this.socketPanels;
    }

    @Override
    public void updateFromStatusData(KeyValueData data) {
        if ("tcpProxy".equals(data.getKey())) {
            this.updateCanOpenHardwarePanel((Integer)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByEPOSController) {
            this.updateControllerPanel(data.getKey(), (StatusDataPublishedByEPOSController)data.getValue());
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByHYTTC580) {
            this.updateHYTTC580Panel(data.getKey(), (StatusDataPublishedByHYTTC580)data.getValue());
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel(data.getKey(), (StatusDataPublishedByHardware)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarouselClamp) {
            this.updateSocketPanels(data.getKey(), (StatusDataPublishedByCarouselClamp)data.getValue());
        } else if (data.getValue() instanceof StatusDataPublishedByCarouselSocket) {
            this.updateSocketPanels(data.getKey(), (StatusDataPublishedByCarouselSocket)data.getValue());
            String filterName = ((StatusDataPublishedByCarouselSocket)data.getValue()).getFilterName();
            String socketName = "socket" + ((StatusDataPublishedByCarouselSocket)data.getValue()).getSocketID();
            this.updateFilterListPanel(filterName, socketName);
            this.caGeneralViewPanel.update(filterName, socketName);
        } else if (data.getValue() instanceof StatusDataPublishedByCarousel) {
            FCSLOG.debug((Object)"STATUS data coming from carousel.");
            this.caGeneralViewPanel.update((StatusDataPublishedByCarousel)data.getValue());
            this.updateSocketPanels((StatusDataPublishedByCarousel)data.getValue());
        }
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    @Override
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) {
        SwingUtilities.invokeLater(new GuiInitializationFilterListPanel(configInfo, filterNamesList));
    }

    @Override
    public void updateCanOpenHardwarePanel(String deviceToUpdate, StatusDataPublishedByHardware status) {
        super.updateCanOpenHardwarePanel(deviceToUpdate, status);
        this.cancbxai814Panel.updateCanOpenDevice(deviceToUpdate, status);
        this.cancbxpt100Panel.updateCanOpenDevice(deviceToUpdate, status);
    }

    public void updateHYTTC580Panel(String deviceToUpdate, StatusDataPublishedByHYTTC580 status) {
        this.hyTTCPanel.updateDevice(deviceToUpdate, status);
    }

    protected void updateControllerPanel(String controllerName, StatusDataPublishedByEPOSController s) {
        switch (controllerName) {
            case "clampXminusController": {
                this.clampXminusControllerPanel.updateController("clampXminusController", s);
                break;
            }
            case "clampXplusController": {
                this.clampXplusControllerPanel.updateController("clampXplusController", s);
                break;
            }
            case "carouselController": {
                this.carouselControllerPanel.updateController("carouselController", s);
                this.caGeneralViewPanel.update(s);
            }
        }
    }

    private void updateFilterListPanel(String filterName, String socketName) {
        this.filterListPanel.updateFilterListPanel(filterName, socketName);
    }

    private void updateSocketPanels(String clampName, StatusDataPublishedByCarouselClamp s) {
        char num = clampName.charAt(clampName.length() - 1);
        String socketName = "socket" + num;
        this.socketPanels.get(socketName).update(clampName, s);
    }

    private void updateSocketPanels(StatusDataPublishedByCarousel s) {
        this.socketPanels.entrySet().stream().forEach(entry -> ((CarouselSocketPanel)entry.getValue()).updateSocketFromCarousel(s));
    }

    private void updateSocketPanels(String socketName, StatusDataPublishedByCarouselSocket s) {
        this.socketPanels.get(socketName).updateSocket(s);
    }

    private void initPanels() {
        this.setName("CarouselGatherPanel");
        this.clampXminusControllerPanel = new EPOSControllerPanel("clampXminusController");
        this.clampXplusControllerPanel = new EPOSControllerPanel("clampXplusController");
        this.carouselControllerPanel = new EPOSControllerPanel("carouselController");
        this.hyTTCPanel = new HYTTC580Panel("hyttc580");
        this.cancbxai814Panel = new CanOpenDevicePanel("ai814");
        this.cancbxpt100Panel = new CanOpenDevicePanel("pt100");
        for (String socketName : this.socketNames) {
            this.socketPanels.put(socketName, new CarouselSocketPanel(socketName));
        }
        this.filterListPanel = new FilterListPanel();
    }

    @Override
    public void resetPanel() {
        super.resetPanel();
        this.filterListPanel.resetPanel();
        this.socketPanels.entrySet().stream().forEach(entry -> ((CarouselSocketPanel)entry.getValue()).resetPanel());
        this.caGeneralViewPanel.resetPanel();
        this.clampXminusControllerPanel.resetPanel();
        this.clampXplusControllerPanel.resetPanel();
        this.carouselControllerPanel.resetPanel();
        this.hyTTCPanel.resetPanel();
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            CarouselGatherPanel.this.clampXminusControllerPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.clampXplusControllerPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.carouselControllerPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.hyTTCPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.cancbxai814Panel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.cancbxpt100Panel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.caGeneralViewPanel.initializeGui(this.configInfo);
            CarouselGatherPanel.this.socketPanels.entrySet().stream().forEach(entry -> ((CarouselSocketPanel)entry.getValue()).initializeGui(this.configInfo));
        }
    }

    private class GuiInitializationFilterListPanel
    implements Runnable {
        private final ConfigurationInfo configInfo;
        private final List<String> filterNamesList;

        public GuiInitializationFilterListPanel(ConfigurationInfo configInfo, List<String> filterNamesList) {
            this.configInfo = configInfo;
            this.filterNamesList = new ArrayList<String>();
            this.filterNamesList.addAll(filterNamesList);
        }

        @Override
        public void run() {
            CarouselGatherPanel.this.filterListPanel.initializeGui(this.configInfo, this.filterNamesList);
        }
    }
}

