/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import java.util.List;
import org.lsst.ccs.drivers.usb.UsbDevice;
import org.lsst.ccs.drivers.usb.UsbEndpoint;
import org.lsst.ccs.drivers.usb.UsbInterfaceDescriptor;

public class UsbInterface {
    private final UsbInterfaceDescriptor desc;
    private final List<UsbInterface> alts;
    private final List<UsbEndpoint> eps;
    private final UsbDevice devc;

    UsbInterface(UsbInterfaceDescriptor desc, List<UsbInterface> alts, List<UsbEndpoint> eps, UsbDevice devc) {
        this.desc = desc;
        this.alts = alts;
        this.eps = eps;
        this.devc = devc;
    }

    public UsbInterfaceDescriptor getDescriptor() {
        return this.desc;
    }

    public String getString() {
        return this.devc.getString(this.desc.iInterface());
    }

    public int getNumSettings() {
        return this.alts.size();
    }

    public List<UsbInterface> getSettings() {
        return this.alts;
    }

    public UsbInterface getSetting(int altNum) {
        for (UsbInterface alt : this.alts) {
            if (altNum != alt.getDescriptor().bAlternateSetting()) continue;
            return alt;
        }
        return null;
    }

    public int getActiveSettingNumber() {
        return this.devc.getAltSetting(this.desc.bInterfaceNumber());
    }

    public UsbInterface getActiveSetting() {
        int altnum = this.devc.getAltSetting(this.desc.bInterfaceNumber());
        for (UsbInterface alt : this.alts) {
            if (alt.desc.bAlternateSetting() != altnum) continue;
            return alt;
        }
        return null;
    }

    public List<UsbEndpoint> getEndpoints() {
        return this.eps;
    }

    public UsbEndpoint getEndpoint(int epAddr) {
        for (UsbEndpoint ep : this.eps) {
            if (epAddr != ep.getDescriptor().bEndpointAddress()) continue;
            return ep;
        }
        return null;
    }
}

