/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WorkerSelectionPanel
extends JPanel
implements ItemListener {
    private static final Logger LOG = Logger.getLogger(WorkerSelectionPanel.class.getName());
    private String target;
    private List<TargetStatusListener> tsListeners;
    private boolean takeItemEvents;
    private final String none;
    private MotorCommandListener sender;
    private State targetState;
    private JLabel available;
    private JComboBox<String> combo;
    private JLabel jLabel1;

    public WorkerSelectionPanel() {
        this.initComponents();
        this.target = null;
        this.tsListeners = null;
        this.targetState = null;
        this.takeItemEvents = false;
        this.none = this.combo.getItemAt(0);
        this.sender = null;
    }

    public void init(List<TargetStatusListener> tsListeners, MotorCommandListener sender) {
        this.tsListeners = new ArrayList<TargetStatusListener>(tsListeners);
        this.targetState = State.NONE_CHOSEN;
        this.enterNoneChosen();
        this.combo.addItemListener(this);
        this.takeItemEvents = true;
        this.sender = sender;
    }

    public String getCurrentTarget() {
        return this.combo.getItemAt(this.combo.getSelectedIndex());
    }

    private void sendTargetStatusEvent(TargetStatusEvent evt) {
        this.tsListeners.stream().forEach(tsl -> tsl.handleTargetStatusEvent(evt));
    }

    public void addSubsystem(String newSubsystem) {
        this.on(newSubsystem);
    }

    public void removeSubsystem(String oldSubsystem) {
        this.off(oldSubsystem);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && this.takeItemEvents) {
            SwingUtilities.invokeLater(() -> this.chosen(this.combo.getItemAt(this.combo.getSelectedIndex())));
        }
    }

    private void on(String name) {
        LOG.log(Level.FINE, "on: old State={0}, name={1}", new Object[]{this.targetState, name});
        this.add(name);
        switch (this.targetState) {
            case NONE_CHOSEN: 
            case CHOSEN: {
                break;
            }
            case CUT_OFF: {
                LOG.log(Level.FINE, "CutOff:on:target={0}, name={1}", new Object[]{this.target, name});
                if (!name.equals(this.target)) break;
                this.sel(name);
                this.targetState = State.CHOSEN;
                this.enterChosen(name);
            }
        }
        LOG.log(Level.FINE, "on: new State={0}", (Object)this.targetState);
    }

    private void off(String name) {
        LOG.log(Level.FINE, "off: old State={0}", (Object)this.targetState);
        this.rem(name);
        switch (this.targetState) {
            case NONE_CHOSEN: 
            case CUT_OFF: {
                break;
            }
            case CHOSEN: {
                if (!name.equals(this.target)) break;
                this.targetState = State.CUT_OFF;
                this.enterCutOff();
            }
        }
        LOG.log(Level.FINE, "off: new State={0}", (Object)this.targetState);
    }

    private void chosen(String name) {
        LOG.log(Level.FINE, "chosen: old State={0}, name={1}", new Object[]{this.targetState, name});
        switch (this.targetState) {
            case NONE_CHOSEN: {
                if (name.equals(this.none)) break;
                this.targetState = State.CHOSEN;
                this.enterChosen(name);
                break;
            }
            case CHOSEN: {
                if (name.equals(this.none)) {
                    this.targetState = State.NONE_CHOSEN;
                    this.enterNoneChosen();
                    break;
                }
                this.target = this.combo.getItemAt(this.combo.getSelectedIndex());
                break;
            }
            case CUT_OFF: {
                if (name.equals(this.none)) {
                    this.targetState = State.NONE_CHOSEN;
                    this.enterNoneChosen();
                    break;
                }
                this.targetState = State.CHOSEN;
                this.enterChosen(name);
            }
        }
        LOG.log(Level.FINE, "chosen: new State={0}, target={1}", new Object[]{this.targetState, this.target});
    }

    private void enterNoneChosen() {
        this.target = null;
        this.sel(this.none);
        this.nocmd();
    }

    private void enterChosen(String name) {
        this.target = name;
        this.cmd();
        this.sender.sendConfiguration(new SendConfiguration());
    }

    private void enterCutOff() {
        this.sel(this.none);
        this.nocmd();
    }

    private void add(String name) {
        this.takeItemEvents = false;
        try {
            this.combo.addItem(name);
        }
        finally {
            this.takeItemEvents = true;
            this.setAvailable();
        }
    }

    private void rem(String name) {
        this.takeItemEvents = false;
        try {
            this.combo.removeItem(name);
        }
        finally {
            this.takeItemEvents = true;
            this.setAvailable();
        }
    }

    private void sel(String name) {
        this.takeItemEvents = false;
        try {
            this.combo.setSelectedItem(name);
        }
        finally {
            this.takeItemEvents = true;
        }
    }

    private void cmd() {
        this.sendTargetStatusEvent(new TargetStatusEvent(false, this.target));
    }

    private void nocmd() {
        this.sendTargetStatusEvent(new TargetStatusEvent(true, this.target));
    }

    private void setAvailable() {
        int n = this.combo.getItemCount() - 1;
        this.available.setText((n == 0 ? "None" : Integer.toString(n)) + " available");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.combo = new JComboBox();
        this.available = new JLabel();
        this.jLabel1.setFont(new Font("DejaVu LGC Sans", 3, 13));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WorkerSelectionPanel.class, (String)"WorkerSelectionPanel.jLabel1.text"));
        this.combo.setModel(new DefaultComboBoxModel<String>(new String[]{"<None selected>"}));
        this.available.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.available, (String)NbBundle.getMessage(WorkerSelectionPanel.class, (String)"WorkerSelectionPanel.available.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.available, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 378, Short.MAX_VALUE).addComponent(this.combo, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.available).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.combo, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private static enum State {
        NONE_CHOSEN,
        CHOSEN,
        CUT_OFF;

    }
}

