/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.time.Duration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MotionPanel
extends JPanel
implements TargetStatusListener {
    private MotorCommandListener sender;
    private boolean takeChangeEvents = false;
    private JComboBox<String> axisChoice;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JButton goButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JFormattedTextField positionField;
    private JCheckBox relativeBox;
    private JFormattedTextField speedField;
    private JFormattedTextField timeField;

    public MotionPanel() {
        this.initComponents();
        this.sender = null;
        this.positionField.setValue(1.0);
        this.timeField.setValue(1.0);
        this.speedField.setValue(1.0);
        this.relativeBox.setSelected(false);
        this.timeField.setEnabled(false);
    }

    public void init(MotorCommandListener sender) {
        this.sender = sender;
        this.takeChangeEvents = true;
    }

    public void configure(PlatformConfig config) {
        String[] axes = new String[config.getAxisNames().size()];
        this.axisChoice.setModel(new DefaultComboBoxModel<String>(config.getAxisNames().toArray(axes)));
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        this.goButton.setEnabled(!evt.disableCommands());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.axisChoice = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.goButton = new JButton();
        this.positionField = new JFormattedTextField();
        this.timeField = new JFormattedTextField();
        this.speedField = new JFormattedTextField();
        this.relativeBox = new JCheckBox();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setFont(new Font("DejaVu LGC Sans", 3, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.jLabel1.text"));
        this.jLabel2.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.jLabel2.text"));
        this.jLabel3.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.jLabel3.text"));
        this.jLabel4.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.jLabel4.text"));
        this.jLabel5.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.jLabel5.text"));
        this.goButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.goButton, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.goButton.text"));
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MotionPanel.this.goButtonActionPerformed(evt);
            }
        });
        this.positionField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.000"))));
        this.positionField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MotionPanel.this.handlePositionChange(evt);
            }
        });
        this.timeField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.000"))));
        this.timeField.setText(NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.timeField.text"));
        this.timeField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MotionPanel.this.handleTimeChange(evt);
            }
        });
        this.speedField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.000"))));
        this.speedField.setText(NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.speedField.text"));
        this.speedField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MotionPanel.this.handleSpeedChange(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.relativeBox, (String)NbBundle.getMessage(MotionPanel.class, (String)"MotionPanel.relativeBox.text"));
        this.relativeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MotionPanel.this.relativeBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 106, -2).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.positionField, -2, 88, -2).addComponent(this.axisChoice, -2, 88, -2).addComponent(this.relativeBox))))).addGroup(layout.createSequentialGroup().addGap(75, 75, 75).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.speedField, -2, 88, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeField, -2, 88, -2))))).addContainerGap(12, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.filler4, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.goButton).addGap(18, 18, 18))).addComponent(this.filler3, -2, 57, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.axisChoice, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.positionField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relativeBox).addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.timeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.speedField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.goButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filler4, -1, -1, Short.MAX_VALUE).addGap(35, 35, 35)).addGroup(layout.createSequentialGroup().addComponent(this.filler3, -2, 45, -2).addGap(0, 0, Short.MAX_VALUE)))));
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        String axis = this.axisChoice.getItemAt(this.axisChoice.getSelectedIndex());
        double position = ((Number)this.positionField.getValue()).doubleValue();
        double time = ((Number)this.timeField.getValue()).doubleValue();
        Duration dur = Duration.ofMillis((long)(time * 1000.0));
        double speed = ((Number)this.speedField.getValue()).doubleValue();
        if (this.relativeBox.isSelected()) {
            this.sender.moveAxisRelative(new MoveAxisRelative(axis, position, dur));
        } else {
            this.sender.moveAxisAbsolute(new MoveAxisAbsolute(axis, position, speed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeChange(PropertyChangeEvent evt) {
        if (this.takeChangeEvents && evt.getPropertyName().equals("value")) {
            double distance = ((Number)this.positionField.getValue()).doubleValue();
            double time = Math.abs(((Number)evt.getNewValue()).doubleValue());
            double speed = Math.abs(distance) / time;
            try {
                this.takeChangeEvents = false;
                this.speedField.setValue(speed);
                this.timeField.setValue(time);
            }
            finally {
                this.takeChangeEvents = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSpeedChange(PropertyChangeEvent evt) {
        if (this.takeChangeEvents && evt.getPropertyName().equals("value")) {
            double distance = ((Number)this.positionField.getValue()).doubleValue();
            double speed = Math.abs(((Number)evt.getNewValue()).doubleValue());
            double time = Math.abs(distance) / speed;
            try {
                this.takeChangeEvents = false;
                this.speedField.setValue(speed);
                if (this.relativeBox.isSelected()) {
                    this.timeField.setValue(time);
                }
            }
            finally {
                this.takeChangeEvents = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePositionChange(PropertyChangeEvent evt) {
        if (this.takeChangeEvents && evt.getPropertyName().equals("value")) {
            double position = ((Number)evt.getNewValue()).doubleValue();
            double speed = ((Number)this.speedField.getValue()).doubleValue();
            double time = Math.abs(position) / speed;
            try {
                this.takeChangeEvents = false;
                this.positionField.setValue(position);
                if (this.relativeBox.isSelected()) {
                    this.timeField.setValue(time);
                }
            }
            finally {
                this.takeChangeEvents = true;
            }
        }
    }

    private void relativeBoxActionPerformed(ActionEvent evt) {
        this.timeField.setEnabled(this.relativeBox.isSelected());
    }
}

