/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.refrig.constants.AuxHeaterState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.refrig.constants.TrimHeaterState;

@SkipEncoding
public class ThermalState
implements Serializable {
    public static final String KEY = "ThermalState";
    public static final int TRIM_HEATER_CRYO = 0;
    public static final int TRIM_HEATER_COLD = 1;
    public static final int TRIM_HEATER_COLD_MYE = 2;
    public static final int TRIM_HEATER_COLD_PYE = 3;
    public static final int TRIM_HEATER_COLD_C = 4;
    public static final int TRIM_HEATER_COLD_MYC = 5;
    public static final int TRIM_HEATER_COLD_PYC = 6;
    public static final int NUM_TRIM_HEATERS = 7;
    public static final int AUX_HEATER_MINUS_Y = 0;
    public static final int AUX_HEATER_PLUS_Y = 1;
    public static final int AUX_HEATER_CENTER = 2;
    public static final int NUM_AUX_HEATERS = 3;
    private int tickMillis;
    private Integer[] trimHeaters = new Integer[0];
    private final TrimHeaterOpState[] trimHeaterOpState = new TrimHeaterOpState[7];
    private final TrimHeaterState[] trimHeaterState = new TrimHeaterState[7];
    private final double[] trimHeaterPower = new double[7];
    private final double[] plateTemperature = new double[7];
    private Integer[] auxHeaters = new Integer[0];
    private final AuxHeaterState[] auxHeaterState = new AuxHeaterState[3];
    private final double[] auxHeaterPower = new double[3];
    private static final long serialVersionUID = 6352997312547508508L;

    public ThermalState() {
        Arrays.fill((Object[])this.trimHeaterOpState, (Object)TrimHeaterOpState.OFF);
        Arrays.fill((Object[])this.trimHeaterState, (Object)TrimHeaterState.OFFLINE);
        Arrays.fill((Object[])this.auxHeaterState, (Object)AuxHeaterState.OFFLINE);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setTrimHeaters(Integer[] value) {
        this.trimHeaters = value;
    }

    public Integer[] getTrimHeaters() {
        return this.trimHeaters;
    }

    public void setTrimHeaterOpState(int heater, TrimHeaterOpState state) {
        this.trimHeaterOpState[heater] = state;
    }

    public TrimHeaterOpState getTrimHeaterOpState(int heater) {
        return this.trimHeaterOpState[heater];
    }

    public void setTrimHeaterState(int heater, TrimHeaterState state) {
        this.trimHeaterState[heater] = state;
    }

    public TrimHeaterState getTrimHeaterState(int heater) {
        return this.trimHeaterState[heater];
    }

    public void setTrimHeaterPower(int heater, double value) {
        this.trimHeaterPower[heater] = value;
    }

    public double getTrimHeaterPower(int heater) {
        return this.trimHeaterPower[heater];
    }

    public void setPlateTemperature(int heater, double value) {
        this.plateTemperature[heater] = value;
    }

    public double getPlateTemperature(int heater) {
        return this.plateTemperature[heater];
    }

    public void setAuxHeaters(Integer[] value) {
        this.auxHeaters = value;
    }

    public Integer[] getAuxHeaters() {
        return this.auxHeaters;
    }

    public void setAuxHeaterState(int heater, AuxHeaterState state) {
        this.auxHeaterState[heater] = state;
    }

    public AuxHeaterState getAuxHeaterState(int heater) {
        return this.auxHeaterState[heater];
    }

    public void setAuxHeaterPower(int heater, double value) {
        this.auxHeaterPower[heater] = value;
    }

    public double getAuxHeaterPower(int heater) {
        return this.auxHeaterPower[heater];
    }
}

