/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.subsystems.fcs.FCSCst;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTruck;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTruckPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.InterfaceAutochangerGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTwoTrucksPanel
extends JPanel {
    private static final long serialVersionUID = 1545510390830387685L;
    private final String trucksName;
    private InterfaceAutochangerGUI subs;
    private final JPanel homingPanel = new JPanel();
    private final JLabel homLabel = new JLabel("Homing of the controllers:");
    private final JLabel homingLabel = new JLabel();
    private final JPanel deltaPositionPanel = new JPanel();
    private final JLabel masterPositionLabel = new JLabel();
    private final JLabel mPosLabel = new JLabel("master position = ");
    private final JLabel slavePositionLabel = new JLabel();
    private final JLabel sPosLabel = new JLabel("slave position = ");
    private final JLabel delLabel = new JLabel("master position - slave position = ");
    private final JLabel deltaPositionLabel = new JLabel();
    private final AutochangerTruckPanel truckXminusPanel;
    private final AutochangerTruckPanel truckXplusPanel;
    private final JLabel stjLabel = new JLabel("Standby Position (in micron): ");
    private final JLabel onjLabel = new JLabel("Online Position (in micron): ");
    private final JLabel hojLabel = new JLabel("Hand-Off Position (in micron): ");
    private final JLabel smjLabel = new JLabel("Speed max (in rpm/mn): ");
    private final JLabel cmjLabel = new JLabel("Current max (in mA): ");
    private final JLabel standbyPositionjLabel = new JLabel();
    private final JLabel handoffPositionjLabel = new JLabel();
    private final JLabel onlinePositionjLabel = new JLabel();
    private final JLabel speedMaxjLabel = new JLabel();
    private final JLabel currentMaxjLabel = new JLabel();
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton alignSlaveButton = new JButton("alignSlave");
    private final JButton goToStandbyButton = new JButton("goToStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");

    public AutochangerTwoTrucksPanel(String trucksName) {
        this.trucksName = trucksName;
        this.truckXminusPanel = new AutochangerTruckPanel("acTruckXminus");
        this.truckXplusPanel = new AutochangerTruckPanel("acTruckXplus");
        this.initComponents();
    }

    public void setSubsystem(InterfaceAutochangerGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(ConfigurationInfo configInfo) {
        SwingUtilities.invokeLater(new GuiInitialization(configInfo));
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
        SwingUtilities.invokeLater(new UpdateTrucks(status));
    }

    public void updateTruck(String truckName, StatusDataPublishedByAutochangerTruck s) {
        if ("acTruckXminus".equals(truckName)) {
            this.truckXminusPanel.updateTruck(s);
        } else if ("acTruckXplus".equals(truckName)) {
            this.truckXplusPanel.updateTruck(s);
        } else {
            FCSCst.FCSLOG.error((Object)(truckName + ": Unknown name for AC truck. Can't update GUI."));
        }
    }

    private void initComponents() {
        this.setDefaultValues();
        this.updateStateWithSensorsButton.addActionListener(this::updateStateWithSensorsActionPerformed);
        this.updatePositionButton.addActionListener(this::updatePositionActionPerformed);
        this.alignSlaveButton.addActionListener(this::alignSlaveActionPerformed);
        this.goToHandoffButton.addActionListener(this::goToHandoffActionPerformed);
        this.goToOnlineButton.addActionListener(this::goToOnlineActionPerformed);
        this.goToStandbyButton.addActionListener(this::goToStandbyActionPerformed);
        this.quickStopButton.addActionListener(this::quickStopActionPerformed);
        this.abortButton.addActionListener(this::abortActionPerformed);
        this.homingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Homing"));
        this.homingPanel.setLayout(new GridBagLayout());
        this.homingLabel.setFont(Tools.BIG_FONT);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_big;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.homingLabel.setFont(Tools.BIG_FONT);
        this.homingPanel.add((Component)this.homLabel, gbc1);
        ++gbc1.gridx;
        this.homingPanel.add((Component)this.homingLabel, gbc1);
        this.deltaPositionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Delta Position"));
        this.deltaPositionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        this.deltaPositionPanel.add((Component)this.mPosLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.sPosLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.delLabel, gbc2);
        gbc2.gridy = 0;
        ++gbc2.gridx;
        gbc2.anchor = 22;
        this.deltaPositionPanel.add((Component)this.masterPositionLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.slavePositionLabel, gbc2);
        ++gbc2.gridy;
        this.deltaPositionPanel.add((Component)this.deltaPositionLabel, gbc2);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER TRUCKS"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 512;
        this.add((Component)this.homingPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.deltaPositionPanel, gbc);
        gbc.anchor = 11;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.truckXminusPanel, gbc);
        ++gbc.gridx;
        this.add((Component)this.truckXplusPanel, gbc);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Configurable parameters"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        generalInfoPanel.add((Component)this.onjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.hojLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.stjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.smjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.cmjLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        generalInfoPanel.add((Component)this.onlinePositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.handoffPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.standbyPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedMaxjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.currentMaxjLabel, gbc3);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)generalInfoPanel, gbc);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.alignSlaveButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToOnlineButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToHandoffButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToStandbyButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.abortButton, gbc4);
        ++gbc.gridx;
        this.add((Component)controlPanel, gbc);
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(ActionEvent evt) {
        this.subs.acUpdateTrucksPosition();
    }

    private void alignSlaveActionPerformed(ActionEvent evt) {
        this.subs.acAlignSlave();
    }

    private void goToHandoffActionPerformed(ActionEvent evt) {
        this.subs.acGoToHandOff();
    }

    private void goToOnlineActionPerformed(ActionEvent evt) {
        this.subs.acGoToOnline();
    }

    private void goToStandbyActionPerformed(ActionEvent evt) {
        this.subs.acGoToStandby();
    }

    private void quickStopActionPerformed(ActionEvent evt) {
        this.subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    private void setDefaultValues() {
        this.standbyPositionjLabel.setText(Integer.toString(0));
        this.handoffPositionjLabel.setText(Double.toString(0.0));
        this.onlinePositionjLabel.setText(Double.toString(0.0));
        this.speedMaxjLabel.setText(Integer.toString(0));
        this.currentMaxjLabel.setText(Integer.toString(0));
        this.homingLabel.setText("NOT DONE");
        this.homingLabel.setForeground(Color.red);
        this.deltaPositionLabel.setText(Integer.toString(0));
        this.masterPositionLabel.setText(Integer.toString(0));
        this.slavePositionLabel.setText(Integer.toString(0));
    }

    public void resetPanel() {
        this.setDefaultValues();
        this.truckXminusPanel.resetPanel();
        this.truckXplusPanel.resetPanel();
    }

    @Override
    public String toString() {
        return "Trucks";
    }

    public static void main(String[] argv) {
        AutochangerTwoTrucksPanel d = new AutochangerTwoTrucksPanel("autochangerTrucks");
        JFrame frame = new JFrame("Autochanger Trucks Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateTrucks
    implements Runnable {
        private final StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isHomingDone()) {
                AutochangerTwoTrucksPanel.this.homingLabel.setText("DONE");
                AutochangerTwoTrucksPanel.this.homingLabel.setForeground(Color.green);
            } else {
                AutochangerTwoTrucksPanel.this.homingLabel.setText("NOT DONE");
                AutochangerTwoTrucksPanel.this.homingLabel.setForeground(Color.red);
            }
            AutochangerTwoTrucksPanel.this.masterPositionLabel.setText(Integer.toString(this.s.getMasterPosition()));
            AutochangerTwoTrucksPanel.this.slavePositionLabel.setText(Integer.toString(this.s.getSlavePosition()));
            AutochangerTwoTrucksPanel.this.deltaPositionLabel.setText(Integer.toString(this.s.getMasterPosition() - this.s.getSlavePosition()));
        }
    }

    private class GuiInitialization
    implements Runnable {
        private final ConfigurationInfo configInfo;

        public GuiInitialization(ConfigurationInfo configInfo) {
            this.configInfo = configInfo;
        }

        @Override
        public void run() {
            Map configForName = this.configInfo.getCurrentValuesFor(AutochangerTwoTrucksPanel.this.trucksName);
            FCSCst.FCSLOG.fine((Object)(AutochangerTwoTrucksPanel.this.trucksName + " configForName=" + configForName));
            AutochangerTwoTrucksPanel.this.subs.setTimeoutForTrucksMotion(Long.parseLong((String)configForName.get("timeoutForTrucksMotion")));
            int standbyPosition = Integer.parseInt((String)configForName.get("standbyPosition"));
            int handoffPosition = Integer.parseInt((String)configForName.get("handoffPosition"));
            int onlinePosition = Integer.parseInt((String)configForName.get("onlinePosition"));
            AutochangerTwoTrucksPanel.this.standbyPositionjLabel.setText(Integer.toString(standbyPosition));
            AutochangerTwoTrucksPanel.this.handoffPositionjLabel.setText(Integer.toString(handoffPosition));
            AutochangerTwoTrucksPanel.this.onlinePositionjLabel.setText(Integer.toString(onlinePosition));
            AutochangerTwoTrucksPanel.this.speedMaxjLabel.setText((String)configForName.get("maxSpeed"));
            AutochangerTwoTrucksPanel.this.currentMaxjLabel.setText((String)configForName.get("maxCurrent"));
            AutochangerTwoTrucksPanel.this.truckXminusPanel.initializeGui(standbyPosition, onlinePosition);
            AutochangerTwoTrucksPanel.this.truckXplusPanel.initializeGui(standbyPosition, onlinePosition);
        }
    }
}

