/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import plotter.Axis;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;

public class SinOverlay
extends DataOverlay {
    private Axis xAxis;
    private Axis yAxis;

    SinOverlay(String title, Axis x, Axis y) {
        super(title);
        this.xAxis = x;
        this.yAxis = y;
    }

    @Override
    public void paint(Graphics2D g) {
        DataArea da = this.getDataArea();
        ContinuousAxisModel xModel = (ContinuousAxisModel)this.xAxis.getModel();
        ContinuousAxisModel yModel = (ContinuousAxisModel)this.yAxis.getModel();
        GeneralPath poly = new GeneralPath();
        g.setColor(Color.BLUE);
        double xMin = xModel.getModelCoordinateFromAxisCoordinate(0.0);
        double xMax = yModel.getModelCoordinateFromAxisCoordinate(1.0);
        int nPoints = 100;
        double delta = 1.0 / (double)nPoints;
        boolean firstPoint = true;
        for (double x = 0.0; x < 1.0; x += delta) {
            double y = yModel.getAxisCoordinateFromModelCoordinate(Math.sin(xModel.getModelCoordinateFromAxisCoordinate(x)));
            float xPhys = (float)this.xAxis.getPhysicalCoordinateFromAxisCoordinate(x, da);
            float yPhys = (float)this.yAxis.getPhysicalCoordinateFromAxisCoordinate(y, da);
            if (firstPoint) {
                poly.moveTo(xPhys, yPhys);
                firstPoint = false;
                continue;
            }
            poly.lineTo(xPhys, yPhys);
        }
        g.setColor(Color.BLUE);
        g.setStroke(new BasicStroke(5.0f));
        g.draw(poly);
    }
}

