/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.constants.UTTestFans;
import org.lsst.ccs.subsystem.utility.constants.UTTestSwitches;
import org.lsst.ccs.subsystem.utility.constants.UTTestValves;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.data.UTTestState;

public class UTTestControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final Map<Integer, String> switchNames = new LinkedHashMap<Integer, String>();
    private static final int switchStateWidth;
    private static final int fanStateWidth;
    private static final int valveStateWidth;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel statusPanel;
    private JPanel switchPanel;
    private JPanel utPanel;
    private final JLabel[] switchLabel = new JLabel[5];
    private final JLabel[] switchState = new JLabel[5];
    private final ButtonGroup[] switchBG = new ButtonGroup[5];
    private final JRadioButton[] switchOffRB = new JRadioButton[5];
    private final JRadioButton[] switchOnRB = new JRadioButton[5];
    private final JLabel[] fanState = new JLabel[1];
    private final ButtonGroup[] fanBG = new ButtonGroup[1];
    private final JRadioButton[] fanOffRB = new JRadioButton[1];
    private final JRadioButton[] fanSpeedRB = new JRadioButton[1];
    private final TextFieldX[] fanSpeedTF = new TextFieldX[1];
    private final JRadioButton[] fanTempRB = new JRadioButton[1];
    private final TextFieldX[] fanTempTF = new TextFieldX[1];
    private final JLabel[] valveState = new JLabel[1];
    private final ButtonGroup[] valveBG = new ButtonGroup[1];
    private final JRadioButton[] valveShutRB = new JRadioButton[1];
    private final JRadioButton[] valveOpenRB = new JRadioButton[1];
    private final TextFieldX[] valvePosnTF = new TextFieldX[1];
    private final Map<Integer, Integer> switchLines = new HashMap<Integer, Integer>();
    private static final long serialVersionUID = 1L;

    public UTTestControlPanel(String subsys) {
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getFullState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((UTTestState)reply);
    }

    public void updatePanel(UTTestState rs) {
        SwingUtilities.invokeLater(new UpdatePurgeState(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        int line = 0;
        for (int swId : switchNames.keySet()) {
            this.switchLines.put(swId, line);
            this.switchLabel[line] = UiUtilities.newLabel((String)(switchNames.get(swId) + ":"), (int)0);
            this.switchState[line] = UiUtilities.newLabel((String)"XXX", (int)switchStateWidth);
            this.switchOnRB[line] = this.uiUtils.newRadioButton("On", "ST" + swId);
            this.switchOffRB[line] = this.uiUtils.newRadioButton("Off", "SF" + swId);
            ButtonGroup bg = this.switchBG[line] = new ButtonGroup();
            bg.add(this.switchOnRB[line]);
            bg.add(this.switchOffRB[line]);
            ++line;
        }
        for (int fanId = 0; fanId < 1; ++fanId) {
            this.fanState[fanId] = UiUtilities.newLabel((String)"XXX", (int)fanStateWidth);
            this.fanOffRB[fanId] = this.uiUtils.newRadioButton("Off", "FF" + fanId);
            this.fanSpeedRB[fanId] = this.uiUtils.newRadioButton("Speed", "FS" + fanId);
            this.fanTempRB[fanId] = this.uiUtils.newRadioButton("Temp", "FT" + fanId);
            ButtonGroup bg = this.fanBG[fanId] = new ButtonGroup();
            bg.add(this.fanOffRB[fanId]);
            bg.add(this.fanSpeedRB[fanId]);
            bg.add(this.fanTempRB[fanId]);
            this.fanSpeedTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "S" + fanId, 2, true);
            this.fanTempTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "T" + fanId, 2, true);
        }
        for (int vlvId = 0; vlvId < 1; ++vlvId) {
            this.valveState[vlvId] = UiUtilities.newLabel((String)"XXX", (int)valveStateWidth);
            this.valveShutRB[vlvId] = this.uiUtils.newRadioButton("Shut", "VF" + vlvId);
            this.valveOpenRB[vlvId] = this.uiUtils.newRadioButton("Open", "VT" + vlvId);
            ButtonGroup bg = this.valveBG[vlvId] = new ButtonGroup();
            bg.add(this.valveShutRB[vlvId]);
            bg.add(this.valveOpenRB[vlvId]);
            this.valvePosnTF[vlvId] = this.uiUtils.newTextFieldX("0000.00", "V" + vlvId, 2, true);
        }
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Power Control");
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        int numColm = 2;
        int colm = 0;
        gbs.gridy = -1;
        gbs.insets.top = 0;
        for (line = 0; line < this.switchLabel.length; ++line) {
            if (this.switchLabel[line] == null) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)this.switchLabel[line], gbs);
            ++gbs.gridx;
            gbs.insets.left = 4;
            this.switchPanel.add((Component)this.switchState[line], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOffRB[line], gbs);
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchOnRB[line], gbs);
            ++gbs.gridx;
            colm = (colm + 1) % numColm;
        }
        this.switchPanel.setMinimumSize(this.switchPanel.getPreferredSize());
        this.utPanel = UiUtilities.newBorderedPanel((String)"UT Cooling Control");
        GridBagConstraints gbu = new GridBagConstraints();
        gbu.anchor = 17;
        gbu.insets = new Insets(4, 4, 0, 4);
        gbu.gridx = 0;
        gbu.gridy = 0;
        this.addFanLine(0, this.utPanel, gbu);
        ++gbu.gridy;
        gbu.insets.top = 0;
        gbu.gridx = 0;
        this.addValveLine(0, this.utPanel, gbu);
        this.utPanel.setMinimumSize(this.utPanel.getPreferredSize());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.statusPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.switchPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.utPanel, gbc);
        ++gbc.gridy;
    }

    private void addFanLine(int fanId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Fan:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.fanState[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanOffRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedTF[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"D/C", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
        if (UTTestFans.hasTempState[fanId]) {
            panel.add((Component)this.fanTempRB[fanId], gbc);
            ++gbc.gridx;
            panel.add((Component)this.fanTempTF[fanId], gbc);
            ++gbc.gridx;
            gbc.insets.left = 0;
            panel.add((Component)UiUtilities.newLabel((String)"\u00b0C", (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
        }
    }

    private void addValveLine(int valveId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Valve:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.valveState[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveShutRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valveOpenRB[valveId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.valvePosnTF[valveId], gbc);
        ++gbc.gridx;
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int id = Integer.valueOf(name.substring(2));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{UTTestSwitches.switchIdToName.get(id), action == 'T'});
                break;
            }
            case 'F': {
                FanState fState = action == 'T' ? FanState.TEMP : (action == 'S' ? FanState.SPEED : FanState.OFF);
                this.sender.sendCommand(null, "setFanState", new Object[]{UTTestFans.fanIdToName.get(id), fState});
                break;
            }
            case 'V': {
                ValveState vState = action == 'T' ? ValveState.POSN : ValveState.SHUT;
                this.sender.sendCommand(null, "setValveState", new Object[]{UTTestValves.valveIdToName.get(id), vState});
            }
        }
    }

    public void handleTextFieldX(String name, Object value) {
        char type = name.charAt(0);
        int id = Integer.valueOf(name.substring(1));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setFanSpeed", new Object[]{UTTestFans.fanIdToName.get(id), (Double)value});
                break;
            }
            case 'T': {
                this.sender.sendCommand(null, "setFanDeltaTemp", new Object[]{UTTestFans.fanIdToName.get(id), (Double)value});
                break;
            }
            case 'V': {
                this.sender.sendCommand(null, "setValvePosition", new Object[]{UTTestValves.valveIdToName.get(id), (Double)value});
            }
        }
    }

    static {
        switchNames.put(1, "BFR 24V PDU");
        switchNames.put(0, "BFR 48V PDU");
        switchNames.put(3, "24V PDU Main");
        switchNames.put(2, "48V PDU Main");
        switchNames.put(4, "Electronics");
        switchStateWidth = UiUtilities.maxEnumLabelWidth(SwitchState.class);
        fanStateWidth = UiUtilities.maxEnumLabelWidth(FanState.class);
        valveStateWidth = UiUtilities.maxEnumLabelWidth(ValveState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            UTTestControlPanel.this.statusPanel.disablePanel();
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int line = (Integer)UTTestControlPanel.this.switchLines.get(swId);
                UTTestControlPanel.this.switchState[line].setEnabled(false);
                UTTestControlPanel.this.switchOffRB[line].setEnabled(false);
                UTTestControlPanel.this.switchOnRB[line].setEnabled(false);
            }
            for (int fanId = 0; fanId < 1; ++fanId) {
                UTTestControlPanel.this.fanState[fanId].setEnabled(false);
                UTTestControlPanel.this.fanOffRB[fanId].setEnabled(false);
                UTTestControlPanel.this.fanSpeedRB[fanId].setEnabled(false);
                UTTestControlPanel.this.fanTempRB[fanId].setEnabled(false);
                UTTestControlPanel.this.fanSpeedTF[fanId].setDisabled();
                UTTestControlPanel.this.fanTempTF[fanId].setDisabled();
            }
            for (int vlvId = 0; vlvId < 1; ++vlvId) {
                UTTestControlPanel.this.valveState[vlvId].setEnabled(false);
                UTTestControlPanel.this.valveShutRB[vlvId].setEnabled(false);
                UTTestControlPanel.this.valveOpenRB[vlvId].setEnabled(false);
                UTTestControlPanel.this.valvePosnTF[vlvId].setDisabled();
            }
            UTTestControlPanel.this.repaint();
        }
    }

    class UpdatePurgeState
    implements Runnable {
        private final UTTestState ps;

        UpdatePurgeState(UTTestState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            JRadioButton selButton;
            UTTestControlPanel.this.statusPanel.updatePanel(this.ps.getTickMillis());
            Iterator iterator = switchNames.keySet().iterator();
            while (iterator.hasNext()) {
                int swId = (Integer)iterator.next();
                int line = (Integer)UTTestControlPanel.this.switchLines.get(swId);
                SwitchState st = this.ps.getSwitchState(swId);
                st = st == null ? SwitchState.OFFLINE : st;
                JLabel label = UTTestControlPanel.this.switchState[line];
                label.setText(st.toString());
                label.setForeground(st == SwitchState.ON ? UiConstants.GREEN : (st == SwitchState.OFF ? Color.BLACK : UiConstants.BLUE));
                st = this.ps.getSwitchBaseState(swId);
                JRadioButton selButton2 = st == SwitchState.ON ? UTTestControlPanel.this.switchOnRB[line] : UTTestControlPanel.this.switchOffRB[line];
                selButton2.setSelected(true);
                UTTestControlPanel.this.switchState[line].setEnabled(true);
                UTTestControlPanel.this.switchOffRB[line].setEnabled(true);
                UTTestControlPanel.this.switchOnRB[line].setEnabled(true);
            }
            for (int fanId = 0; fanId < 1; ++fanId) {
                FanState st = this.ps.getFanState(fanId);
                st = st == null ? FanState.OFFLINE : st;
                JLabel label = UTTestControlPanel.this.fanState[fanId];
                label.setText(st.toString());
                label.setForeground(st == FanState.TEMP ? UiConstants.GREEN : (st == FanState.SPEED ? UiConstants.YELLOW : (st == FanState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getFanBaseState(fanId);
                selButton = st == FanState.TEMP ? UTTestControlPanel.this.fanTempRB[fanId] : (st == FanState.SPEED ? UTTestControlPanel.this.fanSpeedRB[fanId] : UTTestControlPanel.this.fanOffRB[fanId]);
                selButton.setSelected(true);
                UTTestControlPanel.this.fanSpeedTF[fanId].update((Object)this.ps.getFanSpeed(fanId), true);
                UTTestControlPanel.this.fanTempTF[fanId].update((Object)this.ps.getDeltaTemp(fanId), true);
                UTTestControlPanel.this.fanState[fanId].setEnabled(true);
                UTTestControlPanel.this.fanOffRB[fanId].setEnabled(true);
                UTTestControlPanel.this.fanSpeedRB[fanId].setEnabled(true);
                UTTestControlPanel.this.fanTempRB[fanId].setEnabled(true);
            }
            for (int vlvId = 0; vlvId < 1; ++vlvId) {
                ValveState st = this.ps.getValveState(vlvId);
                st = st == null ? ValveState.OFFLINE : st;
                JLabel label = UTTestControlPanel.this.valveState[vlvId];
                label.setText(st.toString());
                label.setForeground(st == ValveState.TEMP ? UiConstants.GREEN : (st == ValveState.POSN ? UiConstants.YELLOW : (st == ValveState.SHUT ? Color.BLACK : UiConstants.BLUE)));
                st = this.ps.getValveBaseState(vlvId);
                selButton = st == ValveState.POSN ? UTTestControlPanel.this.valveOpenRB[vlvId] : UTTestControlPanel.this.valveShutRB[vlvId];
                selButton.setSelected(true);
                UTTestControlPanel.this.valvePosnTF[vlvId].update((Object)this.ps.getValvePosition(vlvId), true);
                UTTestControlPanel.this.valveState[vlvId].setEnabled(true);
                UTTestControlPanel.this.valveShutRB[vlvId].setEnabled(true);
                UTTestControlPanel.this.valveOpenRB[vlvId].setEnabled(true);
            }
            UTTestControlPanel.this.repaint();
        }
    }
}

