/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.WriterProvider;

class FileWriterProvider
extends WriterProvider {
    private static final Logger LOG = Logger.getLogger(FileWriterProvider.class.getName());

    FileWriterProvider() {
    }

    @Override
    public PrintWriter getPrintWriter(String fileName) throws IOException {
        String tmpFileName = fileName;
        File parentFile = new File(fileName).getParentFile();
        if (parentFile == null) {
            String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)fileName);
            if (pathInBootstrap == null) {
                String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
                if (topMostUserDirectory == null) {
                    throw new RuntimeException("There is no external resource directory in which to write the file. Please make sure to define one using environment variable CCS_RESOURCE_PATH.");
                }
                fileName = topMostUserDirectory + fileName;
            } else {
                fileName = pathInBootstrap;
            }
        } else if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        LOG.log(Level.INFO, "Saving {0} to {1}", new Object[]{tmpFileName, fileName});
        return new PrintWriter(fileName, "ISO-8859-1");
    }

    @Override
    public Properties getProperties(String fileName) throws IOException {
        Properties configProps = new Properties();
        InputStream propsIs = null;
        propsIs = BootstrapResourceUtils.getBootstrapResource((String)fileName);
        if (propsIs == null) {
            return null;
        }
        LOG.log(Level.INFO, "Found configuration file : {0}", BootstrapResourceUtils.getResourceURL((String)fileName).getPath());
        configProps.load(propsIs);
        return configProps;
    }

    @Override
    Set<String> findMatchingPropertiesFiles(String pattern) {
        return BootstrapResourceUtils.findMatchingResources((String)pattern);
    }

    @Override
    String locateFile(String fileName) {
        return BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)fileName);
    }
}

